/*
 * Decompiled with CFR 0.152.
 */
package com.dtolabs.launcher;

import com.dtolabs.rundeck.core.Constants;
import com.dtolabs.rundeck.core.utils.PropertyUtil;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Map;
import java.util.Properties;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class Preferences {
    public static final String JAVA_HOME = Constants.JAVA_HOME;
    public static final String ENV_JAVA_HOME = System.getProperty("user.java_home");
    public static final String SYSTEM_RDECK_BASE = Constants.getSystemBaseDir();
    public static final String RUNDECK_DEFAULTS_PROPERTIES_NAME = Constants.getDefaultsPropertiesName();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void generate(String[] args, String preferences, Properties inputProps) throws Exception {
        String base = inputProps.getProperty("rdeck.base");
        if ((null == ENV_JAVA_HOME || "".equals(ENV_JAVA_HOME)) && (null == JAVA_HOME || "".equals(JAVA_HOME))) {
            throw new Exception("property: java.home, not defined");
        }
        if (null == base) {
            base = SYSTEM_RDECK_BASE;
        }
        if (null == base || "".equals(base)) {
            throw new Exception("property: rdeck.base, not defined");
        }
        File baseDir = new File(base);
        if (!baseDir.isDirectory()) {
            if (baseDir.exists()) {
                throw new Exception(base + " exists and is not a directory");
            }
            if (!baseDir.mkdirs()) {
                throw new Exception(base + " does not exist and cannot be created");
            }
        }
        Properties systemProperties = System.getProperties();
        Properties defaultProperties = new Properties();
        String jhome = ENV_JAVA_HOME;
        if (null == jhome) {
            jhome = JAVA_HOME;
        }
        defaultProperties.setProperty("user.java_home", Preferences.forwardSlashPath(jhome));
        defaultProperties.setProperty("user.java_home.win", Preferences.backSlashPath(jhome));
        defaultProperties.setProperty("java.home", Preferences.forwardSlashPath(jhome));
        defaultProperties.setProperty("java.home.win", Preferences.backSlashPath(jhome));
        defaultProperties.setProperty("rdeck.base", Preferences.forwardSlashPath(base));
        defaultProperties.setProperty("rdeck.base.win", Preferences.backSlashPath(base));
        defaultProperties.setProperty("framework.projects.dir", Preferences.forwardSlashPath(Constants.getFrameworkProjectsDir(base)));
        defaultProperties.setProperty("framework.projects.dir.win", Preferences.backSlashPath(Constants.getFrameworkProjectsDir(base)));
        defaultProperties.setProperty("framework.rdeck.base", Preferences.forwardSlashPath(base));
        defaultProperties.setProperty("framework.rdeck.base.win", Preferences.backSlashPath(base));
        String configDir = Constants.getFrameworkConfigDir(base);
        defaultProperties.setProperty("framework.etc.dir", Preferences.forwardSlashPath(configDir));
        defaultProperties.setProperty("framework.etc.dir.win", Preferences.backSlashPath(configDir));
        defaultProperties.setProperty("framework.var.dir", Preferences.forwardSlashPath(Constants.getBaseVar(base)));
        defaultProperties.setProperty("framework.var.dir.win", Preferences.backSlashPath(Constants.getBaseVar(base)));
        defaultProperties.setProperty("framework.logs.dir", Preferences.forwardSlashPath(Constants.getFrameworkLogsDir(base)));
        defaultProperties.setProperty("framework.logs.dir.win", Preferences.backSlashPath(Constants.getFrameworkLogsDir(base)));
        Enumeration<?> propEnum = systemProperties.propertyNames();
        HashSet<String> paths = new HashSet<String>();
        paths.add("user.home");
        while (propEnum.hasMoreElements()) {
            String propName = (String)propEnum.nextElement();
            String propType = propName.split("\\.")[0];
            String value = systemProperties.getProperty(propName);
            if (paths.contains(propName)) {
                value = Preferences.forwardSlashPath(value);
            }
            defaultProperties.setProperty(propName, value);
        }
        Preferences.loadResourcesDefaults(defaultProperties, RUNDECK_DEFAULTS_PROPERTIES_NAME);
        defaultProperties.putAll((Map<?, ?>)inputProps);
        Preferences.parseNonReqOptionsAsProperties(defaultProperties, args);
        Properties expandedDefaultProperties = PropertyUtil.expand(defaultProperties);
        File rdeck_base_etc = new File(configDir);
        if (!rdeck_base_etc.isDirectory() && !rdeck_base_etc.mkdir()) {
            throw new Exception("Unable to create directory: " + configDir);
        }
        try (FileOutputStream fileOutputStream = new FileOutputStream(preferences);){
            expandedDefaultProperties.store(fileOutputStream, "rdeck setup preferences");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void loadDefaults(Properties defaultProperties, String propertiesFile) throws IOException {
        FileInputStream fis = new FileInputStream(propertiesFile);
        try {
            defaultProperties.load(fis);
        }
        finally {
            if (null != fis) {
                fis.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void loadResourcesDefaults(Properties defaultProperties, String propertiesFileName) throws IOException {
        String resource = "com/dtolabs/launcher/setup/templates/" + propertiesFileName;
        InputStream is = Preferences.class.getClassLoader().getResourceAsStream(resource);
        if (null == is) {
            throw new IOException("Unable to load resource: " + resource);
        }
        try {
            defaultProperties.load(is);
        }
        finally {
            if (null != is) {
                is.close();
            }
        }
    }

    public static void parseNonReqOptionsAsProperties(Properties defaultProperties, String[] args) throws Exception {
        for (String argProp : args) {
            if (!argProp.startsWith("--")) continue;
            String propName = Preferences.convert2PropName(argProp);
            int equalsAt = argProp.indexOf(61);
            String propValue = argProp.substring(equalsAt + 1);
            if (null == propValue || "".equals(propValue)) {
                throw new Exception("argument: " + argProp + " not valid");
            }
            defaultProperties.setProperty(propName, propValue);
        }
    }

    private static String convert2PropName(String argProp) throws Exception {
        if (!argProp.startsWith("--")) {
            throw new Exception("argument: " + argProp + " does not start with --");
        }
        if (argProp.indexOf("=") == -1) {
            throw new Exception("argument: " + argProp + " does not contain an = sign");
        }
        String argProperty = argProp.substring(2);
        if (null == argProperty || "".equals(argProperty)) {
            throw new Exception("argument: " + argProp + " not valid");
        }
        String argPropName = argProperty.split("=")[0];
        if (null == argPropName || "".equals(argPropName)) {
            throw new Exception("argument: " + argProp + " not valid");
        }
        int equalsAt = argProperty.indexOf(61);
        String argPropValue = argProperty.substring(equalsAt + 1);
        if (null == argPropValue || "".equals(argPropValue)) {
            throw new Exception("argument: " + argProp + " not valid");
        }
        return argPropName;
    }

    public static String forwardSlashPath(String input) {
        if (System.getProperties().get("file.separator").equals("\\")) {
            return input.replaceAll("\\\\", "/");
        }
        return input;
    }

    public static String backSlashPath(String input) {
        if (System.getProperties().get("file.separator").equals("\\")) {
            return input.replaceAll(Pattern.quote("/"), Matcher.quoteReplacement("\\"));
        }
        return input;
    }
}

