/*
 * Decompiled with CFR 0.152.
 */
package com.dtolabs.rundeck.core.authorization;

import com.dtolabs.rundeck.core.authorization.Attribute;
import java.net.URI;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;

public class AuthorizationUtil {
    public static final String TYPE_FIELD = "type";
    public static final String TYPE_KIND_FIELD = "kind";
    public static final String GENERIC_RESOURCE_TYPE_NAME = "resource";

    public static Map<String, String> resource(String type) {
        return AuthorizationUtil.resource(type, null);
    }

    public static Map<String, String> resource(String type, Map<String, String> meta) {
        HashMap<String, String> authResource = new HashMap<String, String>();
        if (null != meta) {
            authResource.putAll(meta);
        }
        authResource.put(TYPE_FIELD, type);
        return authResource;
    }

    public static Map<String, Object> resourceRule(String type, Map<String, Object> meta) {
        HashMap<String, Object> authResource = new HashMap<String, Object>();
        if (null != meta) {
            authResource.putAll(meta);
        }
        authResource.put(TYPE_FIELD, type);
        return authResource;
    }

    public static Map<String, String> resourceType(String kind) {
        return AuthorizationUtil.resourceType(kind, null);
    }

    public static Map<String, Object> resourceTypeRule(String kind) {
        return AuthorizationUtil.resourceTypeRule(kind, null);
    }

    public static Map<String, String> resourceType(String kind, Map<String, String> meta) {
        HashMap<String, String> authResource = new HashMap<String, String>();
        if (null != meta) {
            authResource.putAll(meta);
        }
        authResource.put(TYPE_FIELD, GENERIC_RESOURCE_TYPE_NAME);
        authResource.put(TYPE_KIND_FIELD, kind);
        return authResource;
    }

    public static Map<String, Object> resourceTypeRule(String kind, Map<String, Object> meta) {
        HashMap<String, Object> authResource = new HashMap<String, Object>();
        if (null != meta) {
            authResource.putAll(meta);
        }
        authResource.put(TYPE_FIELD, GENERIC_RESOURCE_TYPE_NAME);
        authResource.put(TYPE_KIND_FIELD, kind);
        return authResource;
    }

    public static Set<Attribute> projectContext(String projectName) {
        return AuthorizationUtil.context("project", projectName);
    }

    public static Set<Attribute> context(String key, String value) {
        if (null == key) {
            throw new IllegalArgumentException("key cannot be null");
        }
        if (null == value) {
            throw new IllegalArgumentException("value cannot be null");
        }
        return Collections.singleton(new Attribute(URI.create("http://dtolabs.com/rundeck/env/" + key), value));
    }

    public static String contextAsString(Set<Attribute> context) {
        StringBuilder sb = new StringBuilder();
        for (Attribute attribute : context) {
            if (sb.length() < 1) {
                sb.append("{");
            } else {
                sb.append(", ");
            }
            sb.append(Attribute.propertyKeyForURIBase(attribute, "http://dtolabs.com/rundeck/env/")).append("=").append(attribute.getValue());
        }
        sb.append("}");
        return sb.toString();
    }
}

