/*
 * Decompiled with CFR 0.152.
 */
package com.dtolabs.rundeck.core.execution.impl.common;

import com.dtolabs.rundeck.core.common.Framework;
import com.dtolabs.rundeck.core.common.IFramework;
import com.dtolabs.rundeck.core.common.INodeEntry;
import com.dtolabs.rundeck.core.common.IRundeckProject;
import com.dtolabs.rundeck.core.dispatcher.DataContextUtils;
import com.dtolabs.rundeck.core.execution.ExecutionContext;
import com.dtolabs.rundeck.core.execution.script.ScriptfileUtils;
import com.dtolabs.rundeck.core.execution.service.FileCopierException;
import com.dtolabs.rundeck.core.execution.workflow.steps.StepFailureReason;
import com.dtolabs.utils.Streams;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStreamWriter;
import java.io.StringReader;
import java.io.Writer;
import java.util.Map;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.commons.lang.RandomStringUtils;

public class BaseFileCopier {
    public static final String FILE_COPY_DESTINATION_DIR = "file-copy-destination-dir";
    public static final String FRAMEWORK_FILE_COPY_DESTINATION_DIR = "framework.file-copy-destination-dir";
    public static final String PROJECT_FILE_COPY_DESTINATION_DIR = "project.file-copy-destination-dir";
    public static final String DEFAULT_WINDOWS_FILE_EXT = ".bat";
    public static final String DEFAULT_UNIX_FILE_EXT = ".sh";
    private static AtomicLong counter = new AtomicLong(0L);

    public static File writeScriptTempFile(ExecutionContext context, File original, InputStream input, String script, INodeEntry node) throws FileCopierException {
        return BaseFileCopier.writeScriptTempFile(context, original, input, script, node, null);
    }

    public static File writeScriptTempFile(ExecutionContext context, File original, InputStream input, String script, INodeEntry node, File destination) throws FileCopierException {
        File tempfile;
        block31: {
            Framework framework = context.getFramework();
            Map<String, Map<String, String>> origContext = context.getDataContext();
            Map<String, Map<String, String>> dataContext = DataContextUtils.addContext("node", DataContextUtils.nodeData(node), origContext);
            ScriptfileUtils.LineEndingStyle style = ScriptfileUtils.lineEndingStyleForNode(node);
            try {
                tempfile = null == destination ? ScriptfileUtils.createTempFile(framework) : destination;
                if (null != original) {
                    try (FileInputStream in = new FileInputStream(original);
                         FileOutputStream out = new FileOutputStream(tempfile);){
                        Streams.copyStream(in, out);
                        break block31;
                    }
                }
                if (null != script) {
                    DataContextUtils.replaceTokensInScript(script, dataContext, framework, style, tempfile);
                    break block31;
                }
                if (null != input) {
                    DataContextUtils.replaceTokensInStream(input, dataContext, framework, style, tempfile);
                    break block31;
                }
                return null;
            }
            catch (IOException e) {
                throw new FileCopierException("error writing script to tempfile: " + e.getMessage(), StepFailureReason.IOFailure, e);
            }
        }
        try {
            ScriptfileUtils.setExecutePermissions(tempfile);
        }
        catch (IOException e) {
            System.err.println("Failed to set execute permissions on tempfile, execution may fail: " + tempfile.getAbsolutePath());
        }
        return tempfile;
    }

    public static String defaultRemoteFileExtensionForNode(INodeEntry node) {
        if (null != node.getOsFamily() && "windows".equalsIgnoreCase(node.getOsFamily().trim())) {
            return DEFAULT_WINDOWS_FILE_EXT;
        }
        return DEFAULT_UNIX_FILE_EXT;
    }

    public static String appendRemoteFileExtension(String filepath, String fileext) {
        if (null == fileext) {
            return filepath;
        }
        String result = filepath;
        String ext = fileext;
        if (!ext.startsWith(".")) {
            ext = "." + fileext;
        }
        result = result + (filepath.endsWith(ext) ? "" : ext);
        return result;
    }

    public static String getRemoteDirForNode(INodeEntry node) {
        String pathSeparator = "/";
        String remotedir = "/tmp/";
        if (null != node.getOsFamily() && "windows".equalsIgnoreCase(node.getOsFamily().trim())) {
            pathSeparator = "\\";
            remotedir = "C:\\WINDOWS\\TEMP\\";
        }
        if (null != node.getAttributes() && null != node.getAttributes().get(FILE_COPY_DESTINATION_DIR)) {
            String s = node.getAttributes().get(FILE_COPY_DESTINATION_DIR);
            return s.endsWith(pathSeparator) ? s : s + pathSeparator;
        }
        return remotedir;
    }

    public static String getRemoteDirForNode(INodeEntry node, IRundeckProject project, IFramework framework) {
        String osfamily;
        String pathSeparator = "/";
        String remotedir = "/tmp/";
        String string = osfamily = null != node.getOsFamily() ? node.getOsFamily().trim().toLowerCase() : "unix";
        if ("windows".equalsIgnoreCase(osfamily)) {
            pathSeparator = "\\";
            remotedir = "C:\\WINDOWS\\TEMP\\";
        }
        if (null != node.getAttributes() && null != node.getAttributes().get(FILE_COPY_DESTINATION_DIR)) {
            String s = node.getAttributes().get(FILE_COPY_DESTINATION_DIR);
            return s.endsWith(pathSeparator) ? s : s + pathSeparator;
        }
        if (null != project && project.hasProperty("project.file-copy-destination-dir." + osfamily)) {
            String s = project.getProperty("project.file-copy-destination-dir." + osfamily);
            return s.endsWith(pathSeparator) ? s : s + pathSeparator;
        }
        if (null != project && project.hasProperty(PROJECT_FILE_COPY_DESTINATION_DIR)) {
            String s = project.getProperty(PROJECT_FILE_COPY_DESTINATION_DIR);
            return s.endsWith(pathSeparator) ? s : s + pathSeparator;
        }
        if (null != framework && framework.getPropertyLookup().hasProperty("framework.file-copy-destination-dir." + osfamily)) {
            String s = framework.getPropertyLookup().getProperty("framework.file-copy-destination-dir." + osfamily);
            return s.endsWith(pathSeparator) ? s : s + pathSeparator;
        }
        if (null != framework && framework.getPropertyLookup().hasProperty(FRAMEWORK_FILE_COPY_DESTINATION_DIR)) {
            String s = framework.getPropertyLookup().getProperty(FRAMEWORK_FILE_COPY_DESTINATION_DIR);
            return s.endsWith(pathSeparator) ? s : s + pathSeparator;
        }
        return remotedir;
    }

    public static String generateRemoteFilepathForNode(INodeEntry node, String scriptfileName) {
        return BaseFileCopier.generateRemoteFilepathForNode(node, scriptfileName, null);
    }

    public static String generateRemoteFilepathForNode(INodeEntry node, String scriptfileName, String fileExtension) {
        return BaseFileCopier.generateRemoteFilepathForNode(node, scriptfileName, fileExtension, null);
    }

    public static String generateRemoteFilepathForNode(INodeEntry node, String scriptfileName, String fileExtension, String identity) {
        return BaseFileCopier.generateRemoteFilepathForNode(node, null, null, scriptfileName, fileExtension, identity);
    }

    public static String generateRemoteFilepathForNode(INodeEntry node, IRundeckProject project, IFramework framework, String scriptfileName, String fileExtension, String identity) {
        String tempfilename = String.format("%d-%s-%s-%s", counter.getAndIncrement(), identity != null ? identity : RandomStringUtils.randomAlphanumeric((int)10), node.getNodename(), scriptfileName);
        String extension = fileExtension;
        if (null == extension) {
            extension = BaseFileCopier.defaultRemoteFileExtensionForNode(node);
        }
        String remoteFilename = BaseFileCopier.appendRemoteFileExtension(BaseFileCopier.cleanFileName(tempfilename), null != extension ? BaseFileCopier.cleanFileName(extension) : null);
        String remotedir = BaseFileCopier.getRemoteDirForNode(node, project, framework);
        return remotedir + remoteFilename;
    }

    private static String cleanFileName(String nodename) {
        return nodename.replaceAll("[^a-zA-Z0-9_.-]", "_");
    }

    public static File writeTempFile(ExecutionContext context, File original, InputStream input, String script) throws FileCopierException {
        File tempfile = null;
        try {
            tempfile = ScriptfileUtils.createTempFile(context.getFramework());
        }
        catch (IOException e) {
            throw new FileCopierException("error writing to tempfile: " + e.getMessage(), StepFailureReason.IOFailure, e);
        }
        return BaseFileCopier.writeLocalFile(original, input, script, tempfile);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static File writeLocalFile(File original, InputStream input, String script, File destinationFile) throws FileCopierException {
        try {
            block17: {
                if (null != original) {
                    try (FileInputStream in = new FileInputStream(original);
                         FileOutputStream out = new FileOutputStream(destinationFile);){
                        Streams.copyStream(in, out);
                        break block17;
                    }
                }
                if (null != input) {
                    InputStream in = input;
                    try (FileOutputStream out = new FileOutputStream(destinationFile);){
                        Streams.copyStream(in, out);
                    }
                }
                if (null != script) {
                    StringReader in = new StringReader(script);
                    FileOutputStream out = new FileOutputStream(destinationFile);
                    OutputStreamWriter write = new OutputStreamWriter(out);
                    try {
                        Streams.copyWriterCount(in, write);
                        ((Writer)write).flush();
                    }
                    finally {
                        out.close();
                    }
                }
            }
            return destinationFile;
        }
        catch (IOException e) {
            throw new FileCopierException("error writing to tempfile: " + e.getMessage(), StepFailureReason.IOFailure, e);
        }
    }
}

