/*
 * Decompiled with CFR 0.152.
 */
package com.dtolabs.rundeck.core.execution.workflow.steps.node;

import com.dtolabs.rundeck.core.common.INodeEntry;
import com.dtolabs.rundeck.core.dispatcher.DataContextUtils;
import com.dtolabs.rundeck.core.execution.ConfiguredStepExecutionItem;
import com.dtolabs.rundeck.core.execution.StepExecutionItem;
import com.dtolabs.rundeck.core.execution.workflow.StepExecutionContext;
import com.dtolabs.rundeck.core.execution.workflow.steps.PluginStepContextImpl;
import com.dtolabs.rundeck.core.execution.workflow.steps.StepFailureReason;
import com.dtolabs.rundeck.core.execution.workflow.steps.node.NodeStepException;
import com.dtolabs.rundeck.core.execution.workflow.steps.node.NodeStepExecutionItem;
import com.dtolabs.rundeck.core.execution.workflow.steps.node.NodeStepExecutor;
import com.dtolabs.rundeck.core.execution.workflow.steps.node.NodeStepResult;
import com.dtolabs.rundeck.core.execution.workflow.steps.node.NodeStepResultImpl;
import com.dtolabs.rundeck.core.plugins.configuration.Describable;
import com.dtolabs.rundeck.core.plugins.configuration.Description;
import com.dtolabs.rundeck.core.plugins.configuration.PluginAdapterUtility;
import com.dtolabs.rundeck.core.plugins.configuration.PropertyResolver;
import com.dtolabs.rundeck.core.plugins.configuration.PropertyResolverFactory;
import com.dtolabs.rundeck.core.plugins.configuration.PropertyScope;
import com.dtolabs.rundeck.core.utils.Converter;
import com.dtolabs.rundeck.plugins.step.NodeStepPlugin;
import com.dtolabs.rundeck.plugins.util.DescriptionBuilder;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.Map;
import org.apache.log4j.Logger;

class NodeStepPluginAdapter
implements NodeStepExecutor,
Describable {
    protected static Logger log = Logger.getLogger((String)NodeStepPluginAdapter.class.getName());
    private NodeStepPlugin plugin;
    public static final Convert CONVERTER = new Convert();

    @Override
    public Description getDescription() {
        if (this.plugin instanceof Describable) {
            Describable desc = (Describable)((Object)this.plugin);
            return desc.getDescription();
        }
        return PluginAdapterUtility.buildDescription(this.plugin, DescriptionBuilder.builder());
    }

    public NodeStepPluginAdapter(NodeStepPlugin plugin) {
        this.plugin = plugin;
    }

    @Override
    public NodeStepResult executeNodeStep(StepExecutionContext context, NodeStepExecutionItem item, INodeEntry node) throws NodeStepException {
        Map<String, Object> instanceConfiguration = this.getStepConfiguration(item);
        if (null != instanceConfiguration) {
            instanceConfiguration = DataContextUtils.replaceDataReferences(instanceConfiguration, context.getDataContext());
        }
        String providerName = item.getNodeStepType();
        PropertyResolver resolver = PropertyResolverFactory.createStepPluginRuntimeResolver(context, instanceConfiguration, "WorkflowNodeStep", providerName);
        PluginStepContextImpl pluginContext = PluginStepContextImpl.from(context);
        Map<String, Object> config = PluginAdapterUtility.configureProperties(resolver, this.getDescription(), this.plugin, PropertyScope.InstanceOnly);
        try {
            this.plugin.executeNodeStep(pluginContext, config, node);
        }
        catch (NodeStepException e) {
            log.error((Object)"Error executing node step.", (Throwable)e);
            return new NodeStepResultImpl(e, e.getFailureReason(), e.getMessage(), e.getFailureData(), node);
        }
        catch (Throwable e) {
            log.error((Object)"Uncaught throwable executing node step.", e);
            StringWriter stringWriter = new StringWriter();
            e.printStackTrace(new PrintWriter(stringWriter));
            context.getExecutionListener().log(4, "Failed executing node plugin [" + providerName + "] on node " + node.getNodename() + ": " + stringWriter.toString());
            return new NodeStepResultImpl(e, StepFailureReason.PluginFailed, e.getMessage(), node);
        }
        return new NodeStepResultImpl(node);
    }

    private Map<String, Object> getStepConfiguration(StepExecutionItem item) {
        if (item instanceof ConfiguredStepExecutionItem) {
            return ((ConfiguredStepExecutionItem)item).getStepConfiguration();
        }
        return null;
    }

    static class Convert
    implements Converter<NodeStepPlugin, NodeStepExecutor> {
        Convert() {
        }

        @Override
        public NodeStepExecutor convert(NodeStepPlugin plugin) {
            return new NodeStepPluginAdapter(plugin);
        }
    }
}

