/*
 * Decompiled with CFR 0.152.
 */
package com.dtolabs.rundeck.core.plugins;

import com.dtolabs.rundeck.core.Constants;
import com.dtolabs.rundeck.core.plugins.DirPluginScanner;
import com.dtolabs.rundeck.core.plugins.JarPluginProviderLoader;
import com.dtolabs.rundeck.core.plugins.ProviderLoader;
import com.dtolabs.rundeck.core.utils.FileUtils;
import com.dtolabs.rundeck.core.utils.cache.FileCache;
import java.io.File;
import java.io.FileFilter;
import org.apache.log4j.Logger;

public class JarPluginScanner
extends DirPluginScanner {
    static Logger log = Logger.getLogger((String)JarPluginScanner.class.getName());
    public static final FileFilter FILENAME_FILTER = new FileFilter(){

        @Override
        public boolean accept(File file) {
            return file.isFile() && file.getName().endsWith(".jar");
        }
    };
    public static final String JAR_SCRATCH_DIRECTORY = "pluginJars";
    final File cachedir;
    final File pluginJarCacheDirectory;

    JarPluginScanner(File extdir, File cachedir, FileCache<ProviderLoader> filecache, int rescanInterval) {
        super(extdir, filecache, rescanInterval);
        this.cachedir = cachedir;
        this.pluginJarCacheDirectory = new File(Constants.getBaseTempDirectory() + Constants.FILE_SEP + JAR_SCRATCH_DIRECTORY);
        log.info((Object)String.format("Deleting plugin jar cache at %s", this.pluginJarCacheDirectory));
        if (this.pluginJarCacheDirectory.exists() && !FileUtils.deleteDir(this.pluginJarCacheDirectory)) {
            log.warn((Object)"Could not delete plugin jar cache");
        }
        log.info((Object)String.format("Deleting plugin lib dependency directory at %s", this.cachedir));
        if (this.cachedir.exists() && !FileUtils.deleteDir(this.cachedir)) {
            log.warn((Object)"Could not delete plugin lib dependency directory");
        }
        this.cachedir.mkdirs();
        this.pluginJarCacheDirectory.mkdirs();
    }

    @Override
    public boolean isValidPluginFile(File file) {
        return JarPluginProviderLoader.isValidJarPlugin(file);
    }

    @Override
    public FileFilter getFileFilter() {
        return FILENAME_FILTER;
    }

    @Override
    public ProviderLoader createCacheItemForFile(File file) {
        return this.createLoader(file);
    }

    @Override
    public ProviderLoader createLoader(File file) {
        if (log.isDebugEnabled()) {
            log.debug((Object)("create JarFileProviderLoader: " + file));
        }
        return new JarPluginProviderLoader(file, this.pluginJarCacheDirectory, this.cachedir, JarPluginProviderLoader.getLoadLocalLibsFirstForFile(file));
    }

    @Override
    protected String getVersionForFile(File file) {
        return JarPluginProviderLoader.getVersionForFile(file);
    }
}

