/*
 * Decompiled with CFR 0.152.
 */
package com.dtolabs.rundeck.core.authorization;

import com.dtolabs.rundeck.core.authorization.AclRule;
import com.dtolabs.rundeck.core.authorization.AclRuleSet;
import com.dtolabs.rundeck.core.authorization.AclRuleSetImpl;
import com.dtolabs.rundeck.core.authorization.AclRuleSetSource;
import com.dtolabs.rundeck.core.authorization.Authorization;
import com.dtolabs.rundeck.core.authorization.MultiAuthorization;
import com.dtolabs.rundeck.core.authorization.RuleEvaluator;
import com.dtolabs.rundeck.core.authorization.providers.Policies;
import java.util.HashSet;
import java.util.Set;

public class AclsUtil {
    public static Authorization createAuthorization(Policies policies) {
        return RuleEvaluator.createRuleEvaluator(policies);
    }

    public static Set<String> getGroups(AclRuleSetSource source) {
        HashSet<String> strings = new HashSet<String>();
        for (AclRule rule : source.getRuleSet().getRules()) {
            if (rule.getGroup() == null) continue;
            strings.add(rule.getGroup());
        }
        return strings;
    }

    public static Authorization append(Authorization a, Authorization b) {
        if (a instanceof AclRuleSetSource && b instanceof AclRuleSetSource) {
            return RuleEvaluator.createRuleEvaluator(AclsUtil.merge((AclRuleSetSource)((Object)a), (AclRuleSetSource)((Object)b)));
        }
        return new MultiAuthorization(a, b);
    }

    public static AclRuleSetSource source(final AclRuleSet a) {
        return new AclRuleSetSource(){

            @Override
            public AclRuleSet getRuleSet() {
                return a;
            }
        };
    }

    public static AclRuleSetSource merge(final AclRuleSetSource a, final AclRuleSetSource b) {
        return new AclRuleSetSource(){

            @Override
            public AclRuleSet getRuleSet() {
                HashSet<AclRule> aclRules = new HashSet<AclRule>(a.getRuleSet().getRules());
                aclRules.addAll(b.getRuleSet().getRules());
                return new AclRuleSetImpl(aclRules);
            }
        };
    }
}

