/*
 * Decompiled with CFR 0.152.
 */
package com.dtolabs.rundeck.core.authorization;

import com.dtolabs.rundeck.core.authorization.Attribute;
import com.dtolabs.rundeck.core.authorization.Authorization;
import com.dtolabs.rundeck.core.authorization.Decision;
import com.dtolabs.rundeck.core.authorization.Explanation;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.security.auth.Subject;

public class MultiAuthorization
implements Authorization {
    private Authorization auth1;
    private Authorization auth2;

    public MultiAuthorization(Authorization auth1, Authorization auth2) {
        this.auth1 = auth1;
        this.auth2 = auth2;
    }

    @Override
    public Decision evaluate(Map<String, String> resource, Subject subject, String action, Set<Attribute> environment) {
        Decision evaluate = this.auth1.evaluate(resource, subject, action, environment);
        if (evaluate.explain().getCode() == Explanation.Code.REJECTED_DENIED) {
            return evaluate;
        }
        Decision evaluate2 = this.auth2.evaluate(resource, subject, action, environment);
        if (evaluate2.explain().getCode() == Explanation.Code.REJECTED_DENIED) {
            return evaluate2;
        }
        if (evaluate.isAuthorized()) {
            return evaluate;
        }
        return evaluate2;
    }

    @Override
    public Set<Decision> evaluate(Set<Map<String, String>> resources, Subject subject, Set<String> actions, Set<Attribute> environment) {
        Set<Decision> evaluate = this.auth1.evaluate(resources, subject, actions, environment);
        HashMap result1 = new HashMap();
        for (Decision decision : evaluate) {
            if (null == result1.get(decision.getResource())) {
                result1.put(decision.getResource(), new HashMap());
            }
            Map stringDecisionMap = (Map)result1.get(decision.getResource());
            stringDecisionMap.put(decision.getAction(), decision);
        }
        Set<Decision> evaluate2 = this.auth2.evaluate(resources, subject, actions, environment);
        HashSet<Decision> result = new HashSet<Decision>();
        for (Decision decision2 : evaluate2) {
            Decision decision1 = (Decision)((Map)result1.get(decision2.getResource())).get(decision2.getAction());
            if (decision1.explain().getCode() == Explanation.Code.REJECTED_DENIED) {
                result.add(decision1);
                continue;
            }
            if (decision2.explain().getCode() == Explanation.Code.REJECTED_DENIED) {
                result.add(decision2);
                continue;
            }
            if (decision1.isAuthorized()) {
                result.add(decision1);
                continue;
            }
            result.add(decision2);
        }
        return result;
    }
}

