/*
 * Decompiled with CFR 0.152.
 */
package com.dtolabs.rundeck.core.authorization.providers;

import com.dtolabs.rundeck.core.authorization.AclRule;
import com.dtolabs.rundeck.core.authorization.AclRuleBuilder;
import com.dtolabs.rundeck.core.authorization.AclRuleSet;
import com.dtolabs.rundeck.core.authorization.AclRuleSetImpl;
import com.dtolabs.rundeck.core.authorization.Attribute;
import com.dtolabs.rundeck.core.authorization.AuthorizationUtil;
import com.dtolabs.rundeck.core.authorization.BasicEnvironmentalContext;
import com.dtolabs.rundeck.core.authorization.ValidationSet;
import com.dtolabs.rundeck.core.authorization.providers.AclPolicySyntaxException;
import com.dtolabs.rundeck.core.authorization.providers.EnvironmentalContext;
import com.dtolabs.rundeck.core.authorization.providers.Policy;
import com.dtolabs.rundeck.core.authorization.providers.YamlPolicyCollection;
import com.dtolabs.rundeck.core.authorization.providers.YamlSource;
import com.dtolabs.rundeck.core.authorization.providers.yaml.model.ACLPolicyDoc;
import com.dtolabs.rundeck.core.authorization.providers.yaml.model.YamlPolicyDocConstructor;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Predicate;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import java.util.stream.Collectors;
import org.yaml.snakeyaml.Yaml;
import org.yaml.snakeyaml.constructor.BaseConstructor;
import org.yaml.snakeyaml.constructor.ConstructorException;
import org.yaml.snakeyaml.error.YAMLException;

public class YamlParsePolicy
implements Policy {
    public static final String BY_SECTION = "by";
    public static final String USERNAME_KEY = "username";
    public static final String GROUP_KEY = "group";
    ACLPolicyDoc policyDoc;
    String sourceIdent;
    int sourceIndex;
    ValidationSet validation;
    private YamlEnvironmentalContext environment;
    private Set<String> usernames = new HashSet<String>();
    private Set<String> groups = new HashSet<String>();
    private Set<AclRule> rules = new HashSet<AclRule>();

    private YamlParsePolicy(Set<Attribute> context, ACLPolicyDoc policyDoc, String sourceIdent, int sourceIndex, ValidationSet validation) {
        this.policyDoc = policyDoc;
        this.sourceIdent = sourceIdent;
        this.sourceIndex = sourceIndex;
        this.validation = validation;
        this.validate();
        this.parseEnvironment(context);
        this.parseByClause();
        this.enumerateRules();
    }

    private Set<AclRule> createRules(AclRuleBuilder proto) {
        HashSet<AclRule> aclRules = new HashSet<AclRule>();
        for (Map.Entry<String, List<ACLPolicyDoc.TypeRule>> typeRules : this.policyDoc.getFor().entrySet()) {
            AclRuleBuilder builder = AclRuleBuilder.builder(proto);
            String type = typeRules.getKey();
            builder.sourceIdentityAppend("[type:" + type + "]");
            builder.resourceType(type);
            List<ACLPolicyDoc.TypeRule> value = typeRules.getValue();
            aclRules.addAll(this.createRules(type, value, builder));
        }
        return aclRules;
    }

    private Set<? extends AclRule> createRules(String type, List<ACLPolicyDoc.TypeRule> typeRules, AclRuleBuilder proto) {
        HashSet<AclRule> aclRules = new HashSet<AclRule>();
        int i = 1;
        for (ACLPolicyDoc.TypeRule typeRule : typeRules) {
            AclRuleBuilder builder = AclRuleBuilder.builder(proto);
            aclRules.add(this.createRule(type, i++, typeRule, builder));
        }
        return aclRules;
    }

    private AclRule createRule(String type, int index, ACLPolicyDoc.TypeRule typeRule, AclRuleBuilder prototype) {
        AclRuleBuilder ruleBuilder = AclRuleBuilder.builder(prototype);
        Object allow = typeRule.getAllow();
        Object deny = typeRule.getDeny();
        HashSet<String> allowActions = null != typeRule.getAllow() ? typeRule.getAllowActions() : new HashSet<String>();
        HashSet<String> denyActions = null != typeRule.getDeny() ? typeRule.getDenyActions() : new HashSet<String>();
        ruleBuilder.sourceIdentityAppend("[rule: " + index + "]").allowActions(allowActions).denyActions(denyActions).regexResource(typeRule.getMatch()).containsResource(typeRule.getContains()).subsetResource(typeRule.getSubset()).equalsResource(typeRule.getEquals());
        return ruleBuilder.build();
    }

    private void enumerateRules() {
        AclRuleBuilder ruleBuilder;
        String description = this.policyDoc.getDescription();
        AclRuleBuilder envProto = AclRuleBuilder.builder().environment(this.environment.toBasic()).description(description).sourceIdentity(this.sourceIdent);
        for (String username : this.usernames) {
            ruleBuilder = AclRuleBuilder.builder(envProto).username(username);
            this.rules.addAll(this.createRules(ruleBuilder));
        }
        for (String group : this.groups) {
            ruleBuilder = AclRuleBuilder.builder(envProto).group(group);
            this.rules.addAll(this.createRules(ruleBuilder));
        }
    }

    private void parseByClause() {
        Object u = this.policyDoc.getBy().getUsername();
        Object g = this.policyDoc.getBy().getGroup();
        if (null != u) {
            if (u instanceof String) {
                this.addUsername((String)u);
            } else if (u instanceof Collection) {
                for (Object o : (Collection)u) {
                    if (o instanceof String) {
                        this.addUsername((String)o);
                        continue;
                    }
                    throw new AclPolicySyntaxException("Section 'username:' should contain only Strings, but saw a: " + o.getClass().getName());
                }
            } else {
                throw new AclPolicySyntaxException("Section 'username:' should be a list or a String, but it was: " + u.getClass().getName());
            }
        }
        if (null != g) {
            if (g instanceof String) {
                this.addGroup((String)g);
            } else if (g instanceof Collection) {
                for (Object o : (Collection)g) {
                    if (o instanceof String) {
                        this.addGroup((String)o);
                        continue;
                    }
                    throw new AclPolicySyntaxException("Section 'group:' should contain only Strings, but saw a: " + o.getClass().getName());
                }
            } else {
                throw new AclPolicySyntaxException("Section 'group:' should be a list or a String, but it was: " + g.getClass().getName());
            }
        }
        if (this.groups.size() < 1 && this.usernames.size() < 1 && null != this.validation) {
            this.validation.addError(this.sourceIdent, "Section 'by:' is not valid:  it must contain 'group:' and/or 'username:'");
        }
    }

    private void addGroup(String g) {
        this.groups.add(g);
    }

    private void addUsername(String u) {
        this.usernames.add(u);
    }

    private void validate() {
        if (null == this.policyDoc.getBy()) {
            throw new AclPolicySyntaxException("Required 'by:' section was not present");
        }
        if (null == this.policyDoc.getBy().getGroup() && null == this.policyDoc.getBy().getUsername()) {
            throw new AclPolicySyntaxException("Section 'by:' is not valid:  it must contain 'group:' and/or 'username:'");
        }
        if (null == this.policyDoc.getFor()) {
            throw new AclPolicySyntaxException("Required 'for:' section was not present");
        }
        if (this.policyDoc.getFor().isEmpty()) {
            throw new AclPolicySyntaxException("Section 'for:' should not be empty");
        }
        HashSet<String> verify = new HashSet<String>(Arrays.asList("allow", "deny"));
        for (String type : this.policyDoc.getFor().keySet()) {
            Map<String, List<ACLPolicyDoc.TypeRule>> aFor = this.policyDoc.getFor();
            List<ACLPolicyDoc.TypeRule> typeRules = aFor.get(type);
            if (typeRules.size() < 1) {
                throw new AclPolicySyntaxException(String.format("Type rule 'for: { %s: [...] }' list should not be empty.", type));
            }
            int typeIndex = 1;
            for (ACLPolicyDoc.TypeRule typeRule : typeRules) {
                this.validateRule(type, typeIndex, typeRule.getAllow(), "allow");
                this.validateRule(type, typeIndex, typeRule.getDeny(), "deny");
                if (typeRule.isEmpty()) {
                    throw new AclPolicySyntaxException(String.format("Type rule 'for: { %s: [...] }' entry at index [%d] One of 'allow:' or 'deny:' must be present.", type, typeIndex));
                }
                this.verifyTypeResourceKeys(verify, type, typeIndex, typeRule.getContains(), "contains", "tags");
                this.verifyTypeResourceKeys(verify, type, typeIndex, typeRule.getEquals(), "equals", null);
                this.verifyTypeResourceKeys(verify, type, typeIndex, typeRule.getMatch(), "match", null);
                this.verifyTypeResourceKeys(verify, type, typeIndex, typeRule.getSubset(), "subset", null);
                ++typeIndex;
            }
        }
        if (null == this.policyDoc.getDescription()) {
            throw new AclPolicySyntaxException("Policy is missing a description");
        }
    }

    private void validateRule(String type, int typeIndex, Object grant, String grantName) {
        if (grant == null) {
            return;
        }
        if (grant instanceof List) {
            List g = (List)grant;
            if (g.size() < 1) {
                throw new AclPolicySyntaxException(String.format("Type rule 'for: { %s: [...] }' entry at index [%d] Section '%s:' should not be empty", type, typeIndex, grantName));
            }
        } else if (!(grant instanceof String)) {
            throw new AclPolicySyntaxException(String.format("Type rule 'for: { %s: [...] }' entry at index [%d] Section '%s:' expected a String or a sequence of Strings, but was a %s", type, typeIndex, grantName, grant.getClass().getName()));
        }
    }

    private void verifyTypeResourceKeys(final HashSet<String> verify, String type, int typeIndex, Map<String, Object> resource, String name, final String checkfor) {
        List collect2;
        if (resource == null) {
            return;
        }
        if (resource.size() == 0) {
            throw new AclPolicySyntaxException("Type rule 'for: { " + type + ": [...] }' entry at index [" + typeIndex + "] Section " + "'" + name + ":' should not be empty.");
        }
        List collect = resource.keySet().stream().filter(new Predicate<String>(){

            @Override
            public boolean test(String o) {
                return verify.contains(o);
            }
        }).collect(Collectors.toList());
        if (collect.size() > 0) {
            throw new AclPolicySyntaxException("Type rule 'for: { " + type + ": [...] }' entry at index [" + typeIndex + "] Section " + "'" + name + ":' should not contain 'allow:' or 'deny:'");
        }
        if (checkfor != null && (collect2 = resource.keySet().stream().filter(new Predicate<String>(){

            @Override
            public boolean test(String s) {
                return !checkfor.equals(s);
            }
        }).collect(Collectors.toList())).size() > 0) {
            throw new AclPolicySyntaxException("Type rule 'for: { " + type + ": [...] }' entry at index [" + typeIndex + "] Section " + "'" + name + ":' can only be applied to: '" + checkfor + "'");
        }
    }

    private void parseEnvironment(Set<Attribute> forcedContext) {
        ACLPolicyDoc.Context context = this.policyDoc.getContext();
        if (null != forcedContext) {
            if (null != context) {
                throw new AclPolicySyntaxException("Context section should not be specified, it is already set to: " + AuthorizationUtil.contextAsString(forcedContext));
            }
            this.environment = new YamlEnvironmentalContext("rundeck:auth:env:", forcedContext);
        } else {
            if (null == context) {
                throw new AclPolicySyntaxException("Required 'context:' section was not present");
            }
            if (null != context.getProject() && null != context.getApplication() || null == context.getProject() && null == context.getApplication()) {
                throw new AclPolicySyntaxException("Context section is not valid: " + context + ", it should have only one entry: 'application:' or 'project:'");
            }
            this.environment = new YamlEnvironmentalContext("rundeck:auth:env:", context);
        }
        if (!this.environment.isValid()) {
            throw new AclPolicySyntaxException("Context section is not valid: " + context + this.environment.getValidation());
        }
    }

    public static Policy createYamlPolicy(Set<Attribute> forcedContext, ACLPolicyDoc yamlDoc, String ident, int index, ValidationSet validation) {
        return new YamlParsePolicy(forcedContext, yamlDoc, ident, index, validation);
    }

    @Override
    public AclRuleSet getRuleSet() {
        return new AclRuleSetImpl(this.rules);
    }

    @Override
    public Set<String> getUsernames() {
        return this.usernames;
    }

    @Override
    public Set<String> getGroups() {
        return this.groups;
    }

    @Override
    public EnvironmentalContext getEnvironment() {
        return this.environment.toBasic();
    }

    static YamlPolicyCollection.YamlSourceLoader<ACLPolicyDoc> loader(final YamlSource source1, final ValidationSet validation) {
        return new YamlPolicyCollection.YamlSourceLoader<ACLPolicyDoc>(){

            @Override
            public Iterable<ACLPolicyDoc> loadAll() throws IOException {
                Yaml yaml = new Yaml((BaseConstructor)new YamlPolicyDocConstructor());
                Iterable<Object> objects = source1.loadAll(yaml);
                final Iterator<Object> iterator = objects.iterator();
                return new Iterable<ACLPolicyDoc>(){

                    @Override
                    public Iterator<ACLPolicyDoc> iterator() {
                        return new Iterator<ACLPolicyDoc>(){
                            int index = 0;

                            @Override
                            public boolean hasNext() {
                                return iterator.hasNext();
                            }

                            @Override
                            public ACLPolicyDoc next() {
                                Object next = null;
                                ++this.index;
                                try {
                                    next = iterator.next();
                                }
                                catch (ConstructorException e) {
                                    e.printStackTrace();
                                    if (null != validation) {
                                        validation.addError(this.currentIdentity(), "Error parsing the policy document: " + e.getCause().getMessage());
                                    }
                                    return null;
                                }
                                catch (YAMLException e) {
                                    e.printStackTrace();
                                    if (null != validation) {
                                        validation.addError(this.currentIdentity(), "Error parsing the policy document: " + e.getMessage());
                                    }
                                    return null;
                                }
                                if (next == null) {
                                    return null;
                                }
                                if (!(next instanceof ACLPolicyDoc)) {
                                    if (null != validation) {
                                        validation.addError(this.currentIdentity(), "Expected a YamlPolicyDoc document, but was type: " + next.getClass());
                                    }
                                    return null;
                                }
                                return (ACLPolicyDoc)next;
                            }

                            private String currentIdentity() {
                                return source1.getIdentity() + "[" + this.index + "]";
                            }
                        };
                    }
                };
            }

            @Override
            public void close() throws IOException {
                source1.close();
            }
        };
    }

    static YamlPolicyCollection.YamlPolicyCreator<ACLPolicyDoc> creator(final Set<Attribute> forcedContext, final ValidationSet validation) {
        return new YamlPolicyCollection.YamlPolicyCreator<ACLPolicyDoc>(){

            @Override
            public Policy createYamlPolicy(ACLPolicyDoc policyInput, String sourceIdent, int sourceIndex) throws AclPolicySyntaxException {
                return YamlParsePolicy.createYamlPolicy(forcedContext, policyInput, sourceIdent, sourceIndex, validation);
            }
        };
    }

    private static class YamlEnvironmentalContext {
        Map<URI, String> matcher = new HashMap<URI, String>();
        Map<URI, Pattern> matcherRegex = new HashMap<URI, Pattern>();
        private boolean valid = false;
        private String validation;
        private String description;
        private static Comparator<Attribute> comparator = new Comparator<Attribute>(){

            @Override
            public int compare(Attribute attribute, Attribute attribute2) {
                int u = attribute.property.compareTo(attribute2.property);
                if (u == 0) {
                    return attribute.value.compareTo(attribute2.value);
                }
                return u;
            }
        };

        EnvironmentalContext toBasic() {
            if (this.matcherRegex.size() != 1 && this.matcher.size() != 1) {
                throw new IllegalStateException("Expected environmental context to contain only one entry");
            }
            if (this.matcherRegex.size() == 1) {
                Map.Entry<URI, Pattern> next = this.matcherRegex.entrySet().iterator().next();
                URI key = next.getKey();
                Pattern value = next.getValue();
                return BasicEnvironmentalContext.patternContextFor(key.toString().substring("rundeck:auth:env:".length()), value.toString());
            }
            Map.Entry<URI, String> next = this.matcher.entrySet().iterator().next();
            URI key = next.getKey();
            String value = next.getValue();
            return BasicEnvironmentalContext.staticContextFor(key.toString().substring("rundeck:auth:env:".length()), value);
        }

        YamlEnvironmentalContext(String uriPrefix, Set<Attribute> ctx) {
            for (Attribute attribute : ctx) {
                if (!attribute.getProperty().toString().startsWith(uriPrefix)) continue;
                URI key = attribute.getProperty();
                String value = attribute.getValue();
                this.matcher.put(key, value);
                try {
                    Pattern compile = Pattern.compile(value);
                    this.matcherRegex.put(key, compile);
                }
                catch (PatternSyntaxException patternSyntaxException) {}
            }
            this.valid = this.matcher.size() >= 1;
            this.description = "YamlEnvironmentalContext{" + (this.valid ? ", valid=" + this.valid + ", context='" + this.matcher + '\'' + '}' : ", valid=" + this.valid + ", validation='" + this.getValidation() + '\'' + '}');
        }

        YamlEnvironmentalContext(String uriPrefix, ACLPolicyDoc.Context ctx) {
            String value;
            String key;
            boolean invalidentry = false;
            ArrayList<String> errors = new ArrayList<String>();
            if (null != ctx.getProject()) {
                key = "project";
                value = ctx.getProject();
            } else {
                key = "application";
                value = ctx.getApplication();
            }
            try {
                URI uri = new URI(uriPrefix + key);
                this.matcher.put(uri, value);
                Pattern compile = Pattern.compile(value);
                this.matcherRegex.put(uri, compile);
            }
            catch (URISyntaxException e) {
                errors.add("Context section: " + key + ": invalid URI: " + e.getMessage());
                invalidentry = true;
            }
            if (errors.size() > 0) {
                StringBuffer sb = new StringBuffer();
                for (String error : errors) {
                    if (sb.length() > 0) {
                        sb.append("; ");
                    }
                    sb.append(error);
                }
                this.validation = sb.toString();
            }
            this.valid = !invalidentry && this.matcher.size() >= 1;
            this.description = "YamlEnvironmentalContext{" + (this.valid ? ", valid=" + this.valid + ", context='" + this.matcher + '\'' + '}' : ", valid=" + this.valid + ", validation='" + this.getValidation() + '\'' + '}');
        }

        public boolean isValid() {
            return this.valid;
        }

        public String toString() {
            return this.description;
        }

        public String getValidation() {
            return this.validation;
        }
    }
}

