/*
 * Decompiled with CFR 0.152.
 */
package com.dtolabs.rundeck.core.common;

import com.dtolabs.rundeck.core.authorization.Attribute;
import com.dtolabs.rundeck.core.authorization.Authorization;
import com.dtolabs.rundeck.core.common.FilesystemFramework;
import com.dtolabs.rundeck.core.common.Framework;
import com.dtolabs.rundeck.core.common.FrameworkFactory;
import com.dtolabs.rundeck.core.common.FrameworkResourceException;
import com.dtolabs.rundeck.core.common.FrameworkResourceParent;
import com.dtolabs.rundeck.core.common.IFrameworkProjectMgr;
import com.dtolabs.rundeck.core.common.IFrameworkResource;
import com.dtolabs.rundeck.core.common.INodeSet;
import com.dtolabs.rundeck.core.common.IProjectInfo;
import com.dtolabs.rundeck.core.common.IProjectNodes;
import com.dtolabs.rundeck.core.common.IProjectNodesFactory;
import com.dtolabs.rundeck.core.common.IRundeckProject;
import com.dtolabs.rundeck.core.common.IRundeckProjectConfig;
import com.dtolabs.rundeck.core.common.IRundeckProjectConfigModifier;
import com.dtolabs.rundeck.core.common.NodeFileParserException;
import com.dtolabs.rundeck.core.common.ProjectNodeSupport;
import com.dtolabs.rundeck.core.common.UpdateUtils;
import com.dtolabs.rundeck.core.utils.PropertyLookup;
import com.dtolabs.utils.Streams;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;

public class FrameworkProject
extends FrameworkResourceParent
implements IRundeckProject {
    public static final String PROP_FILENAME = "project.properties";
    public static final String ETC_DIR_NAME = "etc";
    public static final String NODES_XML = "resources.xml";
    public static final String PROJECT_RESOURCES_URL_PROPERTY = "project.resources.url";
    public static final String PROJECT_RESOURCES_FILE_PROPERTY = "project.resources.file";
    public static final String PROJECT_RESOURCES_FILEFORMAT_PROPERTY = "project.resources.file.format";
    public static final String PROJECT_RESOURCES_ALLOWED_URL_PREFIX = "project.resources.allowedURL.";
    public static final String FRAMEWORK_RESOURCES_ALLOWED_URL_PREFIX = "framework.resources.allowedURL.";
    public static final String RESOURCES_SOURCE_PROP_PREFIX = "resources.source";
    public static final String PROJECT_RESOURCES_MERGE_NODE_ATTRIBUTES = "project.resources.mergeNodeAttributes";
    private final File resourcesBaseDir;
    private final File etcDir;
    private final IFrameworkProjectMgr projectResourceMgr;
    private PropertyLookup lookup;
    private FilesystemFramework filesystemFramework;
    private Framework framework;
    private IProjectNodesFactory projectNodesFactory;
    private Authorization projectAuthorization;
    private IRundeckProjectConfig projectConfig;
    private IRundeckProjectConfigModifier projectConfigModifier;

    public static Set<Attribute> authorizationEnvironment(String project) {
        return Collections.singleton(new Attribute(URI.create("rundeck:auth:env:project"), project));
    }

    public FrameworkProject(String name, File basedir, FilesystemFramework filesystemFramework, IFrameworkProjectMgr resourceMgr, IRundeckProjectConfig projectConfig, IRundeckProjectConfigModifier projectConfigModifier) {
        super(name, basedir, null);
        this.filesystemFramework = filesystemFramework;
        this.projectResourceMgr = resourceMgr;
        this.resourcesBaseDir = new File(this.getBaseDir(), "resources");
        this.etcDir = FrameworkProject.getProjectEtcDir(this.getBaseDir());
        if (!this.etcDir.exists() && !this.etcDir.mkdirs()) {
            throw new FrameworkResourceException("error while creating project structure. failed creating directory: " + this.etcDir.getAbsolutePath(), this);
        }
        this.projectConfig = projectConfig;
        this.projectConfigModifier = projectConfigModifier;
        this.initialize();
    }

    @Override
    public IProjectInfo getInfo() {
        return new IProjectInfo(){

            @Override
            public String getDescription() {
                return FrameworkProject.this.hasProperty("project.description") ? FrameworkProject.this.getProperty("project.description") : null;
            }

            @Override
            public String getReadme() {
                return FrameworkProject.this.readFileResourceContents("readme.md");
            }

            @Override
            public String getReadmeHTML() {
                return null;
            }

            @Override
            public String getMotdHTML() {
                return null;
            }

            @Override
            public String getMotd() {
                return FrameworkProject.this.readFileResourceContents("motd.md");
            }
        };
    }

    private String readFileResourceContents(String path) {
        if (!this.existsFileResource(path)) {
            return null;
        }
        ByteArrayOutputStream output = new ByteArrayOutputStream();
        try {
            this.loadFileResource(path, output);
        }
        catch (IOException e) {
            return null;
        }
        return output.toString();
    }

    public static File getProjectEtcDir(File baseDir) {
        return new File(baseDir, ETC_DIR_NAME);
    }

    public static File getProjectPropertyFile(File baseDir) {
        return new File(FrameworkProject.getProjectEtcDir(baseDir), PROP_FILENAME);
    }

    @Override
    public String getProperty(String name) {
        return this.projectConfig.getProperty(name);
    }

    @Override
    public boolean hasProperty(String key) {
        return this.projectConfig.hasProperty(key);
    }

    @Override
    public Map<String, String> getProperties() {
        return this.projectConfig.getProperties();
    }

    @Override
    public Map<String, String> getProjectProperties() {
        return this.projectConfig.getProjectProperties();
    }

    @Override
    public Date getConfigLastModifiedTime() {
        return this.projectConfig.getConfigLastModifiedTime();
    }

    @Override
    public synchronized List<Map<String, Object>> listResourceModelConfigurations() {
        return this.getProjectNodes().listResourceModelConfigurations();
    }

    public static FrameworkProject create(String name, File projectsDir, FilesystemFramework filesystemFramework, IFrameworkProjectMgr resourceMgr, IProjectNodesFactory nodesFactory) {
        return FrameworkFactory.createFrameworkProject(name, new File(projectsDir, name), filesystemFramework, resourceMgr, nodesFactory, null);
    }

    public static FrameworkProject create(String name, File projectsDir, FilesystemFramework filesystemFramework, IFrameworkProjectMgr resourceMgr) {
        return FrameworkFactory.createFrameworkProject(name, new File(projectsDir, name), filesystemFramework, resourceMgr, FrameworkFactory.createNodesFactory(filesystemFramework), null);
    }

    @Override
    public IFrameworkResource loadChild(String name) {
        throw new FrameworkResourceParent.NoSuchResourceException("project named " + name + " doesn't exist", this);
    }

    @Override
    public boolean childCouldBeLoaded(String name) {
        File file = new File(this.resourcesBaseDir, name);
        return file.exists() && file.isDirectory();
    }

    @Override
    public Collection<String> listChildNames() {
        String[] list;
        HashSet<String> childnames = new HashSet<String>();
        if (this.resourcesBaseDir.isDirectory() && null != (list = this.resourcesBaseDir.list())) {
            for (String aList : list) {
                File dir = new File(this.resourcesBaseDir, aList);
                if (!dir.isDirectory()) continue;
                childnames.add(dir.getName());
            }
        }
        return childnames;
    }

    @Override
    public IFrameworkResource createChild(String resourceType) {
        throw new UnsupportedOperationException("createChild");
    }

    public IFrameworkProjectMgr getFrameworkProjectMgr() {
        return this.projectResourceMgr;
    }

    public static boolean exists(String project, IFrameworkProjectMgr projectResourceMgr) {
        return projectResourceMgr.existsFrameworkProject(project);
    }

    public File getEtcDir() {
        return this.etcDir;
    }

    @Override
    public INodeSet getNodeSet() throws NodeFileParserException {
        return this.getProjectNodes().getNodeSet();
    }

    @Override
    public boolean updateNodesResourceFile() throws UpdateUtils.UpdateException {
        return this.getProjectNodes().updateNodesResourceFile(ProjectNodeSupport.getNodesResourceFilePath(this, this.framework));
    }

    @Override
    public void updateNodesResourceFileFromUrl(String providerURL, String username, String password) throws UpdateUtils.UpdateException {
        this.getProjectNodes().updateNodesResourceFileFromUrl(providerURL, username, password, ProjectNodeSupport.getNodesResourceFilePath(this, this.framework));
    }

    @Override
    public void updateNodesResourceFile(INodeSet nodeset) throws UpdateUtils.UpdateException {
        this.getProjectNodes().updateNodesResourceFile(nodeset, ProjectNodeSupport.getNodesResourceFilePath(this, this.framework));
    }

    public static void createFileStructure(File projectDir) throws IOException {
        if (!projectDir.exists() && !projectDir.mkdirs()) {
            throw new IOException("failed creating project base dir: " + projectDir.getAbsolutePath());
        }
        File etcDir = new File(projectDir, ETC_DIR_NAME);
        if (!etcDir.exists() && !etcDir.mkdirs()) {
            throw new IOException("failed creating project etc dir: " + etcDir.getAbsolutePath());
        }
    }

    @Override
    public boolean existsFileResource(String path) {
        File result = new File(this.getBaseDir(), path);
        return result.exists() && result.isFile();
    }

    @Override
    public boolean existsDirResource(String path) {
        File result = new File(this.getBaseDir(), path);
        return result.exists() && result.isDirectory();
    }

    @Override
    public List<String> listDirPaths(String path) {
        if (!this.existsDirResource(path)) {
            return Collections.emptyList();
        }
        File dir = new File(this.getBaseDir(), path);
        File[] list = dir.listFiles();
        ArrayList<String> result = new ArrayList<String>();
        String prefix = path;
        if (path.endsWith("/")) {
            prefix = path.substring(0, path.length() - 1);
        }
        assert (list != null);
        for (File s : list) {
            result.add(prefix + "/" + s.getName() + (s.isDirectory() ? "/" : ""));
        }
        return result;
    }

    @Override
    public boolean deleteFileResource(String path) {
        File result = new File(this.getBaseDir(), path);
        return !result.exists() || result.delete();
    }

    @Override
    public long storeFileResource(String path, InputStream input) throws IOException {
        File result = new File(this.getBaseDir(), path);
        if (!result.getParentFile().exists()) {
            result.getParentFile().mkdirs();
        }
        try (FileOutputStream fos = new FileOutputStream(result);){
            long l = Streams.copyStream(input, fos);
            return l;
        }
    }

    @Override
    public long loadFileResource(String path, OutputStream output) throws IOException {
        File result = new File(this.getBaseDir(), path);
        try (FileInputStream fis = new FileInputStream(result);){
            long l = Streams.copyStream(fis, output);
            return l;
        }
    }

    protected void generateProjectPropertiesFile(boolean overwrite, Properties properties, boolean addDefault) {
        this.projectConfigModifier.generateProjectPropertiesFile(overwrite, properties, addDefault);
    }

    @Override
    public void mergeProjectProperties(Properties properties, Set<String> removePrefixes) {
        this.projectConfigModifier.mergeProjectProperties(properties, removePrefixes);
    }

    @Override
    public void setProjectProperties(Properties properties) {
        this.projectConfigModifier.setProjectProperties(properties);
    }

    public static boolean isInstalled(FrameworkProject d) {
        return d.getBaseDir().exists();
    }

    public ArrayList<Exception> getResourceModelSourceExceptions() {
        return this.getProjectNodes().getResourceModelSourceExceptions();
    }

    public Framework getFramework() {
        return this.framework;
    }

    public void setFramework(Framework framework) {
        this.framework = framework;
    }

    @Override
    public IProjectNodes getProjectNodes() {
        return this.projectNodesFactory.getNodes(this.getName());
    }

    @Override
    public Authorization getProjectAuthorization() {
        return this.projectAuthorization;
    }

    public void setProjectAuthorization(Authorization projectAuthorization) {
        this.projectAuthorization = projectAuthorization;
    }

    public void setProjectNodesFactory(IProjectNodesFactory projectNodesFactory) {
        this.projectNodesFactory = projectNodesFactory;
    }
}

