/*
 * Decompiled with CFR 0.152.
 */
package com.dtolabs.rundeck.core.execution.dispatch;

import com.dtolabs.rundeck.core.common.Framework;
import com.dtolabs.rundeck.core.common.INodeEntry;
import com.dtolabs.rundeck.core.common.INodeSet;
import com.dtolabs.rundeck.core.execution.FailedNodesListener;
import com.dtolabs.rundeck.core.execution.ServiceThreadBase;
import com.dtolabs.rundeck.core.execution.dispatch.Dispatchable;
import com.dtolabs.rundeck.core.execution.dispatch.DispatcherException;
import com.dtolabs.rundeck.core.execution.dispatch.DispatcherResult;
import com.dtolabs.rundeck.core.execution.dispatch.DispatcherResultImpl;
import com.dtolabs.rundeck.core.execution.dispatch.INodeEntryComparator;
import com.dtolabs.rundeck.core.execution.dispatch.NodeDispatcher;
import com.dtolabs.rundeck.core.execution.workflow.StepExecutionContext;
import com.dtolabs.rundeck.core.execution.workflow.steps.node.NodeStepException;
import com.dtolabs.rundeck.core.execution.workflow.steps.node.NodeStepExecutionItem;
import com.dtolabs.rundeck.core.execution.workflow.steps.node.NodeStepResult;
import com.dtolabs.rundeck.core.execution.workflow.steps.node.NodeStepResultImpl;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;

public class SequentialNodeDispatcher
implements NodeDispatcher {
    private Framework framework;

    public SequentialNodeDispatcher(Framework framework) {
        this.framework = framework;
    }

    @Override
    public DispatcherResult dispatch(StepExecutionContext context, NodeStepExecutionItem item) throws DispatcherException {
        return this.dispatch(context, item, null);
    }

    @Override
    public DispatcherResult dispatch(StepExecutionContext context, Dispatchable item) throws DispatcherException {
        return this.dispatch(context, null, item);
    }

    public DispatcherResult dispatch(StepExecutionContext context, NodeStepExecutionItem item, Dispatchable toDispatch) throws DispatcherException {
        INodeSet nodes = context.getNodes();
        if (nodes.getNodes().size() < 1) {
            throw new DispatcherException("No nodes matched");
        }
        boolean keepgoing = context.isKeepgoing();
        context.getExecutionListener().log(4, "preparing for sequential execution on " + nodes.getNodes().size() + " nodes");
        HashSet<String> nodeNames = new HashSet<String>(nodes.getNodeNames());
        HashMap<String, NodeStepResult> failures = new HashMap<String, NodeStepResult>();
        FailedNodesListener failedListener = context.getExecutionListener().getFailedNodesListener();
        if (null != failedListener) {
            failedListener.matchedNodes(nodeNames);
        }
        boolean interrupted = false;
        Thread thread = Thread.currentThread();
        boolean success = true;
        HashMap<String, NodeStepResult> resultMap = new HashMap<String, NodeStepResult>();
        List<INodeEntry> nodes1 = INodeEntryComparator.rankOrderedNodes(nodes, context.getNodeRankAttribute(), context.isNodeRankOrderAscending());
        Throwable caught = null;
        INodeEntry failedNode = null;
        for (INodeEntry node : nodes1) {
            if (thread.isInterrupted() || thread instanceof ServiceThreadBase && ((ServiceThreadBase)thread).isAborted()) {
                interrupted = true;
                break;
            }
            context.getExecutionListener().log(4, "Executing command on node: " + node.getNodename() + ", " + node.toString());
            try {
                if (thread.isInterrupted() || thread instanceof ServiceThreadBase && ((ServiceThreadBase)thread).isAborted()) {
                    interrupted = true;
                    break;
                }
                NodeStepResult result = null != item ? this.framework.getExecutionService().executeNodeStep(context, item, node) : toDispatch.dispatch(context, node);
                resultMap.put(node.getNodename(), result);
                if (!result.isSuccess()) {
                    success = false;
                    failures.put(node.getNodename(), result);
                    if (keepgoing) continue;
                    failedNode = node;
                    break;
                }
                nodeNames.remove(node.getNodename());
            }
            catch (NodeStepException e) {
                success = false;
                failures.put(node.getNodename(), new NodeStepResultImpl(e, e.getFailureReason(), e.getMessage(), node));
                context.getExecutionListener().log(0, "Failed dispatching to node " + node.getNodename() + ": " + e.getMessage());
                StringWriter stringWriter = new StringWriter();
                e.printStackTrace(new PrintWriter(stringWriter));
                context.getExecutionListener().log(4, "Failed dispatching to node " + node.getNodename() + ": " + stringWriter.toString());
                if (keepgoing) continue;
                failedNode = node;
                caught = e;
                break;
            }
        }
        if (!keepgoing && failures.size() > 0 && null != failedListener) {
            failedListener.nodesFailed(failures);
        }
        if (!keepgoing && null != caught) {
            throw new DispatcherException("Failed dispatching to node " + failedNode.getNodename() + ": " + caught.getMessage(), (NodeStepException)caught, failedNode);
        }
        if (keepgoing && nodeNames.size() > 0) {
            if (null != failedListener) {
                failedListener.nodesFailed(failures);
            }
            return new DispatcherResultImpl(failures, false);
        }
        if (null != failedListener && failures.isEmpty() && !interrupted) {
            failedListener.nodesSucceeded();
        }
        if (interrupted) {
            throw new DispatcherException("Node dispatch interrupted");
        }
        boolean status = success;
        return new DispatcherResultImpl(resultMap, status);
    }
}

