/*
 * Decompiled with CFR 0.152.
 */
package com.dtolabs.rundeck.core.execution.workflow;

import com.dtolabs.rundeck.core.common.Framework;
import com.dtolabs.rundeck.core.common.INodeEntry;
import com.dtolabs.rundeck.core.common.SelectorUtils;
import com.dtolabs.rundeck.core.execution.ExecutionContext;
import com.dtolabs.rundeck.core.execution.ExecutionContextImpl;
import com.dtolabs.rundeck.core.execution.ExecutionListener;
import com.dtolabs.rundeck.core.execution.ExecutionListenerOverride;
import com.dtolabs.rundeck.core.execution.FailedNodesListener;
import com.dtolabs.rundeck.core.execution.HandlerExecutionItem;
import com.dtolabs.rundeck.core.execution.HasFailureHandler;
import com.dtolabs.rundeck.core.execution.StepExecutionItem;
import com.dtolabs.rundeck.core.execution.dispatch.DispatcherException;
import com.dtolabs.rundeck.core.execution.dispatch.DispatcherResult;
import com.dtolabs.rundeck.core.execution.workflow.ControlBehavior;
import com.dtolabs.rundeck.core.execution.workflow.FlowController;
import com.dtolabs.rundeck.core.execution.workflow.NodeRecorder;
import com.dtolabs.rundeck.core.execution.workflow.StepExecutionContext;
import com.dtolabs.rundeck.core.execution.workflow.StepFirstWorkflowExecutor;
import com.dtolabs.rundeck.core.execution.workflow.WorkflowExecutionItem;
import com.dtolabs.rundeck.core.execution.workflow.WorkflowExecutionListener;
import com.dtolabs.rundeck.core.execution.workflow.WorkflowExecutionResult;
import com.dtolabs.rundeck.core.execution.workflow.WorkflowExecutor;
import com.dtolabs.rundeck.core.execution.workflow.WorkflowStatusResult;
import com.dtolabs.rundeck.core.execution.workflow.steps.FailureReason;
import com.dtolabs.rundeck.core.execution.workflow.steps.NodeDispatchStepExecutor;
import com.dtolabs.rundeck.core.execution.workflow.steps.StepException;
import com.dtolabs.rundeck.core.execution.workflow.steps.StepExecutionResult;
import com.dtolabs.rundeck.core.execution.workflow.steps.StepExecutionResultImpl;
import com.dtolabs.rundeck.core.execution.workflow.steps.StepFailureReason;
import com.dtolabs.rundeck.core.execution.workflow.steps.node.NodeStepException;
import com.dtolabs.rundeck.core.execution.workflow.steps.node.NodeStepResult;
import com.dtolabs.rundeck.core.execution.workflow.steps.node.NodeStepResultImpl;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;

public abstract class BaseWorkflowExecutor
implements WorkflowExecutor {
    protected static final String DATA_CONTEXT_PREFIX = "data context: ";
    protected static final String OPTION_KEY = "option";
    protected static final String SECURE_OPTION_KEY = "secureOption";
    protected static final String SECURE_OPTION_VALUE = "****";
    final Framework framework;
    static final WorkflowStatusResult WorkflowResultFailed = new BaseWorkflowStatusResult(false, null, ControlBehavior.Continue);

    public BaseWorkflowExecutor(Framework framework) {
        this.framework = framework;
    }

    static WorkflowStatusResult workflowResult(boolean status, String statusString, ControlBehavior behavior) {
        return new BaseWorkflowStatusResult(status, statusString, behavior);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected StepExecutionResult executeWorkflowStep(WorkflowExecutionListener wlistener, StepExecutionItem cmd, StepExecutionContext executionContext, Map<Integer, StepExecutionResult> stepFailedMap, int stepNum) {
        boolean stepSuccess = false;
        String statusString = null;
        ControlBehavior controlBehavior = null;
        if (null != wlistener) {
            wlistener.beginWorkflowItem(stepNum, cmd);
        }
        NodeRecorder stepCaptureFailedNodesListener = new NodeRecorder();
        StepExecutionContext stepContext = this.replaceFailedNodesListenerInContext(executionContext, stepCaptureFailedNodesListener);
        StepExecutionResult stepResult = null;
        FlowController stepController = new FlowController();
        StepExecutionContext controllableContext = this.withFlowControl(stepContext, stepController);
        stepResult = this.executeWFItem(controllableContext, stepFailedMap, stepNum, cmd);
        stepSuccess = stepResult.isSuccess();
        HashMap<String, NodeStepResult> nodeFailures = stepCaptureFailedNodesListener.getFailedNodes();
        if (null != executionContext.getExecutionListener() && null != executionContext.getExecutionListener().getFailedNodesListener()) {
            executionContext.getExecutionListener().getFailedNodesListener().matchedNodes(stepCaptureFailedNodesListener.getMatchedNodes());
        }
        if (stepController.isControlled()) {
            stepSuccess = stepController.isSuccess();
            statusString = stepController.getStatusString();
            controlBehavior = stepController.getControlBehavior();
            executionContext.getExecutionListener().log(3, (Object)((Object)controlBehavior) + " requested" + (controlBehavior == ControlBehavior.Halt ? " with result: " + (null != statusString ? statusString : Boolean.valueOf(stepSuccess)) : ""));
        }
        try {
            HasFailureHandler handles;
            StepExecutionItem handler;
            if (!stepSuccess && cmd instanceof HasFailureHandler && null != (handler = (handles = (HasFailureHandler)((Object)cmd)).getFailureHandler())) {
                NodeRecorder handlerCaptureFailedNodesListener = new NodeRecorder();
                StepExecutionContext handlerExecContext = this.replaceFailedNodesListenerInContext(executionContext, handlerCaptureFailedNodesListener);
                if (stepCaptureFailedNodesListener.getMatchedNodes().size() > 1) {
                    HashSet<String> failedNodeList = new HashSet<String>(stepCaptureFailedNodesListener.getFailedNodes().keySet());
                    handlerExecContext = new ExecutionContextImpl.Builder(handlerExecContext).nodeSelector(SelectorUtils.nodeList(failedNodeList)).build();
                }
                handlerExecContext = this.addStepFailureContextData(stepResult, handlerExecContext);
                handlerExecContext = this.addNodeStepFailureContextData(stepResult, handlerExecContext);
                HashMap<Integer, StepExecutionResult> handlerFailedMap = new HashMap<Integer, StepExecutionResult>();
                StepExecutionResult handlerResult = this.executeWFItem(handlerExecContext, handlerFailedMap, stepNum, handler);
                boolean handlerSuccess = handlerResult.isSuccess();
                boolean useHandlerResults = true;
                if (handlerSuccess && handler instanceof HandlerExecutionItem) {
                    useHandlerResults = ((HandlerExecutionItem)handler).isKeepgoingOnSuccess();
                }
                if (useHandlerResults) {
                    stepSuccess = handlerSuccess;
                    stepResult = handlerResult;
                    stepFailedMap = handlerFailedMap;
                    nodeFailures = handlerCaptureFailedNodesListener.getFailedNodes();
                }
            }
        }
        finally {
            if (null != wlistener) {
                wlistener.finishWorkflowItem(stepNum, cmd, stepResult);
            }
        }
        if (null != executionContext.getExecutionListener() && null != executionContext.getExecutionListener().getFailedNodesListener()) {
            if (nodeFailures.size() > 0) {
                executionContext.getExecutionListener().getFailedNodesListener().nodesFailed(nodeFailures);
            } else if (stepSuccess) {
                executionContext.getExecutionListener().getFailedNodesListener().nodesSucceeded();
            }
        }
        return stepResult;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final WorkflowExecutionResult executeWorkflow(StepExecutionContext executionContext, WorkflowExecutionItem item) {
        WorkflowExecutionListener wlistener = this.getWorkflowListener(executionContext);
        if (null != wlistener && !StepFirstWorkflowExecutor.isInnerLoop(item)) {
            wlistener.beginWorkflowExecution(executionContext, item);
        }
        WorkflowExecutionResult result = null;
        try {
            result = this.executeWorkflowImpl(executionContext, item);
        }
        finally {
            if (null != wlistener && !StepFirstWorkflowExecutor.isInnerLoop(item)) {
                wlistener.finishWorkflowExecution(result, executionContext, item);
            }
        }
        return result;
    }

    protected WorkflowExecutionListener getWorkflowListener(ExecutionContext executionContext) {
        WorkflowExecutionListener wlistener = null;
        ExecutionListener elistener = executionContext.getExecutionListener();
        if (null != elistener && elistener instanceof WorkflowExecutionListener) {
            wlistener = (WorkflowExecutionListener)((Object)elistener);
        }
        return wlistener;
    }

    public abstract WorkflowExecutionResult executeWorkflowImpl(StepExecutionContext var1, WorkflowExecutionItem var2);

    protected StepExecutionResult executeWFItem(StepExecutionContext executionContext, Map<Integer, StepExecutionResult> failedMap, int c, StepExecutionItem cmd) {
        StepExecutionResult result;
        if (null != executionContext.getExecutionListener()) {
            executionContext.getExecutionListener().log(4, c + ": Workflow step executing: " + cmd);
        }
        try {
            result = this.framework.getExecutionService().executeStep(ExecutionContextImpl.builder(executionContext).stepNumber(c).build(), cmd);
            if (!result.isSuccess()) {
                failedMap.put(c, result);
            }
        }
        catch (StepException e) {
            result = StepExecutionResultImpl.wrapStepException(e);
            failedMap.put(c, result);
        }
        if (null != executionContext.getExecutionListener()) {
            executionContext.getExecutionListener().log(4, c + ": Workflow step finished, result: " + result);
        }
        return result;
    }

    protected WorkflowStatusResult executeWorkflowItemsForNodeSet(StepExecutionContext executionContext, Map<Integer, StepExecutionResult> failedMap, List<StepExecutionResult> resultList, List<StepExecutionItem> iWorkflowCmdItems, boolean keepgoing) {
        return this.executeWorkflowItemsForNodeSet(executionContext, failedMap, resultList, iWorkflowCmdItems, keepgoing, executionContext.getStepNumber());
    }

    protected WorkflowStatusResult executeWorkflowItemsForNodeSet(StepExecutionContext executionContext, Map<Integer, StepExecutionResult> failedMap, List<StepExecutionResult> resultList, List<StepExecutionItem> iWorkflowCmdItems, boolean keepgoing, int beginStepIndex) {
        boolean workflowsuccess = true;
        String statusString = null;
        ControlBehavior controlBehavior = null;
        WorkflowExecutionListener wlistener = this.getWorkflowListener(executionContext);
        int c = beginStepIndex;
        for (StepExecutionItem cmd : iWorkflowCmdItems) {
            StepResultCapture stepResultCapture = this.executeWorkflowStep(executionContext, failedMap, resultList, keepgoing, wlistener, c, cmd);
            statusString = stepResultCapture.getStatusString();
            controlBehavior = stepResultCapture.getControlBehavior();
            if (!stepResultCapture.isStepSuccess()) {
                workflowsuccess = false;
            }
            if (stepResultCapture.controlBehavior == ControlBehavior.Halt || !stepResultCapture.isStepSuccess() && !keepgoing) break;
            ++c;
        }
        return BaseWorkflowExecutor.workflowResult(workflowsuccess, statusString, null != controlBehavior ? controlBehavior : ControlBehavior.Continue);
    }

    private StepExecutionContext withFlowControl(StepExecutionContext stepContext, FlowController stepController) {
        return new ExecutionContextImpl.Builder(stepContext).flowControl(stepController).build();
    }

    protected StepExecutionContext addStepFailureContextData(StepExecutionResult stepResult, StepExecutionContext handlerExecContext) {
        FailureReason reason;
        HashMap<String, String> resultData = new HashMap<String, String>();
        if (null != stepResult.getFailureData()) {
            for (Map.Entry<String, Object> entry : stepResult.getFailureData().entrySet()) {
                resultData.put(entry.getKey(), entry.getValue().toString());
            }
        }
        if (null == (reason = stepResult.getFailureReason())) {
            reason = StepFailureReason.Unknown;
        }
        resultData.put("reason", reason.toString());
        String message = stepResult.getFailureMessage();
        if (null == message) {
            message = "No message";
        }
        resultData.put("message", message);
        handlerExecContext = ExecutionContextImpl.builder(handlerExecContext).setContext("result", resultData).build();
        return handlerExecContext;
    }

    protected StepExecutionContext addNodeStepFailureContextData(StepExecutionResult dispatcherStepResult, StepExecutionContext handlerExecContext) {
        Map<String, ? extends NodeStepResult> resultMap;
        if (NodeDispatchStepExecutor.isWrappedDispatcherResult(dispatcherStepResult)) {
            DispatcherResult dispatcherResult = NodeDispatchStepExecutor.extractDispatcherResult(dispatcherStepResult);
            resultMap = dispatcherResult.getResults();
        } else if (NodeDispatchStepExecutor.isWrappedDispatcherException(dispatcherStepResult)) {
            DispatcherException exception = NodeDispatchStepExecutor.extractDispatcherException(dispatcherStepResult);
            HashMap<String, ? extends NodeStepResult> stringNodeStepResultHashMap = new HashMap<String, NodeStepResult>();
            resultMap = stringNodeStepResultHashMap;
            NodeStepException nodeStepException = exception.getNodeStepException();
            if (null != nodeStepException && null != exception.getNode()) {
                NodeStepResult nodeExecutorResult = BaseWorkflowExecutor.nodeStepResultFromNodeStepException(exception.getNode(), nodeStepException);
                stringNodeStepResultHashMap.put(nodeStepException.getNodeName(), nodeExecutorResult);
            }
        } else {
            return handlerExecContext;
        }
        ExecutionContextImpl.Builder builder = ExecutionContextImpl.builder(handlerExecContext);
        if (null != resultMap) {
            for (Map.Entry<String, ? extends NodeStepResult> dentry : resultMap.entrySet()) {
                FailureReason reason;
                String nodename = dentry.getKey();
                NodeStepResult stepResult = dentry.getValue();
                HashMap<String, String> resultData = new HashMap<String, String>();
                if (null != stepResult.getFailureData()) {
                    for (Map.Entry<String, Object> entry : stepResult.getFailureData().entrySet()) {
                        resultData.put(entry.getKey(), entry.getValue().toString());
                    }
                }
                if (null == (reason = stepResult.getFailureReason())) {
                    reason = StepFailureReason.Unknown;
                }
                resultData.put("reason", reason.toString());
                String message = stepResult.getFailureMessage();
                if (null == message) {
                    message = "No message";
                }
                resultData.put("message", message);
                HashMap<String, Map<String, String>> ndata = new HashMap<String, Map<String, String>>();
                ndata.put("result", resultData);
                builder.nodeDataContext(nodename, ndata);
            }
        }
        return builder.build();
    }

    protected StepExecutionContext replaceFailedNodesListenerInContext(StepExecutionContext executionContext, FailedNodesListener captureFailedNodesListener) {
        ExecutionListenerOverride listen = null;
        if (null != executionContext.getExecutionListener()) {
            listen = executionContext.getExecutionListener().createOverride();
        }
        if (null != listen) {
            listen.setFailedNodesListener(captureFailedNodesListener);
        }
        return new ExecutionContextImpl.Builder(executionContext).executionListener(listen).build();
    }

    protected Map<String, Collection<StepExecutionResult>> convertFailures(Map<Integer, StepExecutionResult> failedMap) {
        HashMap<String, Collection<StepExecutionResult>> failures = new HashMap<String, Collection<StepExecutionResult>>();
        for (Map.Entry<Integer, StepExecutionResult> entry : failedMap.entrySet()) {
            NodeStepException nodeStepException;
            DispatcherException e;
            INodeEntry node;
            StepExecutionResult o = entry.getValue();
            if (NodeDispatchStepExecutor.isWrappedDispatcherResult(o)) {
                DispatcherResult dispatcherResult = NodeDispatchStepExecutor.extractDispatcherResult(o);
                for (String s : dispatcherResult.getResults().keySet()) {
                    NodeStepResult interpreterResult = dispatcherResult.getResults().get(s);
                    if (!failures.containsKey(s)) {
                        failures.put(s, new ArrayList());
                    }
                    ((Collection)failures.get(s)).add(interpreterResult);
                }
                continue;
            }
            if (!NodeDispatchStepExecutor.isWrappedDispatcherException(o) || null == (node = (e = NodeDispatchStepExecutor.extractDispatcherException(o)).getNode())) continue;
            String key = node.getNodename();
            if (!failures.containsKey(key)) {
                failures.put(key, new ArrayList());
            }
            if (null == (nodeStepException = e.getNodeStepException())) continue;
            ((Collection)failures.get(key)).add(BaseWorkflowExecutor.nodeStepResultFromNodeStepException(node, nodeStepException));
        }
        return failures;
    }

    protected static NodeStepResult nodeStepResultFromNodeStepException(INodeEntry node, NodeStepException nodeStepException) {
        return new NodeStepResultImpl(nodeStepException.getCause(), nodeStepException.getFailureReason(), nodeStepException.getMessage(), node);
    }

    protected Map<String, Map<String, String>> createPrintableDataContext(Map<String, Map<String, String>> dataContext) {
        return this.createPrintableDataContext(OPTION_KEY, SECURE_OPTION_KEY, SECURE_OPTION_VALUE, dataContext);
    }

    protected Map<String, Map<String, String>> createPrintableDataContext(String optionKey, String secureOptionKey, String secureOptionValue, Map<String, Map<String, String>> dataContext) {
        HashMap<String, Map<String, String>> printableContext = new HashMap<String, Map<String, String>>();
        if (dataContext != null) {
            printableContext.putAll(dataContext);
            HashSet secureValues = new HashSet();
            if (dataContext.containsKey(secureOptionKey)) {
                HashMap<String, String> secureOptions = new HashMap<String, String>();
                secureOptions.putAll(dataContext.get(secureOptionKey));
                secureValues.addAll(secureOptions.values());
                for (Map.Entry entry : secureOptions.entrySet()) {
                    entry.setValue(secureOptionValue);
                }
                printableContext.put(secureOptionKey, secureOptions);
            }
            if (dataContext.containsKey(optionKey)) {
                HashMap<String, String> options = new HashMap<String, String>();
                options.putAll(dataContext.get(optionKey));
                for (Map.Entry entry : options.entrySet()) {
                    if (!secureValues.contains(entry.getValue())) continue;
                    entry.setValue(secureOptionValue);
                }
                printableContext.put(optionKey, options);
            }
        }
        return printableContext;
    }

    public StepResultCapture executeWorkflowStep(StepExecutionContext executionContext, Map<Integer, StepExecutionResult> failedMap, List<StepExecutionResult> resultList, boolean keepgoing, WorkflowExecutionListener wlistener, int c, StepExecutionItem cmd) {
        if (null != wlistener) {
            wlistener.beginWorkflowItem(c, cmd);
        }
        String statusString = null;
        ControlBehavior controlBehavior = null;
        boolean hasHandler = cmd instanceof HasFailureHandler;
        NodeRecorder stepCaptureFailedNodesListener = new NodeRecorder();
        StepExecutionContext stepContext = this.replaceFailedNodesListenerInContext(executionContext, stepCaptureFailedNodesListener);
        FlowController stepController = new FlowController();
        StepExecutionContext controllableContext = this.withFlowControl(stepContext, stepController);
        StepExecutionResult stepResult = null;
        HashMap<Integer, StepExecutionResult> stepFailedMap = new HashMap<Integer, StepExecutionResult>();
        stepResult = this.executeWFItem(controllableContext, stepFailedMap, c, cmd);
        boolean stepSuccess = stepResult.isSuccess();
        HashMap<String, NodeStepResult> nodeFailures = stepCaptureFailedNodesListener.getFailedNodes();
        if (null != executionContext.getExecutionListener() && null != executionContext.getExecutionListener().getFailedNodesListener()) {
            executionContext.getExecutionListener().getFailedNodesListener().matchedNodes(stepCaptureFailedNodesListener.getMatchedNodes());
        }
        if (stepController.isControlled()) {
            stepSuccess = stepController.isSuccess();
            statusString = stepController.getStatusString();
            controlBehavior = stepController.getControlBehavior();
            executionContext.getExecutionListener().log(3, (Object)((Object)controlBehavior) + " requested" + (controlBehavior == ControlBehavior.Halt ? " with result: " + (null != statusString ? statusString : Boolean.valueOf(stepSuccess)) : ""));
        }
        try {
            HasFailureHandler handles;
            StepExecutionItem handler;
            if (!stepSuccess && hasHandler && null != (handler = (handles = (HasFailureHandler)((Object)cmd)).getFailureHandler())) {
                NodeRecorder handlerCaptureFailedNodesListener = new NodeRecorder();
                StepExecutionContext handlerExecContext = this.replaceFailedNodesListenerInContext(executionContext, handlerCaptureFailedNodesListener);
                if (stepCaptureFailedNodesListener.getMatchedNodes().size() > 1) {
                    HashSet<String> failedNodeList = new HashSet<String>(stepCaptureFailedNodesListener.getFailedNodes().keySet());
                    handlerExecContext = new ExecutionContextImpl.Builder(handlerExecContext).nodeSelector(SelectorUtils.nodeList(failedNodeList)).build();
                }
                if (null != stepResult) {
                    handlerExecContext = this.addStepFailureContextData(stepResult, handlerExecContext);
                    handlerExecContext = this.addNodeStepFailureContextData(stepResult, handlerExecContext);
                }
                if (null != wlistener) {
                    wlistener.beginWorkflowItemErrorHandler(c, cmd);
                }
                FlowController handlerController = new FlowController();
                StepExecutionContext handlerControlContext = this.withFlowControl(handlerExecContext, handlerController);
                HashMap<Integer, StepExecutionResult> handlerFailedMap = new HashMap<Integer, StepExecutionResult>();
                StepExecutionResult handlerResult = this.executeWFItem(handlerControlContext, handlerFailedMap, c, handler);
                boolean handlerSuccess = handlerResult.isSuccess();
                if (null != wlistener) {
                    wlistener.finishWorkflowItemErrorHandler(c, cmd, handlerResult);
                }
                if (handlerController.isControlled() && handlerController.getControlBehavior() == ControlBehavior.Halt) {
                    stepSuccess = handlerController.isSuccess();
                    statusString = handlerController.getStatusString();
                    controlBehavior = handlerController.getControlBehavior();
                    executionContext.getExecutionListener().log(3, (Object)((Object)controlBehavior) + " requested with result: " + (null != statusString ? statusString : Boolean.valueOf(stepSuccess)));
                } else {
                    boolean useHandlerResults = keepgoing;
                    if (!keepgoing && handlerSuccess && handler instanceof HandlerExecutionItem) {
                        useHandlerResults = ((HandlerExecutionItem)handler).isKeepgoingOnSuccess();
                    }
                    if (useHandlerResults) {
                        stepSuccess = handlerSuccess;
                        stepResult = handlerResult;
                        stepFailedMap = handlerFailedMap;
                        nodeFailures = handlerCaptureFailedNodesListener.getFailedNodes();
                    }
                }
            }
        }
        catch (RuntimeException t) {
            stepResult = new StepExecutionResultImpl(t, StepFailureReason.Unknown, t.getMessage());
            throw t;
        }
        finally {
            if (null != wlistener) {
                wlistener.finishWorkflowItem(c, cmd, stepResult);
            }
        }
        resultList.add(stepResult);
        failedMap.putAll(stepFailedMap);
        if (null != executionContext.getExecutionListener() && null != executionContext.getExecutionListener().getFailedNodesListener()) {
            if (nodeFailures.size() > 0) {
                executionContext.getExecutionListener().getFailedNodesListener().nodesFailed(nodeFailures);
            } else if (stepSuccess) {
                executionContext.getExecutionListener().getFailedNodesListener().nodesSucceeded();
            }
        }
        return new StepResultCapture(stepResult, stepSuccess, statusString, controlBehavior);
    }

    public static class StepResultCapture {
        private StepExecutionResult stepResult;
        private boolean stepSuccess;
        private String statusString;
        private ControlBehavior controlBehavior;

        public StepResultCapture(StepExecutionResult stepResult, boolean stepSuccess, String statusString, ControlBehavior controlBehavior) {
            this.stepResult = stepResult;
            this.stepSuccess = stepSuccess;
            this.statusString = statusString;
            this.controlBehavior = controlBehavior;
        }

        boolean isStepSuccess() {
            return this.stepSuccess;
        }

        public String getStatusString() {
            return this.statusString;
        }

        public ControlBehavior getControlBehavior() {
            return this.controlBehavior;
        }

        public StepExecutionResult getStepResult() {
            return this.stepResult;
        }

        public String toString() {
            return "StepResultCapture{stepResult=" + this.stepResult + ", stepSuccess=" + this.stepSuccess + ", statusString='" + this.statusString + '\'' + ", controlBehavior=" + (Object)((Object)this.controlBehavior) + '}';
        }
    }

    static class BaseWorkflowExecutionResult
    extends BaseWorkflowStatusResult
    implements WorkflowExecutionResult {
        private final List<StepExecutionResult> results;
        private final Map<String, Collection<StepExecutionResult>> failures;
        private final Map<Integer, StepExecutionResult> stepFailures;
        private final Exception orig;

        public BaseWorkflowExecutionResult(List<StepExecutionResult> results, Map<String, Collection<StepExecutionResult>> failures, Map<Integer, StepExecutionResult> stepFailures, Exception orig, WorkflowStatusResult status) {
            super(status);
            this.results = results;
            this.failures = failures;
            this.stepFailures = stepFailures;
            this.orig = orig;
        }

        @Override
        public List<StepExecutionResult> getResultSet() {
            return this.results;
        }

        @Override
        public Map<String, Collection<StepExecutionResult>> getNodeFailures() {
            return this.failures;
        }

        @Override
        public Exception getException() {
            return this.orig;
        }

        public String toString() {
            return "[Workflow result: " + (null != this.getStepFailures() && this.getStepFailures().size() > 0 ? ", step failures: " + this.getStepFailures() : "") + (null != this.getNodeFailures() && this.getNodeFailures().size() > 0 ? ", Node failures: " + this.getNodeFailures() : "") + (null != this.getException() ? ", exception: " + this.getException() : "") + (null != this.getControlBehavior() ? ", flow control: " + (Object)((Object)this.getControlBehavior()) : "") + (null != this.getStatusString() ? ", status: " + this.getStatusString() : ", status: " + (this.isSuccess() ? "succeeded" : "failed")) + "]";
        }

        @Override
        public Map<Integer, StepExecutionResult> getStepFailures() {
            return this.stepFailures;
        }
    }

    static class BaseWorkflowStatusResult
    implements WorkflowStatusResult {
        private boolean status;
        private String statusString;
        private ControlBehavior controlBehavior;

        public BaseWorkflowStatusResult(boolean status, String statusString, ControlBehavior controlBehavior) {
            this.status = status;
            this.statusString = statusString;
            this.controlBehavior = controlBehavior;
        }

        public BaseWorkflowStatusResult(WorkflowStatusResult result) {
            this.status = result.isSuccess();
            this.statusString = result.getStatusString();
            this.controlBehavior = result.getControlBehavior();
        }

        @Override
        public boolean isSuccess() {
            return this.status;
        }

        @Override
        public String getStatusString() {
            return this.statusString;
        }

        @Override
        public ControlBehavior getControlBehavior() {
            return this.controlBehavior;
        }
    }
}

