/*
 * Decompiled with CFR 0.152.
 */
package com.dtolabs.rundeck.core.execution.workflow;

import com.dtolabs.rundeck.core.execution.workflow.BaseWorkflowExecutor;
import com.dtolabs.rundeck.core.execution.workflow.ControlBehavior;
import com.dtolabs.rundeck.core.execution.workflow.EngineWorkflowExecutor;
import com.dtolabs.rundeck.core.execution.workflow.EngineWorkflowStepOperationSuccess;
import com.dtolabs.rundeck.core.execution.workflow.steps.StepExecutionResult;
import com.dtolabs.rundeck.core.rules.Condition;
import com.dtolabs.rundeck.core.rules.MutableStateObj;
import com.dtolabs.rundeck.core.rules.StateObj;
import com.dtolabs.rundeck.core.rules.States;
import com.dtolabs.rundeck.core.rules.WorkflowSystem;
import java.util.Set;
import java.util.concurrent.Callable;

class EngineWorkflowStepOperation
implements WorkflowSystem.Operation<EngineWorkflowStepOperationSuccess> {
    int stepNum;
    String label;
    Set<Condition> startTriggerConditions;
    Set<Condition> skipTriggerConditions;
    private Callable<BaseWorkflowExecutor.StepResultCapture> callable;
    private StateObj startTriggerState;
    private StateObj skipTriggerState;
    private boolean didRun = false;

    EngineWorkflowStepOperation(int stepNum, String label, Callable<BaseWorkflowExecutor.StepResultCapture> callable, StateObj startTriggerState, StateObj skipTriggerState, Set<Condition> startTriggerConditions, Set<Condition> skipTriggerConditions) {
        this.stepNum = stepNum;
        this.label = label;
        this.callable = callable;
        this.startTriggerState = startTriggerState;
        this.startTriggerConditions = startTriggerConditions;
        this.skipTriggerConditions = skipTriggerConditions;
        this.skipTriggerState = skipTriggerState;
    }

    @Override
    public boolean shouldRun(StateObj state) {
        return state.hasState(this.startTriggerState);
    }

    @Override
    public boolean shouldSkip(StateObj state) {
        return null != this.skipTriggerState && state.hasState(this.skipTriggerState);
    }

    @Override
    public EngineWorkflowStepOperationSuccess call() throws Exception {
        boolean success;
        this.didRun = true;
        BaseWorkflowExecutor.StepResultCapture stepResultCapture = this.callable.call();
        StepExecutionResult result = stepResultCapture.getStepResult();
        ControlBehavior controlBehavior = stepResultCapture.getControlBehavior();
        String statusString = stepResultCapture.getStatusString();
        EngineWorkflowExecutor.logger.debug((Object)("StepOperation callable complete: " + stepResultCapture));
        MutableStateObj stateChanges = States.mutable();
        boolean bl = success = null != result && result.isSuccess();
        if (result != null) {
            EngineWorkflowExecutor.updateStateWithStepResultData(stateChanges, this.stepNum, result.getResultData(), result.getFailureData());
        }
        stateChanges.updateState(EngineWorkflowExecutor.stepKey("step.#.completed", this.stepNum), EngineWorkflowExecutor.VALUE_TRUE);
        String stepResultValue = success ? "success" : "failure";
        stateChanges.updateState(EngineWorkflowExecutor.stepKey("step.#.state", this.stepNum), stepResultValue);
        if (this.label != null) {
            stateChanges.updateState(EngineWorkflowExecutor.stepKey("step.#.state", "label." + this.label), stepResultValue);
            stateChanges.updateState(EngineWorkflowExecutor.stepKey("step.#.completed", "label." + this.label), EngineWorkflowExecutor.VALUE_TRUE);
            if (result != null) {
                EngineWorkflowExecutor.updateStateWithStepResultData(stateChanges, "label." + this.label, result.getResultData(), result.getFailureData());
            }
        }
        if (success) {
            stateChanges.updateState("step.any.state.success", EngineWorkflowExecutor.VALUE_TRUE);
        } else {
            stateChanges.updateState("step.any.state.failed", EngineWorkflowExecutor.VALUE_TRUE);
        }
        stateChanges.updateState(EngineWorkflowExecutor.stepKey("before.step.#", this.stepNum), EngineWorkflowExecutor.VALUE_FALSE);
        stateChanges.updateState(EngineWorkflowExecutor.stepKey("after.step.#", this.stepNum), EngineWorkflowExecutor.VALUE_TRUE);
        if (controlBehavior != null) {
            stateChanges.updateState(EngineWorkflowExecutor.stepKey("step.#.flowcontrol", this.stepNum), controlBehavior.toString());
            if (controlBehavior == ControlBehavior.Halt) {
                stateChanges.updateState("step.any.flowcontrol.halt", EngineWorkflowExecutor.VALUE_TRUE);
            }
            if (null != statusString) {
                stateChanges.updateState(EngineWorkflowExecutor.stepKey("step.#.flowstatus", this.stepNum), statusString);
            }
        }
        return new EngineWorkflowStepOperationSuccess(this.stepNum, result, stateChanges, controlBehavior, statusString);
    }

    @Override
    public StateObj getSkipState(StateObj state) {
        MutableStateObj stateChanges = States.mutable();
        stateChanges.updateState(EngineWorkflowExecutor.stepKey("step.#.completed", this.stepNum), EngineWorkflowExecutor.VALUE_FALSE);
        stateChanges.updateState(EngineWorkflowExecutor.stepKey("step.#.state", this.stepNum), "skipped");
        stateChanges.updateState("step.any.state.skipped", EngineWorkflowExecutor.VALUE_TRUE);
        stateChanges.updateState(EngineWorkflowExecutor.stepKey("before.step.#", this.stepNum), EngineWorkflowExecutor.VALUE_FALSE);
        stateChanges.updateState(EngineWorkflowExecutor.stepKey("after.step.#", this.stepNum), EngineWorkflowExecutor.VALUE_TRUE);
        return stateChanges;
    }

    @Override
    public StateObj getFailureState(Throwable t) {
        MutableStateObj stateChanges = States.mutable();
        stateChanges.updateState(EngineWorkflowExecutor.stepKey("step.#.completed", this.stepNum), EngineWorkflowExecutor.VALUE_TRUE);
        stateChanges.updateState(EngineWorkflowExecutor.stepKey("step.#.state", this.stepNum), "failure");
        stateChanges.updateState(EngineWorkflowExecutor.stepKey("before.step.#", this.stepNum), EngineWorkflowExecutor.VALUE_FALSE);
        stateChanges.updateState(EngineWorkflowExecutor.stepKey("after.step.#", this.stepNum), EngineWorkflowExecutor.VALUE_TRUE);
        return stateChanges;
    }

    public boolean isDidRun() {
        return this.didRun;
    }

    public String toString() {
        return "EngineWorkflowStepOperation{stepNum=" + this.stepNum + ", label='" + this.label + '\'' + '}';
    }
}

