/*
 * Decompiled with CFR 0.152.
 */
package com.dtolabs.rundeck.core.execution.workflow;

import com.dtolabs.rundeck.core.common.Framework;
import com.dtolabs.rundeck.core.execution.StepExecutionItem;
import com.dtolabs.rundeck.core.execution.workflow.BaseWorkflowExecutor;
import com.dtolabs.rundeck.core.execution.workflow.ControlBehavior;
import com.dtolabs.rundeck.core.execution.workflow.IWorkflow;
import com.dtolabs.rundeck.core.execution.workflow.StepExecutionContext;
import com.dtolabs.rundeck.core.execution.workflow.WorkflowExecutionItem;
import com.dtolabs.rundeck.core.execution.workflow.WorkflowExecutionListener;
import com.dtolabs.rundeck.core.execution.workflow.WorkflowExecutionResult;
import com.dtolabs.rundeck.core.execution.workflow.WorkflowStatusResult;
import com.dtolabs.rundeck.core.execution.workflow.steps.StepExecutionResult;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;

public class ParallelWorkflowExecutor
extends BaseWorkflowExecutor {
    protected static final String DATA_CONTEXT_PREFIX = "data context: ";

    public ParallelWorkflowExecutor(Framework framework) {
        super(framework);
    }

    @Override
    public WorkflowExecutionResult executeWorkflowImpl(StepExecutionContext executionContext, WorkflowExecutionItem item) {
        WorkflowStatusResult workflowResult = WorkflowResultFailed;
        RuntimeException exception = null;
        IWorkflow workflow = item.getWorkflow();
        HashMap<Integer, StepExecutionResult> stepFailures = new HashMap<Integer, StepExecutionResult>();
        ArrayList<StepExecutionResult> stepResults = new ArrayList<StepExecutionResult>();
        try {
            executionContext.getExecutionListener().log(4, "NodeSet: " + executionContext.getNodeSelector());
            executionContext.getExecutionListener().log(4, "Workflow: " + workflow);
            Map<String, Map<String, String>> printableContext = this.createPrintableDataContext("option", "secureOption", "****", executionContext.getDataContext());
            executionContext.getExecutionListener().log(4, String.format("%s %s", DATA_CONTEXT_PREFIX, printableContext));
            List<StepExecutionItem> iWorkflowCmdItems = workflow.getCommands();
            if (iWorkflowCmdItems.size() < 1) {
                executionContext.getExecutionListener().log(1, "Workflow has 0 items");
            }
            workflowResult = this.executeWorkflowItemsInParallel(executionContext, stepFailures, stepResults, iWorkflowCmdItems, workflow.isKeepgoing());
        }
        catch (RuntimeException e) {
            exception = e;
            e.printStackTrace();
            executionContext.getExecutionListener().log(0, "Exception: " + e.getClass() + ": " + e.getMessage());
        }
        RuntimeException orig = exception;
        Map<String, Collection<StepExecutionResult>> nodeFailures = this.convertFailures(stepFailures);
        return new BaseWorkflowExecutor.BaseWorkflowExecutionResult(stepResults, nodeFailures, stepFailures, orig, workflowResult);
    }

    protected WorkflowStatusResult executeWorkflowItemsInParallel(final StepExecutionContext executionContext, final Map<Integer, StepExecutionResult> failedMap, List<StepExecutionResult> resultList, List<StepExecutionItem> iWorkflowCmdItems, boolean keepgoing) {
        final WorkflowExecutionListener wlistener = this.getWorkflowListener(executionContext);
        int numCommands = iWorkflowCmdItems.size();
        ExecutorService es = Executors.newFixedThreadPool(numCommands);
        final HashMap stepExecutionResults = new HashMap();
        ArrayList<1> parallelSteps = new ArrayList<1>();
        for (int i = 0; i < iWorkflowCmdItems.size(); ++i) {
            final HashMap hashMap = new HashMap();
            final StepExecutionItem cmd = iWorkflowCmdItems.get(i);
            final int stepNum = executionContext.getStepNumber() + i;
            Runnable cmdExecution = new Runnable(){

                @Override
                public void run() {
                    try {
                        StepExecutionResult result = ParallelWorkflowExecutor.this.executeWorkflowStep(wlistener, cmd, executionContext, hashMap, stepNum);
                        stepExecutionResults.put(stepNum, result);
                        failedMap.putAll(hashMap);
                    }
                    catch (Exception ex) {
                        String message = String.format("Exception while executing step [%d]: \t[%s]", stepNum, ex.getMessage());
                        executionContext.getExecutionListener().log(0, message);
                        throw new RuntimeException(ex);
                    }
                }
            };
            parallelSteps.add(cmdExecution);
        }
        for (Runnable runnable : parallelSteps) {
            es.execute(runnable);
        }
        es.shutdown();
        try {
            if (!es.awaitTermination(Long.MAX_VALUE, TimeUnit.MINUTES)) {
                es.shutdownNow();
            }
        }
        catch (InterruptedException ioex) {
            executionContext.getExecutionListener().log(1, "Workflow execution interrupted");
        }
        for (int i = 0; i < iWorkflowCmdItems.size(); ++i) {
            int n = i + executionContext.getStepNumber();
            if (null != stepExecutionResults.get(n) && ((StepExecutionResult)stepExecutionResults.get(n)).isSuccess()) continue;
            return WorkflowResultFailed;
        }
        return ParallelWorkflowExecutor.workflowResult(true, null, ControlBehavior.Continue);
    }
}

