/*
 * Decompiled with CFR 0.152.
 */
package com.dtolabs.rundeck.core.plugins;

import com.dtolabs.rundeck.core.plugins.PluginException;
import com.dtolabs.rundeck.core.plugins.PluginResourceLoader;
import com.dtolabs.rundeck.core.utils.ZipUtil;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.jar.JarInputStream;
import java.util.zip.ZipEntry;

public class ZipResourceLoader
implements PluginResourceLoader {
    File cacheDir;
    File zipFile;
    List<String> resourcesList;
    String resourcesBasedir;
    List<String> basedirListing;

    public ZipResourceLoader(File cacheDir, File zipFile, List<String> resourcesList, String resourcesBasedir) {
        this.cacheDir = cacheDir;
        this.zipFile = zipFile;
        this.resourcesList = resourcesList;
        this.resourcesBasedir = resourcesBasedir;
    }

    @Override
    public List<String> listResources() {
        return Arrays.asList(this.getResourceNames());
    }

    public String[] getResourceNames() {
        if (null != this.resourcesList) {
            return this.resourcesList.toArray(new String[this.resourcesList.size()]);
        }
        if (null != this.basedirListing) {
            return this.basedirListing.toArray(new String[this.basedirListing.size()]);
        }
        String[] list = ZipResourceLoader.listZipPath(this.zipFile, this.resourcesBasedir);
        if (null != list) {
            this.basedirListing = Arrays.asList(list);
            return list;
        }
        return null;
    }

    private static String[] listZipPath(File file, String path) {
        ArrayList<String> strings = new ArrayList<String>();
        try (JarInputStream jarInputStream = new JarInputStream(new FileInputStream(file));){
            ZipEntry nextJarEntry = jarInputStream.getNextEntry();
            while (nextJarEntry != null) {
                if (nextJarEntry.getName().startsWith(path + "/") && !nextJarEntry.getName().endsWith("/")) {
                    strings.add(nextJarEntry.getName().substring(path.length() + 1));
                }
                nextJarEntry = jarInputStream.getNextEntry();
            }
        }
        catch (IOException e) {
            return null;
        }
        return strings.toArray(new String[strings.size()]);
    }

    @Override
    public InputStream openResourceStreamFor(String path) throws PluginException, IOException {
        if (null == this.cacheDir) {
            throw new PluginException(String.format("Resource path %s was not found in the file: %s", path, this.zipFile.getAbsolutePath()));
        }
        File resfile = new File(this.cacheDir, path);
        if (!resfile.isFile()) {
            throw new PluginException(String.format("Resource path %s did not exist in the file: %s", path, this.zipFile.getAbsolutePath()));
        }
        return new FileInputStream(resfile);
    }

    public void extractResources() throws IOException {
        if (this.cacheDir.isDirectory() || !this.cacheDir.mkdirs()) {
            // empty if block
        }
        if (null != this.resourcesList) {
            this.extractJarContents(this.resourcesList, this.cacheDir);
            for (String s : this.resourcesList) {
                File libFile = new File(this.cacheDir, s);
                libFile.deleteOnExit();
            }
        } else {
            ZipUtil.extractZip(this.zipFile.getAbsolutePath(), this.cacheDir, this.resourcesBasedir, this.resourcesBasedir);
        }
    }

    private void extractJarContents(List<String> entries, File destdir) throws IOException {
        if (destdir.exists() || !destdir.mkdir()) {
            // empty if block
        }
        for (String path : entries) {
            ZipUtil.extractZipFile(this.zipFile.getAbsolutePath(), destdir, path);
        }
    }
}

