/*
 * Decompiled with CFR 0.152.
 */
package com.dtolabs.rundeck.core.plugins.configuration;

import com.dtolabs.rundeck.core.common.Framework;
import com.dtolabs.rundeck.core.common.IRundeckProject;
import com.dtolabs.rundeck.core.common.PropertyRetriever;
import com.dtolabs.rundeck.core.execution.ExecutionContext;
import com.dtolabs.rundeck.core.execution.workflow.StepExecutionContext;
import com.dtolabs.rundeck.core.plugins.configuration.Property;
import com.dtolabs.rundeck.core.plugins.configuration.PropertyResolver;
import com.dtolabs.rundeck.core.plugins.configuration.PropertyScope;
import com.dtolabs.rundeck.core.plugins.configuration.RuntimePropertyResolver;
import com.dtolabs.rundeck.core.utils.IPropertyLookup;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class PropertyResolverFactory {
    public static final String SEP = ".";
    public static final String PROJECT_PREFIX = "project.";
    public static final String FRAMEWORK_PREFIX = "framework.";
    public static final String PLUGIN_PREFIX = "plugin.";

    public static String pluginPropertyPrefix(String stepType, String pluginName) {
        return PLUGIN_PREFIX + stepType + SEP + pluginName + SEP;
    }

    public static String projectPropertyPrefix(String basePrefix) {
        return PROJECT_PREFIX + basePrefix;
    }

    public static String frameworkPropertyPrefix(String basePrefix) {
        return FRAMEWORK_PREFIX + basePrefix;
    }

    public static Map<String, Object> mapPropertyValues(List<Property> list, PropertyResolver resolver) {
        HashMap<String, Object> inputConfig = new HashMap<String, Object>();
        for (Property property : list) {
            Object value = resolver.resolvePropertyValue(property.getName(), property.getScope());
            if (null == value) continue;
            inputConfig.put(property.getName(), value);
        }
        return inputConfig;
    }

    public static PropertyResolver createStepPluginRuntimeResolver(StepExecutionContext context, Map<String, Object> instanceProperties, String pluginType, String providerName) {
        String projectPrefix = PropertyResolverFactory.projectPropertyPrefix(PropertyResolverFactory.pluginPropertyPrefix(pluginType, providerName));
        String frameworkPrefix = PropertyResolverFactory.frameworkPropertyPrefix(PropertyResolverFactory.pluginPropertyPrefix(pluginType, providerName));
        return PropertyResolverFactory.createResolver(PropertyResolverFactory.instanceRetriever(instanceProperties), PropertyResolverFactory.projectRetriever(projectPrefix, context.getFramework(), context.getFrameworkProject()), PropertyResolverFactory.frameworkRetriever(frameworkPrefix, context.getFramework()));
    }

    public static PropertyResolver createPluginRuntimeResolver(ExecutionContext context, Map<String, Object> instanceProperties, String pluginType, String providerName) {
        String projectPrefix = PropertyResolverFactory.projectPropertyPrefix(PropertyResolverFactory.pluginPropertyPrefix(pluginType, providerName));
        String frameworkPrefix = PropertyResolverFactory.frameworkPropertyPrefix(PropertyResolverFactory.pluginPropertyPrefix(pluginType, providerName));
        return PropertyResolverFactory.createResolver(PropertyResolverFactory.instanceRetriever(instanceProperties), PropertyResolverFactory.projectRetriever(projectPrefix, context.getFramework(), context.getFrameworkProject()), PropertyResolverFactory.frameworkRetriever(frameworkPrefix, context.getFramework()));
    }

    public static PropertyResolver createFrameworkProjectRuntimeResolver(Framework framework, String projectName, Map<String, Object> instanceProperties, String pluginType, String providerName) {
        String projectPrefix = PropertyResolverFactory.projectPropertyPrefix(PropertyResolverFactory.pluginPropertyPrefix(pluginType, providerName));
        String frameworkPrefix = PropertyResolverFactory.frameworkPropertyPrefix(PropertyResolverFactory.pluginPropertyPrefix(pluginType, providerName));
        return PropertyResolverFactory.createResolver(PropertyResolverFactory.instanceRetriever(instanceProperties), null != projectName ? PropertyResolverFactory.projectRetriever(projectPrefix, framework, projectName) : null, PropertyResolverFactory.frameworkRetriever(frameworkPrefix, framework));
    }

    public static PropertyResolver createFrameworkProjectRuntimeResolver(IPropertyLookup framework, IPropertyLookup projectLookup, Map<String, Object> instanceProperties, String pluginType, String providerName) {
        String projectPrefix = PropertyResolverFactory.projectPropertyPrefix(PropertyResolverFactory.pluginPropertyPrefix(pluginType, providerName));
        String frameworkPrefix = PropertyResolverFactory.frameworkPropertyPrefix(PropertyResolverFactory.pluginPropertyPrefix(pluginType, providerName));
        return PropertyResolverFactory.createResolver(PropertyResolverFactory.instanceRetriever(instanceProperties), null != projectLookup ? PropertyResolverFactory.prefixedRetriever(projectPrefix, projectLookup) : null, PropertyResolverFactory.prefixedRetriever(frameworkPrefix, framework));
    }

    public static PropertyResolver createResolver(PropertyRetriever instanceRetriever, PropertyRetriever projectRetriever, PropertyRetriever frameworkRetriever) {
        return new RuntimePropertyResolver(instanceRetriever, projectRetriever, frameworkRetriever);
    }

    public static PropertyResolver createPrefixedResolver(final PropertyResolver resolver, String providerName, String pluginType) {
        final String projectPrefix = PropertyResolverFactory.projectPropertyPrefix(PropertyResolverFactory.pluginPropertyPrefix(pluginType, providerName));
        final String frameworkPrefix = PropertyResolverFactory.frameworkPropertyPrefix(PropertyResolverFactory.pluginPropertyPrefix(pluginType, providerName));
        return new PropertyResolver(){

            @Override
            public Object resolvePropertyValue(String name, PropertyScope scope) {
                String value = null;
                if (scope.isInstanceLevel()) {
                    value = (String)resolver.resolvePropertyValue(name, scope);
                }
                if (null != value || scope == PropertyScope.InstanceOnly) {
                    return value;
                }
                if (scope.isProjectLevel()) {
                    value = (String)resolver.resolvePropertyValue(projectPrefix + name, scope);
                }
                if (null != value || scope == PropertyScope.ProjectOnly) {
                    return value;
                }
                value = (String)resolver.resolvePropertyValue(frameworkPrefix + name, scope);
                return value;
            }
        };
    }

    public static PropertyResolver createInstanceResolver(Map<String, Object> instanceProperties) {
        return PropertyResolverFactory.createResolver(PropertyResolverFactory.instanceRetriever(instanceProperties), null, null);
    }

    private static PropertyRetriever frameworkRetriever(String frameworkPrefix, Framework framework) {
        return PropertyResolverFactory.prefixedRetriever(frameworkPrefix, framework.getPropertyRetriever());
    }

    private static PropertyRetriever projectRetriever(String projectPrefix, Framework framework, String project) {
        IRundeckProject frameworkProject = framework.getFrameworkProjectMgr().getFrameworkProject(project);
        return PropertyResolverFactory.prefixedRetriever(projectPrefix, PropertyResolverFactory.instanceRetriever(frameworkProject.getProperties()));
    }

    private static PropertyRetriever projectRetriever(String projectPrefix, IPropertyLookup projectLookup) {
        return PropertyResolverFactory.prefixedRetriever(projectPrefix, projectLookup);
    }

    public static PropertyRetriever instanceRetriever(Map<String, ?> configuration) {
        return new MapPropertyRetriever(configuration);
    }

    private static PropertyRetriever prefixedRetriever(String prefix, PropertyRetriever resolver) {
        return new PrefixRetriever(prefix, resolver);
    }

    public static PropertyResolver withDefaultScope(PropertyScope scope, PropertyResolver resolver) {
        return new DefaultScopeRetriever(scope, resolver);
    }

    public static PropertyResolver withDefaultValues(PropertyResolver resolver, PropertyRetriever defaults) {
        return new DefaultValueRetriever(resolver, defaults);
    }

    private static class DefaultValueRetriever
    implements PropertyResolver {
        private final PropertyResolver resolver;
        final PropertyRetriever defaults;

        private DefaultValueRetriever(PropertyResolver resolver, PropertyRetriever defaults) {
            this.defaults = defaults;
            this.resolver = resolver;
        }

        @Override
        public Object resolvePropertyValue(String name, PropertyScope scope) {
            Object value = this.resolver.resolvePropertyValue(name, scope);
            return null == value ? this.defaults.getProperty(name) : value;
        }
    }

    private static class DefaultScopeRetriever
    implements PropertyResolver {
        private final PropertyScope defaultScope;
        private final PropertyResolver resolver;

        private DefaultScopeRetriever(PropertyScope defaultScope, PropertyResolver resolver) {
            this.defaultScope = defaultScope;
            this.resolver = resolver;
        }

        @Override
        public Object resolvePropertyValue(String name, PropertyScope scope) {
            if (null == scope || scope == PropertyScope.Unspecified) {
                scope = this.defaultScope;
            }
            return this.resolver.resolvePropertyValue(name, scope);
        }
    }

    private static class PrefixRetriever
    implements PropertyRetriever {
        private final String prefix;
        private final PropertyRetriever resolver;

        private PrefixRetriever(String prefix, PropertyRetriever resolver) {
            this.prefix = prefix;
            this.resolver = resolver;
        }

        @Override
        public String getProperty(String name) {
            return this.resolver.getProperty(this.prefix + name);
        }
    }

    private static class MapPropertyRetriever
    implements PropertyRetriever {
        private Map<String, ?> map;

        private MapPropertyRetriever(Map<String, ?> map) {
            this.map = map;
        }

        @Override
        public String getProperty(String name) {
            Object o = null != this.map ? (Object)this.map.get(name) : null;
            return o != null ? o.toString() : null;
        }
    }
}

