/*
 * Decompiled with CFR 0.152.
 */
package com.dtolabs.rundeck.core.resources.format;

import com.dtolabs.rundeck.core.common.INodeSet;
import com.dtolabs.rundeck.core.common.NodesGeneratorException;
import com.dtolabs.rundeck.core.common.NodesYamlGenerator;
import com.dtolabs.rundeck.core.plugins.Plugin;
import com.dtolabs.rundeck.core.plugins.configuration.Describable;
import com.dtolabs.rundeck.core.plugins.configuration.Description;
import com.dtolabs.rundeck.core.resources.format.ResourceFormatGenerator;
import com.dtolabs.rundeck.core.resources.format.ResourceFormatGeneratorException;
import com.dtolabs.rundeck.plugins.util.DescriptionBuilder;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

@Plugin(name="resourceyaml", service="ResourceFormatGenerator")
public class ResourceYamlFormatGenerator
implements ResourceFormatGenerator,
Describable {
    public static final String SERVICE_PROVIDER_TYPE = "resourceyaml";
    public static final Set<String> EXTENSIONS = Collections.unmodifiableSet(new HashSet<String>(Arrays.asList("yaml", "yml")));
    public static final List<String> MIME_TYPES = Collections.unmodifiableList(Arrays.asList("text/yaml", "text/x-yaml", "application/yaml", "application/x-yaml"));
    private static final Description DESCRIPTION = DescriptionBuilder.builder().name("resourceyaml").title("Resource YAML").description("The Rundeck Resource YAML format 1.3 (bundled)").build();

    @Override
    public Set<String> getFileExtensions() {
        return EXTENSIONS;
    }

    @Override
    public List<String> getMIMETypes() {
        return MIME_TYPES;
    }

    @Override
    public void generateDocument(INodeSet nodeset, OutputStream stream) throws ResourceFormatGeneratorException, IOException {
        NodesYamlGenerator nodesYamlGenerator = new NodesYamlGenerator(stream);
        nodesYamlGenerator.addNodes(nodeset.getNodes());
        try {
            nodesYamlGenerator.generate();
        }
        catch (NodesGeneratorException e) {
            throw new ResourceFormatGeneratorException(e);
        }
    }

    @Override
    public Description getDescription() {
        return DESCRIPTION;
    }
}

