/*
 * Decompiled with CFR 0.152.
 */
package com.dtolabs.rundeck.core.rules;

import com.dtolabs.rundeck.core.rules.MutableStateObj;
import com.dtolabs.rundeck.core.rules.Rule;
import com.dtolabs.rundeck.core.rules.RuleEngine;
import com.dtolabs.rundeck.core.rules.Rules;
import com.dtolabs.rundeck.core.rules.StateObj;
import com.dtolabs.rundeck.core.rules.States;
import com.google.common.base.Optional;
import com.google.common.collect.FluentIterable;
import com.google.common.collect.ImmutableList;
import java.util.Set;

public class BaseRuleEngine
implements RuleEngine {
    private Set<Rule> ruleSet;

    public BaseRuleEngine(Set<Rule> ruleSet) {
        this.ruleSet = ruleSet;
    }

    @Override
    public Set<Rule> getRuleSet() {
        return this.ruleSet;
    }

    @Override
    public void addRule(Rule rule) {
        this.ruleSet.add(rule);
    }

    @Override
    public StateObj evaluateRules(StateObj state) {
        MutableStateObj dataState = States.mutable();
        ImmutableList newStates = FluentIterable.from(this.getRuleSet()).filter(Rules.ruleApplies(state)).transform(Rules.applyRule(state)).toList();
        for (StateObj evaluate : Optional.presentInstances((Iterable)newStates)) {
            dataState.updateState(evaluate);
        }
        return dataState;
    }

    public String toString() {
        return "RuleEngine{ruleSet=" + this.ruleSet + '}';
    }
}

