/*
 * Decompiled with CFR 0.152.
 */
package com.dtolabs.rundeck.core.rules;

import com.dtolabs.rundeck.core.rules.MutableStateObj;
import com.dtolabs.rundeck.core.rules.RuleEngine;
import com.dtolabs.rundeck.core.rules.Rules;
import com.dtolabs.rundeck.core.rules.StateObj;
import com.dtolabs.rundeck.core.rules.WorkflowSystem;
import com.dtolabs.rundeck.core.rules.WorkflowSystemEvent;
import com.dtolabs.rundeck.core.rules.WorkflowSystemEventListener;
import com.dtolabs.rundeck.core.rules.WorkflowSystemEventType;
import com.dtolabs.rundeck.core.rules.Workflows;
import com.google.common.base.Predicate;
import com.google.common.collect.FluentIterable;
import com.google.common.collect.ImmutableList;
import com.google.common.util.concurrent.FutureCallback;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.ListeningExecutorService;
import com.google.common.util.concurrent.MoreExecutors;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.TimeUnit;
import org.apache.log4j.Logger;

public class WorkflowEngine
implements WorkflowSystem {
    static Logger logger = Logger.getLogger((String)WorkflowEngine.class.getName());
    private MutableStateObj state;
    private final RuleEngine engine;
    private final LinkedBlockingQueue<StateObj> stateChangeQueue;
    private final Set<WorkflowSystem.Operation> inProcess = Collections.synchronizedSet(new HashSet());
    private final Set<WorkflowSystem.Operation> skipped = new HashSet<WorkflowSystem.Operation>();
    private final ListeningExecutorService executorService;
    private final ListeningExecutorService manager;
    private WorkflowSystemEventListener listener;
    private volatile boolean interrupted;

    public WorkflowEngine(RuleEngine engine, MutableStateObj state, ExecutorService executor) {
        this.engine = engine;
        this.state = state;
        this.stateChangeQueue = new LinkedBlockingQueue();
        this.executorService = MoreExecutors.listeningDecorator((ExecutorService)executor);
        this.manager = MoreExecutors.listeningDecorator((ExecutorService)Executors.newCachedThreadPool());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <T extends WorkflowSystem.OperationSuccess, X extends WorkflowSystem.Operation<T>> Set<WorkflowSystem.OperationResult<T, X>> processOperations(Set<X> operations) {
        this.event(WorkflowSystemEventType.Begin, "Workflow begin");
        this.queueChange(Workflows.getWorkflowStartState());
        HashSet<X> pending = new HashSet<X>(operations);
        final Set<WorkflowSystem.OperationResult<T, X>> results = Collections.synchronizedSet(new HashSet());
        final List<ListenableFuture> futures = Collections.synchronizedList(new ArrayList());
        this.interrupted = false;
        long sleepOrig = 250L;
        long sleepMult = 2L;
        long sleepmax = 5000L;
        long sleeptime = sleepOrig;
        while (!this.interrupted) {
            try {
                HashMap<String, String> changes = new HashMap<String, String>();
                this.pollAll(changes);
                if (changes.size() < 1) {
                    if (this.inProcess.size() < 1) {
                        this.event(WorkflowSystemEventType.EndOfChanges, "No more state changes expected, finishing workflow.");
                        break;
                    }
                    StateObj take = this.stateChangeQueue.poll(sleeptime, TimeUnit.MILLISECONDS);
                    if (null == take || take.getState().size() < 1) {
                        sleeptime = Math.min(sleeptime * sleepMult, sleepmax);
                        continue;
                    }
                    sleeptime = sleepOrig;
                    changes.putAll(take.getState());
                    this.pollAll(changes);
                }
                this.event(WorkflowSystemEventType.WillProcessStateChange, String.format("saw state changes: %s", changes), changes);
                this.state.updateState(changes);
                boolean update = Rules.update(this.engine, this.state);
                this.event(WorkflowSystemEventType.DidProcessStateChange, String.format("applied state changes and rules (changed? %s): %s", update, this.state), this.state);
                if (this.isWorkflowEndState(this.state)) {
                    this.event(WorkflowSystemEventType.WorkflowEndState, "Workflow end state reached.");
                    break;
                }
                int origPendingCount = pending.size();
                FluentIterable runnable = FluentIterable.from(pending).filter(WorkflowEngine.shouldRun(this.state));
                ImmutableList shouldskip = runnable.filter(WorkflowEngine.shouldSkip(this.state, true)).toList();
                ImmutableList shouldrun = runnable.toList();
                for (final WorkflowSystem.Operation operation : shouldrun) {
                    if (shouldskip.contains(operation)) continue;
                    pending.remove(operation);
                    this.event(WorkflowSystemEventType.WillRunOperation, String.format("operation starting: %s", operation), operation);
                    final ListenableFuture submit = this.executorService.submit((Callable)operation);
                    this.inProcess.add(operation);
                    futures.add(submit);
                    FutureCallback cleanup = new FutureCallback<T>(){

                        public void onSuccess(T result) {
                            futures.remove(submit);
                        }

                        public void onFailure(Throwable t) {
                            futures.remove(submit);
                        }
                    };
                    FutureCallback callback = new FutureCallback<T>(){

                        /*
                         * WARNING - Removed try catching itself - possible behaviour change.
                         */
                        public void onSuccess(T successResult) {
                            WorkflowEngine.this.event(WorkflowSystemEventType.OperationSuccess, String.format("operation succeeded: %s", successResult), successResult);
                            assert (successResult != null);
                            WorkflowSystem.OperationResult result = WorkflowEngine.this.result(successResult, operation);
                            Set set = results;
                            synchronized (set) {
                                results.add(result);
                            }
                            WorkflowEngine.this.queueChange(successResult.getNewState());
                            WorkflowEngine.this.inProcess.remove(operation);
                        }

                        /*
                         * WARNING - Removed try catching itself - possible behaviour change.
                         */
                        public void onFailure(Throwable t) {
                            WorkflowEngine.this.event(WorkflowSystemEventType.OperationFailed, String.format("operation failed: %s", t), t);
                            WorkflowSystem.OperationResult result = WorkflowEngine.this.result((WorkflowSystem.OperationSuccess)((Object)t), (WorkflowSystem.Operation)operation);
                            Set set = results;
                            synchronized (set) {
                                results.add(result);
                            }
                            StateObj newFailureState = operation.getFailureState(t);
                            if (null != newFailureState && newFailureState.getState().size() > 0) {
                                WorkflowEngine.this.queueChange(newFailureState);
                            }
                            WorkflowEngine.this.inProcess.remove(operation);
                        }
                    };
                    Futures.addCallback((ListenableFuture)submit, (FutureCallback)callback, (Executor)this.manager);
                    Futures.addCallback((ListenableFuture)submit, (FutureCallback)cleanup, (Executor)this.manager);
                }
                for (final WorkflowSystem.Operation operation : shouldskip) {
                    this.event(WorkflowSystemEventType.WillSkipOperation, String.format("Skip condition statisfied for operation: %s, skipping", operation), operation);
                    pending.remove(operation);
                    this.skipped.add(operation);
                    StateObj newstate = operation.getSkipState(this.state);
                    this.queueChange(newstate);
                }
                this.event(WorkflowSystemEventType.LoopProgress, String.format("Pending(%d) => run(%d), skip(%d), remain(%d)", origPendingCount, shouldrun.size() - shouldskip.size(), shouldskip.size(), pending.size()));
            }
            catch (InterruptedException e) {
                this.interrupted = true;
                break;
            }
        }
        if (this.interrupted) {
            this.event(WorkflowSystemEventType.Interrupted, "Engine interrupted, stopping engine...");
            List<ListenableFuture> list = futures;
            synchronized (list) {
                for (ListenableFuture future : futures) {
                    if (future.isDone()) continue;
                    future.cancel(true);
                }
            }
        }
        this.event(WorkflowSystemEventType.WillShutdown, "Workflow engine shutting down");
        this.executorService.shutdown();
        try {
            if (!this.executorService.awaitTermination(5L, TimeUnit.MINUTES)) {
                this.executorService.shutdownNow();
            }
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        if (this.inProcess.size() > 0) {
            try {
                Thread.sleep(5000L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
        this.manager.shutdown();
        try {
            if (!this.manager.awaitTermination(5L, TimeUnit.MINUTES)) {
                this.manager.shutdownNow();
            }
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        if (pending.size() > 0) {
            this.event(WorkflowSystemEventType.IncompleteOperations, String.format("Some operations were not run: %d", pending.size()), pending);
        }
        this.event(WorkflowSystemEventType.Complete, String.format("Workflow complete: %s", results));
        return results;
    }

    private void event(WorkflowSystemEventType eventType, String message) {
        this.event(eventType, message, null);
    }

    private void event(final WorkflowSystemEventType eventType, final String message, final Object data) {
        this.logDebug(message);
        if (null != this.listener) {
            this.listener.onEvent(new WorkflowSystemEvent(){

                @Override
                public String getMessage() {
                    return message;
                }

                @Override
                public WorkflowSystemEventType getEventType() {
                    return eventType;
                }

                @Override
                public Object getData() {
                    return data;
                }
            });
        }
    }

    private void logDebug(String message) {
        logger.debug((Object)message);
    }

    protected boolean isWorkflowEndState(MutableStateObj state) {
        return state.hasState(Workflows.getWorkflowEndState());
    }

    public WorkflowSystemEventListener getListener() {
        return this.listener;
    }

    public void setListener(WorkflowSystemEventListener listener) {
        this.listener = listener;
    }

    @Override
    public boolean isInterrupted() {
        return this.interrupted;
    }

    public void setInterrupted(boolean interrupted) {
        this.interrupted = interrupted;
    }

    private <T extends WorkflowSystem.OperationSuccess, X extends WorkflowSystem.Operation<T>> WorkflowSystem.OperationResult<T, X> result(Throwable t, X operation) {
        return new WResult<Throwable, X>(operation, t);
    }

    private <T extends WorkflowSystem.OperationSuccess, X extends WorkflowSystem.Operation<T>> WorkflowSystem.OperationResult<T, X> result(T successResult, X operation) {
        return new WResult<T, X>(operation, successResult);
    }

    private static Predicate<WorkflowSystem.Operation> shouldRun(final StateObj state) {
        return new Predicate<WorkflowSystem.Operation>(){

            public boolean apply(WorkflowSystem.Operation input) {
                assert (input != null);
                return input.shouldRun(state);
            }
        };
    }

    private static Predicate<WorkflowSystem.Operation> shouldSkip(final StateObj state, final boolean requireSkip) {
        return new Predicate<WorkflowSystem.Operation>(){

            public boolean apply(WorkflowSystem.Operation input) {
                assert (input != null);
                return requireSkip == input.shouldSkip(state);
            }
        };
    }

    private void queueChange(StateObj state) {
        this.stateChangeQueue.add(state);
    }

    private Map<String, String> map(String key, String value) {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put(key, value);
        return map;
    }

    private void pollAll(HashMap<String, String> changes) {
        StateObj task = this.stateChangeQueue.poll();
        while (task != null) {
            changes.putAll(task.getState());
            task = this.stateChangeQueue.poll();
        }
    }

    private static class WResult<T extends WorkflowSystem.OperationSuccess, X extends WorkflowSystem.Operation<T>>
    implements WorkflowSystem.OperationResult<T, X> {
        private final X operation;
        final Throwable throwable;
        final T success;

        WResult(X operation, Throwable throwable) {
            this.operation = operation;
            this.throwable = throwable;
            this.success = null;
        }

        WResult(X operation, T success) {
            this.operation = operation;
            this.success = success;
            this.throwable = null;
        }

        @Override
        public Throwable getFailure() {
            return this.throwable;
        }

        @Override
        public T getSuccess() {
            return this.success;
        }

        @Override
        public X getOperation() {
            return this.operation;
        }
    }
}

