/*
 * Decompiled with CFR 0.152.
 */
package com.dtolabs.rundeck.core.dispatcher;

import java.io.FilterReader;
import java.io.IOException;
import java.io.Reader;
import java.util.Map;
import org.apache.commons.collections.Predicate;

public class ReplaceTokenReader
extends FilterReader {
    public static final char DEFAULT_TOKEN_START = '@';
    public static final char DEFAULT_TOKEN_END = '@';
    private Map<String, String> tokens;
    boolean blankIfMissing;
    char tokenStart = (char)64;
    char tokenEnd = (char)64;
    private Predicate tokenCharPredicate;
    public static final Predicate DEFAULT_ALLOWED_PREDICATE = new Predicate(){

        public boolean evaluate(Object o) {
            Character c = (Character)o;
            return !Character.isWhitespace(c.charValue());
        }
    };
    private boolean escaped;
    private Buf readBuffer;
    private Buf tokenBuffer;

    public ReplaceTokenReader(Reader reader, Map<String, String> tokens, boolean blankIfMissing, char tokenStart, char tokenEnd) {
        super(reader);
        this.tokens = tokens;
        this.blankIfMissing = blankIfMissing;
        this.tokenStart = tokenStart;
        this.tokenEnd = tokenEnd;
        this.readBuffer = new Buf();
        this.tokenBuffer = new Buf();
        this.tokenCharPredicate = DEFAULT_ALLOWED_PREDICATE;
    }

    @Override
    public int read(char[] chars, int offset, int len) throws IOException {
        int count;
        for (count = 0; count < len && count + offset < chars.length; ++count) {
            int read = this.read();
            if (read != -1) {
                chars[count + offset] = (char)read;
                continue;
            }
            if (count != 0) break;
            return -1;
        }
        return count;
    }

    @Override
    public int read() throws IOException {
        if (this.readBuffer.avail()) {
            return this.readBuffer.read();
        }
        int read = -1;
        read = this.tokenBuffer.avail() ? this.tokenBuffer.read() : super.read();
        if (this.escaped) {
            this.escaped = false;
            return read;
        }
        if (read == this.tokenStart) {
            this.readBuffer.append((char)read);
            do {
                if ((read = super.read()) == this.tokenStart && this.readBuffer.length() == 1) {
                    return this.read();
                }
                if (read == this.tokenEnd) {
                    this.readBuffer.read();
                    String key = this.readBuffer.readAll();
                    this.readBuffer.append(this.substitution(key));
                    return this.read();
                }
                if (read == -1) continue;
                this.readBuffer.append((char)read);
                if (this.readBuffer.length() <= 1 || this.tokenCharPredicate.evaluate((Object)Character.valueOf((char)read))) continue;
                return this.read();
            } while (read != -1);
            if (this.readBuffer.avail()) {
                return this.readBuffer.read();
            }
        }
        return read;
    }

    private String substitution(String key) {
        if (null != this.tokens.get(key)) {
            return this.tokens.get(key);
        }
        if (this.blankIfMissing) {
            return "";
        }
        return this.tokenStart + key + this.tokenEnd;
    }

    public Predicate getTokenCharPredicate() {
        return this.tokenCharPredicate;
    }

    public void setTokenCharPredicate(Predicate tokenCharPredicate) {
        this.tokenCharPredicate = tokenCharPredicate;
    }

    static class Buf {
        StringBuilder buffer = new StringBuilder();
        int index = -1;

        Buf() {
        }

        int length() {
            return this.index > -1 ? this.buffer.length() - this.index : -1;
        }

        boolean avail() {
            return this.length() > 0;
        }

        public int read() {
            int val = -1;
            if (this.index > -1 && this.index < this.buffer.length()) {
                val = this.buffer.charAt(this.index++);
                if (!this.avail()) {
                    this.buffer.setLength(0);
                    this.index = -1;
                }
            }
            return val;
        }

        public void append(char read) {
            this.buffer.append(read);
            if (this.index < 0) {
                this.index = 0;
            }
        }

        public void reset() {
            this.buffer.setLength(0);
            this.index = -1;
        }

        public void append(String value) {
            this.buffer.append(value);
            if (this.index < 0) {
                this.index = 0;
            }
        }

        public void append(Buf buf) {
            this.buffer.append((CharSequence)buf.buffer);
            if (this.index < 0) {
                this.index = 0;
            }
        }

        public String readAll() {
            String substring = this.buffer.substring(this.index);
            this.reset();
            return substring;
        }
    }
}

