/*
 * Decompiled with CFR 0.152.
 */
package com.dtolabs.rundeck.core.execution.dispatch;

import com.dtolabs.rundeck.core.common.INodeEntry;
import com.dtolabs.rundeck.core.execution.dispatch.DispatcherException;
import com.dtolabs.rundeck.core.execution.workflow.steps.node.NodeStepResult;
import com.dtolabs.rundeck.plugins.orchestrator.Orchestrator;
import java.util.Collections;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.Callable;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.TimeUnit;

public class OrchestratorNodeProcessor {
    private volatile boolean stop = false;
    private final int threadCount;
    private final boolean keepgoing;
    private final Orchestrator orchestrator;
    private final Map<INodeEntry, Callable<NodeStepResult>> executions;
    private final ExecutorService threadPool;
    private Set<INodeEntry> processedNodes;
    private BlockingQueue<Result> resultqueue;
    private BlockingQueue<Entry> taskqueue;

    public OrchestratorNodeProcessor(int threadCount, boolean keepgoing, Orchestrator orchestrator, Map<INodeEntry, Callable<NodeStepResult>> executions) {
        if (threadCount < 1) {
            throw new IllegalArgumentException("threadCount must be greater than 0: " + threadCount);
        }
        this.threadCount = threadCount;
        this.resultqueue = new LinkedBlockingQueue<Result>();
        this.taskqueue = new LinkedBlockingQueue<Entry>(threadCount);
        this.keepgoing = keepgoing;
        this.orchestrator = orchestrator;
        this.executions = executions;
        this.threadPool = Executors.newFixedThreadPool(this.threadCount);
        this.processedNodes = Collections.newSetFromMap(new ConcurrentHashMap());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean execute() throws ExecutionException {
        for (int i = 0; i < this.threadCount; ++i) {
            this.threadPool.submit(new OrchestratorRunnable());
        }
        boolean success = true;
        try {
            int completedNodes = 0;
            while (completedNodes < this.executions.size() && !this.stop) {
                try {
                    Entry callable = this.getCallable();
                    if (null != callable) {
                        this.taskqueue.put(callable);
                        continue;
                    }
                    if (completedNodes < this.processedNodes.size()) {
                        Result result = this.resultqueue.take();
                        if (!result.success) {
                            success = false;
                        }
                        if (result.node != null) {
                            this.orchestrator.returnNode(result.node, result.success, result.result);
                        }
                        ++completedNodes;
                        continue;
                    }
                    if (!this.orchestrator.isComplete()) {
                        try {
                            Thread.sleep(2000L);
                            continue;
                        }
                        catch (InterruptedException e) {
                            e.printStackTrace();
                        }
                    }
                    break;
                }
                catch (DispatcherException e) {
                    e.printStackTrace();
                }
            }
        }
        catch (InterruptedException x) {
        }
        finally {
            for (int x = this.threadCount; x > 0 && this.taskqueue.offer(new Entry(true)); --x) {
            }
            this.threadPool.shutdown();
        }
        try {
            this.threadPool.awaitTermination(60L, TimeUnit.SECONDS);
        }
        catch (InterruptedException e) {
            this.threadPool.shutdownNow();
        }
        return !this.stop && success;
    }

    public Entry getCallable() throws DispatcherException {
        INodeEntry node = this.orchestrator.nextNode();
        if (node == null) {
            return null;
        }
        if (!this.processedNodes.add(node)) {
            throw new DispatcherException("Can not process the same node twice " + node);
        }
        Callable<NodeStepResult> callable = this.executions.get(node);
        if (null == callable) {
            throw new DispatcherException("Can not process the a node that is not from the target list: " + node);
        }
        return new Entry(node, callable);
    }

    public static class Entry {
        private boolean finish;
        private final INodeEntry node;
        private final Callable<NodeStepResult> callable;

        public Entry(boolean finish) {
            this.finish = finish;
            this.node = null;
            this.callable = null;
        }

        public Entry(INodeEntry node, Callable<NodeStepResult> callable) {
            this.node = node;
            this.callable = callable;
            this.finish = false;
        }
    }

    public static class Result {
        private final INodeEntry node;
        private final boolean success;
        private final NodeStepResult result;

        public Result(INodeEntry node, boolean success, NodeStepResult result) {
            this.node = node;
            this.success = success;
            this.result = result;
        }
    }

    public class OrchestratorRunnable
    implements Callable<Boolean> {
        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Boolean call() throws Exception {
            String originalname = Thread.currentThread().getName();
            while (!OrchestratorNodeProcessor.this.stop) {
                NodeStepResult result;
                Entry task;
                boolean success;
                block7: {
                    block6: {
                        success = false;
                        task = null;
                        result = null;
                        Thread.currentThread().setName("OrchestratorNodeProcessor[take]");
                        task = (Entry)OrchestratorNodeProcessor.this.taskqueue.take();
                        if (task != null && !task.finish) break block6;
                        OrchestratorNodeProcessor.this.resultqueue.put(new Result(task != null ? task.node : null, success, result));
                        Thread.currentThread().setName(originalname);
                        break;
                    }
                    try {
                        Thread.currentThread().setName("OrchestratorNodeProcessor[running](node=" + task.node.getNodename() + ")");
                        result = (NodeStepResult)task.callable.call();
                        success = result.isSuccess();
                        if (success || OrchestratorNodeProcessor.this.keepgoing) break block7;
                        OrchestratorNodeProcessor.this.stop = true;
                    }
                    catch (Exception e) {
                        block8: {
                            try {
                                if (OrchestratorNodeProcessor.this.keepgoing) break block8;
                                OrchestratorNodeProcessor.this.stop = true;
                                throw e;
                            }
                            catch (Throwable throwable) {
                                OrchestratorNodeProcessor.this.resultqueue.put(new Result(task != null ? task.node : null, success, result));
                                Thread.currentThread().setName(originalname);
                                throw throwable;
                            }
                        }
                        OrchestratorNodeProcessor.this.resultqueue.put(new Result(task != null ? task.node : null, success, result));
                        Thread.currentThread().setName(originalname);
                        continue;
                    }
                    OrchestratorNodeProcessor.this.resultqueue.put(new Result(task != null ? task.node : null, success, result));
                    Thread.currentThread().setName(originalname);
                    break;
                }
                OrchestratorNodeProcessor.this.resultqueue.put(new Result(task != null ? task.node : null, success, result));
                Thread.currentThread().setName(originalname);
            }
            return true;
        }
    }
}

