/*
 * Decompiled with CFR 0.152.
 */
package com.dtolabs.rundeck.core.execution.workflow;

import com.dtolabs.rundeck.core.common.Framework;
import com.dtolabs.rundeck.core.dispatcher.DataContextUtils;
import com.dtolabs.rundeck.core.execution.ExecutionListener;
import com.dtolabs.rundeck.core.execution.StepExecutionItem;
import com.dtolabs.rundeck.core.execution.service.ExecutionServiceException;
import com.dtolabs.rundeck.core.execution.workflow.BaseWorkflowExecutor;
import com.dtolabs.rundeck.core.execution.workflow.ControlBehavior;
import com.dtolabs.rundeck.core.execution.workflow.EngineWorkflowStepOperation;
import com.dtolabs.rundeck.core.execution.workflow.EngineWorkflowStepOperationSuccess;
import com.dtolabs.rundeck.core.execution.workflow.IWorkflow;
import com.dtolabs.rundeck.core.execution.workflow.SequentialStrategyProfile;
import com.dtolabs.rundeck.core.execution.workflow.StepExecutionContext;
import com.dtolabs.rundeck.core.execution.workflow.WorkflowExecutionItem;
import com.dtolabs.rundeck.core.execution.workflow.WorkflowExecutionListener;
import com.dtolabs.rundeck.core.execution.workflow.WorkflowExecutionResult;
import com.dtolabs.rundeck.core.execution.workflow.WorkflowStatusResult;
import com.dtolabs.rundeck.core.execution.workflow.WorkflowStrategy;
import com.dtolabs.rundeck.core.execution.workflow.WorkflowStrategyProfile;
import com.dtolabs.rundeck.core.execution.workflow.steps.StepException;
import com.dtolabs.rundeck.core.execution.workflow.steps.StepExecutionResult;
import com.dtolabs.rundeck.core.execution.workflow.steps.StepExecutionResultImpl;
import com.dtolabs.rundeck.core.execution.workflow.steps.StepFailureReason;
import com.dtolabs.rundeck.core.rules.Condition;
import com.dtolabs.rundeck.core.rules.MutableStateObj;
import com.dtolabs.rundeck.core.rules.RuleEngine;
import com.dtolabs.rundeck.core.rules.Rules;
import com.dtolabs.rundeck.core.rules.StateLogger;
import com.dtolabs.rundeck.core.rules.StateObj;
import com.dtolabs.rundeck.core.rules.States;
import com.dtolabs.rundeck.core.rules.WorkflowSystem;
import com.dtolabs.rundeck.core.rules.WorkflowSystemBuilder;
import com.dtolabs.rundeck.core.rules.WorkflowSystemEvent;
import com.dtolabs.rundeck.core.rules.WorkflowSystemEventListener;
import com.dtolabs.rundeck.core.rules.Workflows;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.CancellationException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import org.apache.log4j.Logger;

public class EngineWorkflowExecutor
extends BaseWorkflowExecutor {
    static final Logger logger = Logger.getLogger(EngineWorkflowExecutor.class);
    public static final String STEP_FLOW_CONTROL_KEY = "step.#.flowcontrol";
    public static final String STEP_ANY_FLOW_CONTROL_HALT_KEY = "step.any.flowcontrol.halt";
    public static final String STEP_FLOW_CONTROL_STATUS_KEY = "step.#.flowstatus";
    public static final String WORKFLOW_STATE_KEY = "workflow.state";
    public static final String WORKFLOW_KEEPGOING_KEY = "workflow.keepgoing";
    public static final String WORKFLOW_STATE_STARTED = "started";
    public static final String STEP_BEFORE_KEY = "before.step.#";
    public static final String STEP_AFTER_KEY = "after.step.#";
    public static final String STEP_STATE_KEY = "step.#.state";
    public static final String STEP_ANY_STATE_SKIPPED_KEY = "step.any.state.skipped";
    public static final String STEP_ANY_STATE_SUCCESS_KEY = "step.any.state.success";
    public static final String STEP_ANY_STATE_FAILED_KEY = "step.any.state.failed";
    public static final String STEP_COMPLETED_KEY = "step.#.completed";
    public static final String VALUE_TRUE = Boolean.TRUE.toString();
    public static final String VALUE_FALSE = Boolean.FALSE.toString();
    public static final String STEP_STATE_RESULT_SUCCESS = "success";
    public static final String STEP_STATE_RESULT_FAILURE = "failure";
    public static final String STEP_STATE_RESULT_SKIPPED = "skipped";
    public static final String STEP_CONTROL_KEY = "step.#.start";
    public static final String STEP_CONTROL_SKIP_KEY = "step.#.skip";
    public static final String STEP_CONTROL_START = "start";
    public static final String STEP_DATA_RESULT_KEY_PREFIX = "step.#.result.";
    private WorkflowSystemBuilder workflowSystemBuilder = Workflows.builder();

    public EngineWorkflowExecutor(Framework framework) {
        super(framework);
    }

    public static String stepKey(String key, Object stepNum) {
        return key.replace("#", stepNum.toString());
    }

    public static void updateStateWithStepResultData(MutableStateObj state, Object identity, Map<String, Object> resultData, Map<String, Object> failureData) {
        HashMap<String, String> stringStringHashMap = new HashMap<String, String>();
        if (null != resultData) {
            for (String s : resultData.keySet()) {
                stringStringHashMap.put(EngineWorkflowExecutor.stepKey(STEP_DATA_RESULT_KEY_PREFIX + s, identity), resultData.get(s).toString());
            }
        }
        if (null != failureData) {
            for (String s : failureData.keySet()) {
                stringStringHashMap.put(EngineWorkflowExecutor.stepKey(STEP_DATA_RESULT_KEY_PREFIX + s, identity), failureData.get(s).toString());
            }
        }
        if (stringStringHashMap.size() > 0) {
            state.updateState(stringStringHashMap);
        }
    }

    public WorkflowSystemBuilder getWorkflowSystemBuilder() {
        return this.workflowSystemBuilder;
    }

    public void setWorkflowSystemBuilder(WorkflowSystemBuilder workflowSystemBuilder) {
        this.workflowSystemBuilder = workflowSystemBuilder;
    }

    @Override
    public WorkflowExecutionResult executeWorkflowImpl(StepExecutionContext executionContext, WorkflowExecutionItem item) {
        WorkflowStrategy strategyForWorkflow;
        executionContext.getExecutionListener().log(4, "Start EngineWorkflowExecutor");
        IWorkflow workflow = item.getWorkflow();
        List<StepExecutionItem> commands = workflow.getCommands();
        int stepCount = commands.size();
        HashMap<Integer, StepExecutionResult> stepExecutionResults = new HashMap<Integer, StepExecutionResult>();
        HashMap<Integer, StepExecutionResult> stepFailures = new HashMap<Integer, StepExecutionResult>();
        ArrayList<StepExecutionResult> stepResults = new ArrayList<StepExecutionResult>();
        WorkflowExecutionListener wlistener = this.getWorkflowListener(executionContext);
        String strategy = workflow.getStrategy();
        try {
            Object o1;
            Object o;
            Map<String, Object> pluginConfig = new HashMap<String, Object>();
            Map<String, Object> pluginConfig1 = workflow.getPluginConfig();
            if (pluginConfig1 != null && (o = pluginConfig1.get("WorkflowStrategy")) instanceof Map && (o1 = ((Map)o).get(strategy)) instanceof Map) {
                pluginConfig = (Map)o1;
            }
            strategyForWorkflow = this.framework.getWorkflowStrategyService().getStrategyForWorkflow(item, pluginConfig, executionContext.getFrameworkProject());
        }
        catch (ExecutionServiceException e) {
            executionContext.getExecutionListener().log(0, "Exception: " + e.getClass() + ": " + e.getMessage());
            return new BaseWorkflowExecutor.BaseWorkflowExecutionResult(stepResults, new HashMap<String, Collection<StepExecutionResult>>(), stepFailures, e, WorkflowResultFailed);
        }
        RuleEngine ruleEngine = Rules.createEngine();
        MutableStateObj mutable = States.mutable(DataContextUtils.flattenDataContext(executionContext.getDataContext()));
        mutable.updateState(WORKFLOW_KEEPGOING_KEY, Boolean.toString(workflow.isKeepgoing()));
        StateLogger state = new StateLogger(mutable, executionContext.getExecutionListener());
        int wfThreadcount = strategyForWorkflow.getThreadCount();
        ExecutorService executorService = wfThreadcount > 0 ? Executors.newFixedThreadPool(wfThreadcount) : Executors.newCachedThreadPool();
        HashSet<EngineWorkflowStepOperation> operations = new HashSet<EngineWorkflowStepOperation>();
        executionContext.getExecutionListener().log(4, "Building initial state and rules...");
        ruleEngine.addRule(Rules.conditionsRule(Rules.equalsCondition(STEP_ANY_FLOW_CONTROL_HALT_KEY, VALUE_TRUE), Workflows.getWorkflowEndState()));
        ruleEngine.addRule(Rules.conditionsRule(Rules.conditionSet(Rules.equalsCondition(STEP_ANY_STATE_FAILED_KEY, VALUE_TRUE), Rules.equalsCondition(WORKFLOW_KEEPGOING_KEY, VALUE_FALSE)), Workflows.getWorkflowEndState()));
        strategyForWorkflow.setup(ruleEngine, executionContext, workflow);
        WorkflowStrategyProfile profile = strategyForWorkflow.getProfile();
        if (profile == null) {
            profile = new SequentialStrategyProfile();
        }
        for (int i = 0; i < stepCount; ++i) {
            int stepNum = executionContext.getStepNumber() + i;
            StepExecutionItem cmd = commands.get(i);
            state.updateState(profile.getInitialStateForStep(stepNum, item, i == 0));
            Set<Condition> stepStartTriggerConditions = profile.getStartConditionsForStep(item, stepNum, i == 0);
            executionContext.getExecutionListener().log(4, String.format("start conditions for step [%d]: %s", stepNum, stepStartTriggerConditions));
            StateObj stepRunTriggerState = this.createTriggerControlStateForStep(stepNum);
            ruleEngine.addRule(Rules.conditionsRule(stepStartTriggerConditions, stepRunTriggerState));
            Set<Condition> stepSkipTriggerConditions = profile.getSkipConditionsForStep(item, stepNum, i == 0);
            StateObj stepSkipTriggerState = null;
            if (null != stepSkipTriggerConditions && stepSkipTriggerConditions.size() > 0) {
                stepSkipTriggerState = this.createSkipTriggerStateForStep(stepNum);
                ruleEngine.addRule(Rules.conditionsRule(Rules.and(Rules.and(stepStartTriggerConditions), Rules.and((Iterable<Condition>)stepSkipTriggerConditions)), stepSkipTriggerState));
                executionContext.getExecutionListener().log(4, String.format("skip conditions for step [%d]: %s", stepNum, stepSkipTriggerConditions));
            }
            operations.add(new EngineWorkflowStepOperation(stepNum, cmd.getLabel(), this.callable(cmd, executionContext, stepNum, wlistener, workflow.isKeepgoing()), stepRunTriggerState, stepSkipTriggerState, stepStartTriggerConditions, stepSkipTriggerConditions));
        }
        executionContext.getExecutionListener().log(4, "Create rule engine with rules: " + ruleEngine);
        executionContext.getExecutionListener().log(4, "Create workflow engine with state: " + state);
        WorkflowSystem workflowEngine = this.getWorkflowSystemBuilder().ruleEngine(ruleEngine).executor(executorService).state(state).listener(this.createListener(executionContext.getExecutionListener())).build();
        Set operationResults = workflowEngine.processOperations(operations);
        String statusString = null;
        ControlBehavior controlBehavior = null;
        boolean workflowSuccess = !workflowEngine.isInterrupted();
        for (WorkflowSystem.OperationResult operationResult : operationResults) {
            EngineWorkflowStepOperationSuccess success = (EngineWorkflowStepOperationSuccess)operationResult.getSuccess();
            EngineWorkflowStepOperation operation = (EngineWorkflowStepOperation)operationResult.getOperation();
            if (success != null) {
                stepExecutionResults.put(success.stepNum, success.result);
                if (!success.result.isSuccess()) {
                    stepFailures.put(success.stepNum, success.result);
                    workflowSuccess = false;
                }
                stepResults.add(success.result);
                if (success.controlBehavior == null || success.controlBehavior == ControlBehavior.Continue) continue;
                controlBehavior = success.controlBehavior;
                statusString = success.statusString;
                continue;
            }
            workflowSuccess = false;
            Throwable failure = operationResult.getFailure();
            StepFailureReason reason = StepFailureReason.Unknown;
            String message = String.format("Exception while executing step [%d]: \t[%s]", operation.stepNum, failure.toString());
            if (failure instanceof CancellationException) {
                reason = StepFailureReason.Interrupted;
                message = String.format("Cancellation while running step [%d]", operation.stepNum);
            }
            executionContext.getExecutionListener().log(0, message);
            stepFailures.put(operation.stepNum, StepExecutionResultImpl.wrapStepException(failure instanceof StepException ? (StepException)failure : new StepException(message, failure, reason)));
        }
        for (EngineWorkflowStepOperation operation : operations) {
            if (operation.isDidRun()) continue;
            executionContext.getExecutionListener().log(1, String.format("Step [%d] did not run. start conditions: %s, skip conditions: %s", operation.stepNum, operation.startTriggerConditions, operation.skipTriggerConditions));
        }
        WorkflowStatusResult workflowResult = EngineWorkflowExecutor.workflowResult(workflowSuccess, statusString, null != controlBehavior ? controlBehavior : ControlBehavior.Continue);
        Map<String, Collection<StepExecutionResult>> nodeFailures = this.convertFailures(stepFailures);
        return new BaseWorkflowExecutor.BaseWorkflowExecutionResult(stepResults, nodeFailures, stepFailures, null, workflowResult);
    }

    private WorkflowSystemEventListener createListener(final ExecutionListener executionListener) {
        return new WorkflowSystemEventListener(){

            @Override
            public void onEvent(WorkflowSystemEvent event) {
                executionListener.log(4, (Object)((Object)event.getEventType()) + ": " + event.getMessage());
            }
        };
    }

    private StateObj createTriggerControlStateForStep(int stepNum) {
        return States.state(EngineWorkflowExecutor.stepKey(STEP_CONTROL_KEY, stepNum), VALUE_TRUE);
    }

    private StateObj createSkipTriggerStateForStep(int stepNum) {
        return States.state(EngineWorkflowExecutor.stepKey(STEP_CONTROL_SKIP_KEY, stepNum), VALUE_TRUE);
    }

    Callable<BaseWorkflowExecutor.StepResultCapture> callable(final StepExecutionItem cmd, final StepExecutionContext executionContext, final int i, final WorkflowExecutionListener wlistener, final boolean keepgoing) {
        return new Callable<BaseWorkflowExecutor.StepResultCapture>(){

            @Override
            public BaseWorkflowExecutor.StepResultCapture call() {
                HashMap<Integer, StepExecutionResult> stepFailedMap = new HashMap<Integer, StepExecutionResult>();
                ArrayList<StepExecutionResult> resultList = new ArrayList<StepExecutionResult>();
                try {
                    BaseWorkflowExecutor.StepResultCapture stepResultCapture = EngineWorkflowExecutor.this.executeWorkflowStep(executionContext, stepFailedMap, resultList, keepgoing, wlistener, i, cmd);
                    return stepResultCapture;
                }
                catch (Throwable e) {
                    String message = String.format("Exception while executing step [%d]: [%s]", i, e.toString());
                    executionContext.getExecutionListener().log(0, message);
                    throw new RuntimeException(e);
                }
            }
        };
    }

    public static abstract class BaseProfile
    implements WorkflowStrategyProfile {
        @Override
        public StateObj getInitialStateForStep(int stepNum, WorkflowExecutionItem item, boolean isFirstStep) {
            MutableStateObj state = States.mutable(EngineWorkflowExecutor.stepKey(EngineWorkflowExecutor.STEP_BEFORE_KEY, stepNum), VALUE_TRUE);
            state.updateState(EngineWorkflowExecutor.stepKey(EngineWorkflowExecutor.STEP_AFTER_KEY, stepNum), VALUE_FALSE);
            return state;
        }

        @Override
        public Set<Condition> getSkipConditionsForStep(WorkflowExecutionItem item, int stepNum, boolean isFirstStep) {
            return null;
        }
    }
}

