/*
 * Decompiled with CFR 0.152.
 */
package com.dtolabs.rundeck.core.execution.workflow;

import com.dtolabs.rundeck.core.common.Framework;
import com.dtolabs.rundeck.core.execution.StepExecutionItem;
import com.dtolabs.rundeck.core.execution.workflow.BaseWorkflowExecutor;
import com.dtolabs.rundeck.core.execution.workflow.IWorkflow;
import com.dtolabs.rundeck.core.execution.workflow.StepExecutionContext;
import com.dtolabs.rundeck.core.execution.workflow.WorkflowExecutionItem;
import com.dtolabs.rundeck.core.execution.workflow.WorkflowExecutionResult;
import com.dtolabs.rundeck.core.execution.workflow.WorkflowStatusResult;
import com.dtolabs.rundeck.core.execution.workflow.steps.StepExecutionResult;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class StepFirstWorkflowExecutor
extends BaseWorkflowExecutor {
    public StepFirstWorkflowExecutor(Framework framework) {
        super(framework);
    }

    @Override
    public WorkflowExecutionResult executeWorkflowImpl(StepExecutionContext executionContext, WorkflowExecutionItem item) {
        WorkflowStatusResult workflowResult = WorkflowResultFailed;
        RuntimeException exception = null;
        IWorkflow workflow = item.getWorkflow();
        HashMap<Integer, StepExecutionResult> stepFailures = new HashMap<Integer, StepExecutionResult>();
        ArrayList<StepExecutionResult> stepResults = new ArrayList<StepExecutionResult>();
        try {
            executionContext.getExecutionListener().log(4, "NodeSet: " + executionContext.getNodeSelector());
            executionContext.getExecutionListener().log(4, "Workflow: " + workflow);
            Map<String, Map<String, String>> printableContext = this.createPrintableDataContext(executionContext.getDataContext());
            executionContext.getExecutionListener().log(4, String.format("%s %s", "data context: ", printableContext));
            List<StepExecutionItem> iWorkflowCmdItems = workflow.getCommands();
            if (iWorkflowCmdItems.size() < 1) {
                executionContext.getExecutionListener().log(1, "Workflow has 0 items");
            }
            workflowResult = this.executeWorkflowItemsForNodeSet(executionContext, stepFailures, stepResults, iWorkflowCmdItems, workflow.isKeepgoing());
        }
        catch (RuntimeException e) {
            exception = e;
            e.printStackTrace();
            executionContext.getExecutionListener().log(0, "Exception: " + e.getClass() + ": " + e.getMessage());
        }
        RuntimeException orig = exception;
        Map<String, Collection<StepExecutionResult>> nodeFailures = this.convertFailures(stepFailures);
        return new BaseWorkflowExecutor.BaseWorkflowExecutionResult(stepResults, nodeFailures, stepFailures, orig, workflowResult);
    }

    static boolean isInnerLoop(WorkflowExecutionItem item) {
        return item.getWorkflow() instanceof stepFirstWrapper;
    }

    static class stepFirstWrapper
    implements IWorkflow {
        private IWorkflow workflow;

        stepFirstWrapper(IWorkflow workflow) {
            this.workflow = workflow;
        }

        @Override
        public List<StepExecutionItem> getCommands() {
            return this.workflow.getCommands();
        }

        @Override
        public int getThreadcount() {
            return this.workflow.getThreadcount();
        }

        @Override
        public boolean isKeepgoing() {
            return this.workflow.isKeepgoing();
        }

        @Override
        public String getStrategy() {
            return "step-first";
        }

        @Override
        public Map<String, Object> getPluginConfig() {
            return this.workflow.getPluginConfig();
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof stepFirstWrapper)) {
                return false;
            }
            stepFirstWrapper that = (stepFirstWrapper)o;
            return !(this.workflow != null ? !this.workflow.equals(that.workflow) : that.workflow != null);
        }

        public int hashCode() {
            return this.workflow != null ? this.workflow.hashCode() : 0;
        }
    }
}

