/*
 * Decompiled with CFR 0.152.
 */
package com.dtolabs.rundeck.core.execution.workflow;

import com.dtolabs.rundeck.core.common.Framework;
import com.dtolabs.rundeck.core.common.IRundeckProjectConfig;
import com.dtolabs.rundeck.core.common.ProviderService;
import com.dtolabs.rundeck.core.execution.service.ExecutionServiceException;
import com.dtolabs.rundeck.core.execution.service.ProviderCreationException;
import com.dtolabs.rundeck.core.execution.workflow.NodeFirstWorkflowStrategy;
import com.dtolabs.rundeck.core.execution.workflow.ParallelWorkflowStrategy;
import com.dtolabs.rundeck.core.execution.workflow.SequentialWorkflowStrategy;
import com.dtolabs.rundeck.core.execution.workflow.WorkflowExecutionItem;
import com.dtolabs.rundeck.core.execution.workflow.WorkflowStrategy;
import com.dtolabs.rundeck.core.plugins.BaseProviderRegistryService;
import com.dtolabs.rundeck.core.plugins.ChainedProviderService;
import com.dtolabs.rundeck.core.plugins.PluggableProviderService;
import com.dtolabs.rundeck.core.plugins.PluginException;
import com.dtolabs.rundeck.core.plugins.ProviderIdent;
import com.dtolabs.rundeck.core.plugins.ScriptPluginProvider;
import com.dtolabs.rundeck.core.plugins.ServiceFactory;
import com.dtolabs.rundeck.core.plugins.configuration.DescribableService;
import com.dtolabs.rundeck.core.plugins.configuration.DescribableServiceUtil;
import com.dtolabs.rundeck.core.plugins.configuration.Description;
import com.dtolabs.rundeck.core.plugins.configuration.PluginAdapterUtility;
import com.dtolabs.rundeck.core.plugins.configuration.PropertyResolver;
import com.dtolabs.rundeck.core.plugins.configuration.PropertyResolverFactory;
import com.dtolabs.rundeck.core.plugins.configuration.PropertyScope;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class WorkflowStrategyService
extends ChainedProviderService<WorkflowStrategy>
implements DescribableService,
PluggableProviderService<WorkflowStrategy> {
    private static final String SERVICE_NAME = "WorkflowStrategy";
    private final Framework framework;
    private List<ProviderService<WorkflowStrategy>> serviceList;
    private final PluggableProviderService<WorkflowStrategy> pluginService;
    private final Map<String, String> builtinProviderSynonyms = new HashMap<String, String>();
    private final BaseProviderRegistryService<WorkflowStrategy> builtinService;

    @Override
    public String getName() {
        return SERVICE_NAME;
    }

    private WorkflowStrategyService(Framework framework) {
        this.framework = framework;
        this.serviceList = new ArrayList<ProviderService<WorkflowStrategy>>();
        HashMap<String, Class<? extends WorkflowStrategy>> builtinProviders = new HashMap<String, Class<? extends WorkflowStrategy>>(){
            {
                this.put(NodeFirstWorkflowStrategy.PROVIDER_NAME, NodeFirstWorkflowStrategy.class);
                this.put(SequentialWorkflowStrategy.PROVIDER_NAME, SequentialWorkflowStrategy.class);
                this.put(ParallelWorkflowStrategy.PROVIDER_NAME, ParallelWorkflowStrategy.class);
            }
        };
        this.builtinProviderSynonyms.put("step-first", SequentialWorkflowStrategy.PROVIDER_NAME);
        this.builtinService = ServiceFactory.builtinService(framework, SERVICE_NAME, builtinProviders);
        this.pluginService = ServiceFactory.pluginService(SERVICE_NAME, framework, WorkflowStrategy.class);
        this.serviceList.add(this.builtinService);
        this.serviceList.add(this.pluginService);
    }

    @Override
    protected List<ProviderService<WorkflowStrategy>> getServiceList() {
        return this.serviceList;
    }

    public static WorkflowStrategyService getInstanceForFramework(Framework framework) {
        if (null == framework.getService(SERVICE_NAME)) {
            WorkflowStrategyService service = new WorkflowStrategyService(framework);
            framework.setService(SERVICE_NAME, service);
            return service;
        }
        return (WorkflowStrategyService)framework.getService(SERVICE_NAME);
    }

    public WorkflowStrategy getStrategyForWorkflow(WorkflowExecutionItem workflow, Map<String, Object> config, String projectName) throws ExecutionServiceException {
        String provider = workflow.getWorkflow().getStrategy();
        String s = this.builtinProviderSynonyms.get(provider);
        if (null != s) {
            provider = s;
        }
        WorkflowStrategy workflowStrategy = (WorkflowStrategy)this.providerOfType(provider);
        if (null != config) {
            IRundeckProjectConfig iRundeckProjectConfig = this.framework.getFrameworkProjectMgr().loadProjectConfig(projectName);
            PropertyResolver resolver = PropertyResolverFactory.createResolver(config.size() > 0 ? PropertyResolverFactory.instanceRetriever(config) : null, PropertyResolverFactory.instanceRetriever(iRundeckProjectConfig.getProjectProperties()), this.framework.getPropertyRetriever());
            Description description = DescribableServiceUtil.descriptionForProvider(true, workflowStrategy);
            if (description != null) {
                config = PluginAdapterUtility.configureProperties(resolver, description, workflowStrategy, PropertyScope.Instance);
            }
        }
        return workflowStrategy;
    }

    public WorkflowStrategy getStrategyForWorkflow(WorkflowExecutionItem workflow, PropertyResolver resolver) throws ExecutionServiceException {
        Description description;
        String provider = workflow.getWorkflow().getStrategy();
        String s = this.builtinProviderSynonyms.get(provider);
        if (null != s) {
            provider = s;
        }
        WorkflowStrategy workflowStrategy = (WorkflowStrategy)this.providerOfType(provider);
        if (null != resolver && (description = DescribableServiceUtil.descriptionForProvider(true, workflowStrategy)) != null) {
            Map<String, Object> map = PluginAdapterUtility.configureProperties(resolver, description, workflowStrategy, PropertyScope.Instance);
        }
        return workflowStrategy;
    }

    @Override
    public List<Description> listDescriptions() {
        return DescribableServiceUtil.listDescriptions(this);
    }

    @Override
    public List<ProviderIdent> listDescribableProviders() {
        return DescribableServiceUtil.listDescribableProviders(this);
    }

    @Override
    public boolean isValidProviderClass(Class clazz) {
        return this.pluginService.isValidProviderClass(clazz);
    }

    @Override
    public <X extends WorkflowStrategy> WorkflowStrategy createProviderInstance(Class<X> clazz, String name) throws PluginException, ProviderCreationException {
        return (WorkflowStrategy)this.pluginService.createProviderInstance(clazz, name);
    }

    @Override
    public boolean isScriptPluggable() {
        return this.pluginService.isScriptPluggable();
    }

    @Override
    public WorkflowStrategy createScriptProviderInstance(ScriptPluginProvider provider) throws PluginException {
        return (WorkflowStrategy)this.pluginService.createScriptProviderInstance(provider);
    }

    public void registerClass(String name, Class<? extends WorkflowStrategy> clazz) {
        this.builtinService.registerClass(name, clazz);
    }

    public void registerInstance(String name, WorkflowStrategy object) {
        this.builtinService.registerInstance(name, object);
    }
}

