/*
 * Decompiled with CFR 0.152.
 */
package com.dtolabs.rundeck.core.execution.workflow.state;

import com.dtolabs.rundeck.core.execution.workflow.state.ExecutionState;
import com.dtolabs.rundeck.core.execution.workflow.state.StepAspect;
import com.dtolabs.rundeck.core.execution.workflow.state.StepContextId;
import com.dtolabs.rundeck.core.execution.workflow.state.StepIdentifier;
import com.dtolabs.rundeck.core.execution.workflow.state.StepIdentifierImpl;
import com.dtolabs.rundeck.core.execution.workflow.state.StepState;
import com.dtolabs.rundeck.core.execution.workflow.state.StepStateChange;
import com.dtolabs.rundeck.core.execution.workflow.state.StepStateChangeImpl;
import com.dtolabs.rundeck.core.execution.workflow.state.StepStateImpl;
import com.dtolabs.rundeck.core.execution.workflow.state.WorkflowNodeState;
import com.dtolabs.rundeck.core.execution.workflow.state.WorkflowNodeStateImpl;
import com.dtolabs.rundeck.core.execution.workflow.state.WorkflowState;
import com.dtolabs.rundeck.core.execution.workflow.state.WorkflowStateImpl;
import com.dtolabs.rundeck.core.execution.workflow.state.WorkflowStepState;
import com.dtolabs.rundeck.core.execution.workflow.state.WorkflowStepStateImpl;
import com.dtolabs.rundeck.core.utils.PairImpl;
import com.dtolabs.rundeck.core.utils.TextUtils;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeSet;

public class StateUtils {
    public static StepState stepState(ExecutionState state) {
        return StateUtils.stepState(state, null, null, null, null, null);
    }

    public static StepState stepState(ExecutionState state, Map metadata) {
        return StateUtils.stepState(state, metadata, null, null, null, null);
    }

    public static StepState stepState(ExecutionState state, Map metadata, String errorMessage) {
        return StateUtils.stepState(state, metadata, errorMessage, null, null, null);
    }

    public static StepState stepState(ExecutionState state, Map metadata, String errorMessage, Date startTime, Date updateTime, Date endTime) {
        StepStateImpl stepState = new StepStateImpl();
        stepState.setExecutionState(state);
        stepState.setMetadata(metadata);
        stepState.setErrorMessage(errorMessage);
        stepState.setStartTime(startTime);
        stepState.setUpdateTime(updateTime);
        stepState.setEndTime(endTime);
        return stepState;
    }

    public static StepStateChange stepStateChange(StepState state) {
        StepStateChangeImpl stepStateChange = new StepStateChangeImpl();
        stepStateChange.setStepState(state);
        stepStateChange.setNodeState(false);
        return stepStateChange;
    }

    public static StepStateChange stepStateChange(StepState state, String nodeName) {
        StepStateChangeImpl stepStateChange = new StepStateChangeImpl();
        stepStateChange.setStepState(state);
        stepStateChange.setNodeState(null != nodeName);
        stepStateChange.setNodeName(nodeName);
        return stepStateChange;
    }

    public static String parameterString(StepContextId contextId) {
        return null != contextId.getParams() ? "@" + StateUtils.parameterString(contextId.getParams()) : "";
    }

    public static String parameterString(Map<String, String> params) {
        TreeSet<String> stringStringTreeSet = new TreeSet<String>(params.keySet());
        ArrayList<String> result = new ArrayList<String>();
        for (String s : stringStringTreeSet) {
            result.add(TextUtils.joinEscaped(new String[]{s, params.get(s)}, '=', '\\', new char[]{','}));
        }
        return TextUtils.join(result.toArray(new String[result.size()]), ',');
    }

    public static String stepIdentifierToString(StepIdentifier ident) {
        ArrayList<String> parts = new ArrayList<String>();
        for (StepContextId stepContextId : ident.getContext()) {
            parts.add(StateUtils.stepContextIdToString(stepContextId));
        }
        return TextUtils.joinEscaped(parts.toArray(new String[parts.size()]), '/', '\\', null);
    }

    public static StepIdentifier stepIdentifierFromString(String input) {
        if (null == input) {
            return null;
        }
        ArrayList<StepContextId> ids = new ArrayList<StepContextId>();
        for (String s : TextUtils.splitUnescape(input, '/', '\\', new char[]{'/'})) {
            ids.add(StateUtils.stepContextIdFromString(s));
        }
        return StateUtils.stepIdentifier(ids);
    }

    public static String stepContextIdToString(StepContextId context) {
        return context.getStep() + (context.getAspect().isMain() ? "" : "e") + StateUtils.parameterString(context);
    }

    public static StepContextId stepContextIdFromString(String s) {
        String t;
        if (!s.matches("^\\d+e?(@.+)?$")) {
            throw new IllegalArgumentException("not a valid step context id: " + s);
        }
        String[] split = s.split("@", 2);
        boolean errHandler = false;
        int stepnum = -1;
        Map<String, String> params = null;
        if (split.length > 0) {
            t = split[0];
            if (t.endsWith("e")) {
                errHandler = true;
                t = t.substring(0, t.length() - 1);
            }
            stepnum = Integer.parseInt(t);
        }
        if (stepnum <= 0) {
            throw new IllegalArgumentException("not a valid step context id: " + s);
        }
        if (split.length > 1) {
            t = split[1];
            params = StateUtils.parseParameterString(t);
        }
        return StateUtils.stepContextId(stepnum, errHandler, params);
    }

    public static Map<String, String> parseParameterString(String t) {
        HashMap<String, String> params = new HashMap<String, String>();
        String key = null;
        for (String s1 : TextUtils.splitUnescape(t, new char[]{',', '='}, '\\', null)) {
            if (null == key) {
                key = s1;
                continue;
            }
            params.put(key, s1);
            key = null;
        }
        if (key != null) {
            throw new IllegalArgumentException("Not a valid parameter string: " + t);
        }
        return params;
    }

    public static boolean isMatchedIdentifier(String parent, String child, boolean substep) {
        return StateUtils.isMatchedIdentifier(StateUtils.stepIdentifierFromString(parent), StateUtils.stepIdentifierFromString(child), substep);
    }

    public static boolean isMatchedIdentifier(StepIdentifier parent, StepIdentifier child, boolean substep) {
        if (parent.getContext().size() > child.getContext().size()) {
            return false;
        }
        if (!substep && parent.getContext().size() != child.getContext().size()) {
            return false;
        }
        for (int i = 0; i < parent.getContext().size(); ++i) {
            StepContextId specificContextId;
            StepContextId generalContextId = parent.getContext().get(i);
            if (StateUtils.isContainedStep(generalContextId, specificContextId = child.getContext().get(i))) continue;
            return false;
        }
        return true;
    }

    public static boolean isContainedStep(StepContextId general, StepContextId specific) {
        if (general.getStep() != specific.getStep()) {
            return false;
        }
        if (general.getAspect() != StepAspect.Main && specific.getAspect() == StepAspect.Main) {
            return false;
        }
        if (null != general.getParams() && null == specific.getParams()) {
            return false;
        }
        return null == general.getParams() || null == specific.getParams() || general.getParams().equals(specific.getParams());
    }

    public static StepContextId stepContextId(int step, boolean errorhandler) {
        return new CtxItem(step, errorhandler);
    }

    public static StepContextId stepContextId(int step, boolean errorhandler, Map<String, String> params) {
        return new CtxItem(step, errorhandler, params);
    }

    public static StepIdentifier stepIdentifier(List<StepContextId> context) {
        return new StepIdentifierImpl(context);
    }

    public static StepIdentifier stepIdentifier(StepContextId ... context) {
        return new StepIdentifierImpl(Arrays.asList(context));
    }

    public static StepIdentifier stepIdentifier(int id) {
        return StateUtils.stepIdentifier(StateUtils.stepContextId(id, false));
    }

    public static StepIdentifier stepIdentifier(int ... ids) {
        return StateUtils.stepIdentifier(StateUtils.asStepContextIds(ids));
    }

    public static StepContextId last(StepIdentifier stepIdentifier) {
        return stepIdentifier.getContext().get(stepIdentifier.getContext().size() - 1);
    }

    public static StepContextId first(StepIdentifier stepIdentifier) {
        return stepIdentifier.getContext().get(0);
    }

    private static List<StepContextId> asStepContextIds(int[] ids) {
        ArrayList<StepContextId> stepContextIds = new ArrayList<StepContextId>(ids.length);
        for (int i = 0; i < ids.length; ++i) {
            int id = ids[i];
            stepContextIds.add(StateUtils.stepContextId(id, false));
        }
        return stepContextIds;
    }

    public static StepIdentifier stepIdentifierTail(StepIdentifier identifier) {
        return new StepIdentifierImpl(identifier.getContext().subList(1, identifier.getContext().size()));
    }

    public static StepIdentifier stepIdentifierAppend(StepIdentifier identifier, StepIdentifier identifier2) {
        ArrayList<StepContextId> context = new ArrayList<StepContextId>();
        if (null != identifier && null != identifier.getContext() && identifier.getContext().size() > 0) {
            context.addAll(identifier.getContext());
        }
        if (null != identifier2 && null != identifier2.getContext() && identifier2.getContext().size() > 0) {
            context.addAll(identifier2.getContext());
        }
        return new StepIdentifierImpl(context);
    }

    public static WorkflowState workflowState(List<String> nodeSet, List<String> allNodes, long stepCount, ExecutionState executionState, Date updateTime, Date startTime, Date endTime, String serverNode, List<WorkflowStepState> stepStates, boolean setupNodeStates) {
        WorkflowStateImpl workflowState = new WorkflowStateImpl(nodeSet, allNodes, stepCount, executionState, updateTime, startTime, endTime, serverNode, stepStates, null);
        if (setupNodeStates) {
            StateUtils.setupNodeStates(workflowState);
        }
        return workflowState;
    }

    public static WorkflowState workflowState(List<String> nodeSet, List<String> allNodes, long stepCount, ExecutionState executionState, Date timestamp, Date startTime, Date endTime, String serverNode, List<WorkflowStepState> stepStates, Map<String, WorkflowNodeState> nodeStates) {
        return new WorkflowStateImpl(nodeSet, allNodes, stepCount, executionState, timestamp, startTime, endTime, serverNode, stepStates, nodeStates);
    }

    public static void setupNodeStates(WorkflowStateImpl current) {
        StateUtils.setupNodeStates(current, current, null);
    }

    private static void setupNodeStates(WorkflowState current, WorkflowStateImpl parent, StepIdentifier ident) {
        HashMap<String, WorkflowNodeState> nodeStates = new HashMap<String, WorkflowNodeState>();
        if (null != parent.getNodeStates()) {
            nodeStates.putAll(parent.getNodeStates());
        }
        ArrayList<String> allNodes = new ArrayList<String>();
        if (null != parent.getNodeSet()) {
            allNodes.addAll(parent.getNodeSet());
        }
        parent.setNodeStates(nodeStates);
        parent.setAllNodes(allNodes);
        for (WorkflowStepState workflowStepState : current.getStepStates()) {
            StepIdentifier thisident = StateUtils.stepIdentifierAppend(ident, workflowStepState.getStepIdentifier());
            if (workflowStepState.isNodeStep()) {
                for (String nodeName : current.getNodeSet()) {
                    HashMap<StepIdentifier, ? extends StepState> stepStatesForNode = new HashMap<StepIdentifier, StepState>();
                    StepState state = workflowStepState.getNodeStateMap().get(nodeName);
                    stepStatesForNode.put(thisident, state);
                    WorkflowNodeState orig = nodeStates.get(nodeName);
                    if (null != orig && null != orig.getStepStateMap()) {
                        stepStatesForNode.putAll(orig.getStepStateMap());
                    }
                    if (!allNodes.contains(nodeName)) {
                        allNodes.add(nodeName);
                    }
                    WorkflowNodeState workflowNodeState = StateUtils.workflowNodeState(nodeName, state, thisident, stepStatesForNode);
                    nodeStates.put(nodeName, workflowNodeState);
                }
                continue;
            }
            if (!workflowStepState.hasSubWorkflow()) continue;
            StateUtils.setupNodeStates(workflowStepState.getSubWorkflowState(), parent, thisident);
        }
    }

    public static WorkflowStepState workflowStepState(StepState stepState, Map<String, StepState> nodeStateMap, StepIdentifier stepIdentifier, WorkflowState subWorkflowState, List<String> nodeStepTargets, boolean nodeStep) {
        WorkflowStepStateImpl workflowStepState = new WorkflowStepStateImpl();
        workflowStepState.setStepState(stepState);
        workflowStepState.setNodeStateMap(nodeStateMap);
        workflowStepState.setStepIdentifier(stepIdentifier);
        workflowStepState.setSubWorkflow(null != subWorkflowState);
        workflowStepState.setSubWorkflowState(subWorkflowState);
        if (null != nodeStepTargets) {
            workflowStepState.setNodeStepTargets(nodeStepTargets);
        }
        workflowStepState.setNodeStep(nodeStep);
        return workflowStepState;
    }

    public static WorkflowNodeState workflowNodeState(String nodeName, StepState nodeState, StepIdentifier lastIdentifier, Map<StepIdentifier, ? extends StepState> stepStates) {
        return StateUtils.workflowNodeStateImpl(nodeName, nodeState, lastIdentifier, stepStates);
    }

    private static WorkflowNodeStateImpl workflowNodeStateImpl(String nodeName, StepState nodeState, StepIdentifier lastIdentifier, Map<StepIdentifier, ? extends StepState> stepStates) {
        WorkflowNodeStateImpl workflowNodeState = new WorkflowNodeStateImpl();
        workflowNodeState.setNodeName(nodeName);
        workflowNodeState.setNodeState(nodeState);
        workflowNodeState.setLastIdentifier(lastIdentifier);
        workflowNodeState.setStepStateMap(stepStates);
        return workflowNodeState;
    }

    public static class CtxItem
    extends PairImpl<Integer, Boolean>
    implements StepContextId {
        Map<String, String> params = null;

        public CtxItem(Integer first, Boolean second, Map<String, String> params) {
            this(first, second);
            this.params = params;
        }

        public CtxItem(Integer first, Boolean second) {
            super(first, second);
        }

        @Override
        public int getStep() {
            return (Integer)this.getFirst();
        }

        @Override
        public Map<String, String> getParams() {
            return this.params;
        }

        @Override
        public StepAspect getAspect() {
            return (Boolean)this.getSecond() != false ? StepAspect.ErrorHandler : StepAspect.Main;
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            CtxItem that = (CtxItem)o;
            if (this.getStep() != that.getStep()) {
                return false;
            }
            if (!this.getAspect().equals((Object)that.getAspect())) {
                return false;
            }
            return !(this.params != null ? !this.params.equals(that.params) : that.params != null);
        }

        @Override
        public int hashCode() {
            int result = super.hashCode();
            result = 31 * result + this.getStep();
            result = 31 * result + this.getAspect().hashCode();
            result = 31 * result + (this.params != null ? this.params.hashCode() : 0);
            return result;
        }

        @Override
        public int compareTo(StepContextId o) {
            int c;
            int thatstep;
            int step = this.getStep();
            int n = step < (thatstep = o.getStep()) ? -1 : (c = step > thatstep ? 1 : 0);
            if (c != 0) {
                return c;
            }
            return this.getAspect().compareTo(o.getAspect());
        }

        public String toString() {
            return this.getStep() + ((Boolean)this.getSecond() != false ? "e" : "") + StateUtils.parameterString(this);
        }
    }
}

