/*
 * Decompiled with CFR 0.152.
 */
package com.dtolabs.rundeck.core.plugins;

import com.dtolabs.rundeck.core.common.Framework;
import com.dtolabs.rundeck.core.common.INodeEntry;
import com.dtolabs.rundeck.core.dispatcher.DataContextUtils;
import com.dtolabs.rundeck.core.execution.ExecutionContext;
import com.dtolabs.rundeck.core.plugins.ScriptPluginProvider;
import com.dtolabs.rundeck.core.plugins.configuration.ConfigurationException;
import com.dtolabs.rundeck.core.plugins.configuration.Describable;
import com.dtolabs.rundeck.core.plugins.configuration.Description;
import com.dtolabs.rundeck.core.plugins.configuration.PluginAdapterUtility;
import com.dtolabs.rundeck.core.plugins.configuration.Property;
import com.dtolabs.rundeck.core.plugins.configuration.PropertyResolver;
import com.dtolabs.rundeck.core.plugins.configuration.PropertyResolverFactory;
import com.dtolabs.rundeck.core.plugins.configuration.PropertyScope;
import com.dtolabs.rundeck.core.plugins.configuration.StringRenderingConstants;
import com.dtolabs.rundeck.core.storage.ResourceMeta;
import com.dtolabs.rundeck.core.storage.StorageTree;
import com.dtolabs.rundeck.plugins.util.DescriptionBuilder;
import com.dtolabs.rundeck.plugins.util.PropertyBuilder;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.rundeck.storage.api.PathUtil;
import org.rundeck.storage.api.Resource;
import org.rundeck.storage.api.StorageException;

public abstract class AbstractDescribableScriptPlugin
implements Describable {
    public static final String TITLE_PROP = "title";
    public static final String DESCRIPTION_PROP = "description";
    public static final String CONFIG_PROP_PREFIX = "config";
    public static final String CONFIG_TITLE = "title";
    public static final String CONFIG_DESCRIPTION = "description";
    public static final String CONFIG_NAME = "name";
    public static final String CONFIG_TYPE = "type";
    public static final String CONFIG_REQUIRED = "required";
    public static final String CONFIG_DEFAULT = "default";
    public static final String CONFIG_VALUES = "values";
    public static final String CONFIG_LABELS = "labels";
    public static final String CONFIG_SCOPE = "scope";
    public static final String CONFIG_RENDERING_OPTIONS = "renderingOptions";
    public static final String SETTING_MERGE_ENVIRONMENT = "mergeEnvironment";
    private final ScriptPluginProvider provider;
    private final Framework framework;
    Description description;

    public AbstractDescribableScriptPlugin(ScriptPluginProvider provider, Framework framework) {
        this.provider = provider;
        this.framework = framework;
    }

    public Map<String, String> createPluginDataContext() {
        HashMap<String, String> pluginDataContext = new HashMap<String, String>();
        pluginDataContext.put("file", this.provider.getArchiveFile().getAbsolutePath());
        pluginDataContext.put("scriptfile", this.provider.getScriptFile().getAbsolutePath());
        pluginDataContext.put("base", this.provider.getContentsBasedir().getAbsolutePath());
        return pluginDataContext;
    }

    boolean isMergeEnvVars() {
        return this.metaBooleanProp(SETTING_MERGE_ENVIRONMENT, this.provider.getDefaultMergeEnvVars());
    }

    private boolean metaBooleanProp(String prop, boolean defVal) {
        Object o = this.provider.getMetadata().get(prop);
        if (o == null) {
            return defVal;
        }
        if (o == Boolean.TRUE) {
            return true;
        }
        return "true".equals(o);
    }

    private static void createProperties(ScriptPluginProvider provider, boolean useConventionalPropertiesMapping, DescriptionBuilder dbuilder) throws ConfigurationException {
        Map<String, Object> metadata = provider.getMetadata();
        Object config = metadata.get(CONFIG_PROP_PREFIX);
        if (config instanceof List) {
            List configs = (List)config;
            for (Object citem : configs) {
                Object renderingOpts;
                String scopeString;
                ArrayList<String> values;
                List valueList;
                if (!(citem instanceof Map)) continue;
                PropertyBuilder pbuild = PropertyBuilder.builder();
                Map itemmeta = (Map)citem;
                String typestr = AbstractDescribableScriptPlugin.metaStringProp(itemmeta, CONFIG_TYPE);
                try {
                    pbuild.type(Property.Type.valueOf(typestr));
                }
                catch (IllegalArgumentException e) {
                    throw new ConfigurationException("Invalid property type: " + typestr);
                }
                String propName = AbstractDescribableScriptPlugin.metaStringProp(itemmeta, CONFIG_NAME);
                pbuild.name(propName).title(AbstractDescribableScriptPlugin.metaStringProp(itemmeta, "title")).description(AbstractDescribableScriptPlugin.metaStringProp(itemmeta, "description"));
                Object reqValue = itemmeta.get(CONFIG_REQUIRED);
                boolean required = reqValue instanceof Boolean ? (Boolean)reqValue : reqValue instanceof String && Boolean.parseBoolean((String)reqValue);
                pbuild.required(required);
                Object defObj = itemmeta.get(CONFIG_DEFAULT);
                pbuild.defaultValue(null != defObj ? defObj.toString() : null);
                String valuesstr = AbstractDescribableScriptPlugin.metaStringProp(itemmeta, CONFIG_VALUES);
                if (null != valuesstr) {
                    String[] split = null != valuesstr ? valuesstr.split(",") : null;
                    valueList = Arrays.asList(split);
                } else {
                    Object vlist = itemmeta.get(CONFIG_VALUES);
                    valueList = vlist instanceof List ? (List)vlist : null;
                }
                if (null != valueList) {
                    ArrayList<String> valuesA = new ArrayList<String>();
                    for (String s : valueList) {
                        valuesA.add(s.trim());
                    }
                    values = valuesA;
                } else {
                    values = null;
                }
                pbuild.values(values);
                Object labelmap = itemmeta.get(CONFIG_LABELS);
                if (labelmap instanceof Map) {
                    pbuild.labels((Map)labelmap);
                }
                if (null != (scopeString = AbstractDescribableScriptPlugin.metaStringProp(itemmeta, CONFIG_SCOPE))) {
                    try {
                        pbuild.scope(PropertyScope.valueOf(scopeString.trim()));
                    }
                    catch (IllegalArgumentException e) {
                        throw new ConfigurationException("Invalid property scope: " + scopeString);
                    }
                }
                if (useConventionalPropertiesMapping) {
                    String projectPropertyPrefix = PropertyResolverFactory.projectPropertyPrefix(PropertyResolverFactory.pluginPropertyPrefix(provider.getService(), provider.getName()));
                    dbuilder.mapping(propName, projectPropertyPrefix + propName);
                    String frameworkPropertyPrefix = PropertyResolverFactory.frameworkPropertyPrefix(PropertyResolverFactory.pluginPropertyPrefix(provider.getService(), provider.getName()));
                    dbuilder.frameworkMapping(propName, frameworkPropertyPrefix + propName);
                }
                if (null != (renderingOpts = itemmeta.get(CONFIG_RENDERING_OPTIONS)) && renderingOpts instanceof Map) {
                    Map renderingOptsMap = (Map)renderingOpts;
                    pbuild.renderingOptions(renderingOptsMap);
                }
                try {
                    dbuilder.property(pbuild.build());
                }
                catch (IllegalStateException e) {
                    throw new ConfigurationException(e.getMessage());
                }
            }
        }
    }

    private static String metaStringProp(Map<String, Object> metadata, String prop) {
        return AbstractDescribableScriptPlugin.metaStringProp(metadata, prop, null);
    }

    private static String metaStringProp(Map<String, Object> metadata, String prop, String defString) {
        Object titleobj = metadata.get(prop);
        return null != titleobj && titleobj instanceof String ? (String)titleobj : defString;
    }

    protected static void createDescription(ScriptPluginProvider provider, boolean allowCustomProperties, DescriptionBuilder builder) throws ConfigurationException {
        AbstractDescribableScriptPlugin.createDescription(provider, allowCustomProperties, false, builder);
    }

    protected static void createDescription(ScriptPluginProvider provider, boolean allowCustomProperties, boolean useConventionalPropertiesMapping, DescriptionBuilder builder) throws ConfigurationException {
        builder.name(provider.getName()).title(AbstractDescribableScriptPlugin.metaStringProp(provider.getMetadata(), "title", provider.getName() + " Script Plugin")).description(AbstractDescribableScriptPlugin.metaStringProp(provider.getMetadata(), "description", ""));
        if (allowCustomProperties) {
            AbstractDescribableScriptPlugin.createProperties(provider, useConventionalPropertiesMapping, builder);
        }
    }

    protected Map<String, Object> loadInstanceDataFromNodeAttributes(INodeEntry node, Description description) {
        HashMap<String, Object> config = new HashMap<String, Object>();
        for (Property property : description.getProperties()) {
            Object o;
            Map<String, Object> renderingOptions = property.getRenderingOptions();
            if (null == renderingOptions || null == (o = renderingOptions.get("instance-scope-node-attribute")) || !(o instanceof String)) continue;
            String attribute = (String)o;
            String s = node.getAttributes().get(attribute);
            if (s == null) continue;
            config.put(property.getName(), s);
        }
        return config;
    }

    protected Map<String, Map<String, String>> loadConfigData(ExecutionContext context, Map<String, Object> instanceData, Map<String, Map<String, String>> localDataContext, Description description, String serviceName) throws ConfigurationException {
        PropertyResolver resolver = PropertyResolverFactory.createPluginRuntimeResolver(context, instanceData, serviceName, this.getProvider().getName());
        Map<String, Object> config = PluginAdapterUtility.mapDescribedProperties(resolver, description, PropertyScope.Instance);
        Map<String, Object> expanded = DataContextUtils.replaceDataReferences(config, localDataContext);
        Map<String, String> data = AbstractDescribableScriptPlugin.toStringStringMap(expanded);
        this.loadContentConversionPropertyValues(data, context, description.getProperties());
        return DataContextUtils.addContext(CONFIG_PROP_PREFIX, data, localDataContext);
    }

    protected void loadContentConversionPropertyValues(Map<String, String> data, ExecutionContext context, List<Property> pluginProperties) throws ConfigurationException {
        for (Property property : pluginProperties) {
            Map<String, Object> renderingOptions;
            String name = property.getName();
            String propValue = data.get(name);
            if (null == propValue || (renderingOptions = property.getRenderingOptions()) == null) continue;
            Object conversion = renderingOptions.get("valueConversion");
            if (StringRenderingConstants.ValueConversion.STORAGE_PATH_AUTOMATIC_READ.equalsOrString(conversion)) {
                this.convertStoragePathValue(data, context.getStorageTree(), name, propValue, renderingOptions);
                continue;
            }
            if (!StringRenderingConstants.ValueConversion.PRIVATE_DATA_CONTEXT.equalsOrString(conversion)) continue;
            this.convertPrivateDataValue(data, context.getPrivateDataContext(), name, propValue, renderingOptions);
        }
    }

    private void convertStoragePathValue(Map<String, String> data, StorageTree storageTree, String name, String propValue, Map<String, Object> renderingOptions) throws ConfigurationException {
        String root = null;
        if (null != renderingOptions.get("storage-path-root")) {
            root = renderingOptions.get("storage-path-root").toString();
        }
        String filter = null;
        if (null != renderingOptions.get("storage-file-meta-filter")) {
            filter = renderingOptions.get("storage-file-meta-filter").toString();
        }
        boolean clearValue = this.isValueConversionFailureRemove(renderingOptions);
        if (null != root && !PathUtil.hasRoot((String)propValue, (String)root)) {
            if (clearValue) {
                data.remove(name);
            }
            return;
        }
        try {
            String[] filterComponents;
            Resource resource = storageTree.getResource(propValue);
            ResourceMeta contents = (ResourceMeta)resource.getContents();
            if (filter != null && (filterComponents = filter.split("=", 2)).length == 2) {
                String key = filterComponents[0];
                String test = filterComponents[1];
                Map meta = contents.getMeta();
                if (meta == null || !test.equals(meta.get(key))) {
                    if (clearValue) {
                        data.remove(name);
                    }
                    return;
                }
            }
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            contents.writeContent(byteArrayOutputStream);
            data.put(name, new String(byteArrayOutputStream.toByteArray()));
        }
        catch (IOException | StorageException e) {
            if (clearValue) {
                data.remove(name);
                return;
            }
            throw new ConfigurationException("Unable to load configuration key '" + name + "' value from storage path:  " + propValue, (Exception)e);
        }
    }

    private void convertPrivateDataValue(Map<String, String> data, Map<String, Map<String, String>> privateDataContext, String name, String propValue, Map<String, Object> renderingOptions) throws ConfigurationException {
        boolean clearValue = this.isValueConversionFailureRemove(renderingOptions);
        String[] prop = propValue.split("\\.", 2);
        if (prop.length < 2 || prop[0].length() < 1 || prop[1].length() < 1) {
            throw new ConfigurationException("Unable to load '" + name + "' configuration value: Expected 'option.name' format, but saw: " + propValue);
        }
        String newvalue = DataContextUtils.resolve(privateDataContext, prop[0], prop[1]);
        if (null == newvalue) {
            if (clearValue) {
                data.remove(name);
            }
            return;
        }
        data.put(name, newvalue);
    }

    private boolean isValueConversionFailureRemove(Map<String, Object> renderingOptions) {
        return "remove".equals(renderingOptions.get("valueConversionFailure"));
    }

    protected static Map<String, String> toStringStringMap(Map input) {
        HashMap<String, String> map = new HashMap<String, String>();
        for (Object o : input.keySet()) {
            map.put(o.toString(), input.get(o) != null ? input.get(o).toString() : "");
        }
        return map;
    }

    @Override
    public Description getDescription() {
        if (null == this.description) {
            DescriptionBuilder builder = DescriptionBuilder.builder();
            try {
                AbstractDescribableScriptPlugin.createDescription(this.provider, this.isAllowCustomProperties(), this.isUseConventionalPropertiesMapping(), builder);
            }
            catch (ConfigurationException e) {
                e.printStackTrace();
            }
            this.description = builder.build();
        }
        return this.description;
    }

    public abstract boolean isAllowCustomProperties();

    public boolean isUseConventionalPropertiesMapping() {
        return false;
    }

    public ScriptPluginProvider getProvider() {
        return this.provider;
    }

    public Framework getFramework() {
        return this.framework;
    }
}

