/*
 * Decompiled with CFR 0.152.
 */
package com.dtolabs.rundeck.core.rules;

import com.dtolabs.rundeck.core.rules.BaseRuleEngine;
import com.dtolabs.rundeck.core.rules.Condition;
import com.dtolabs.rundeck.core.rules.KeyValueEqualsCondition;
import com.dtolabs.rundeck.core.rules.MatchesCondition;
import com.dtolabs.rundeck.core.rules.MutableStateObj;
import com.dtolabs.rundeck.core.rules.Rule;
import com.dtolabs.rundeck.core.rules.RuleEngine;
import com.dtolabs.rundeck.core.rules.StateObj;
import com.dtolabs.rundeck.core.rules.States;
import com.google.common.base.Function;
import com.google.common.base.Optional;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public class Rules {
    public static RuleEngine createEngine(Set<Rule> ruleset) {
        return new BaseRuleEngine(ruleset);
    }

    public static RuleEngine createEngine() {
        return Rules.createEngine(new HashSet<Rule>());
    }

    public static Condition equalsCondition(String key, String value) {
        return new KeyValueEqualsCondition(key, value);
    }

    public static Condition equalsCondition(final StateObj state) {
        return new Condition(){

            public boolean apply(StateObj input) {
                return input.hasState(state);
            }

            public String toString() {
                return "(State equals: " + state + ")";
            }
        };
    }

    public static Set<Condition> conditionSet(Condition ... condition) {
        HashSet<Condition> conditions = new HashSet<Condition>();
        conditions.addAll(Arrays.asList(condition));
        return conditions;
    }

    public static Condition matchesCondition(String key, boolean keyRegex, String value, boolean valueRegex) {
        return new MatchesCondition(key, keyRegex, value, valueRegex);
    }

    public static Rule conditionsRule(Condition condition, String key, String value) {
        return Rules.conditionsRule(condition, States.state(key, value));
    }

    public static Rule conditionsRule(Condition condition, StateObj result) {
        HashSet<Condition> conditions = new HashSet<Condition>();
        conditions.add(condition);
        return Rules.conditionsRule(conditions, result);
    }

    public static Condition not(Condition condition) {
        return Rules.conditionFrom((Predicate<StateObj>)Predicates.not((Predicate)condition));
    }

    public static Condition and(Condition condition1, Condition condition2) {
        return Rules.conditionFrom((Predicate<StateObj>)Predicates.and((Predicate)condition1, (Predicate)condition2));
    }

    public static Condition and(Condition ... conditions) {
        return Rules.conditionFrom((Predicate<StateObj>)Predicates.and((Predicate[])conditions));
    }

    public static Condition and(Iterable<Condition> conditions) {
        return Rules.conditionFrom((Predicate<StateObj>)Predicates.and(conditions));
    }

    public static Condition or(Condition condition1, Condition condition2) {
        return Rules.conditionFrom((Predicate<StateObj>)Predicates.or((Predicate)condition1, (Predicate)condition2));
    }

    public static Condition or(Condition ... conditions) {
        return Rules.conditionFrom((Predicate<StateObj>)Predicates.or((Predicate[])conditions));
    }

    public static Condition or(Iterable<Condition> conditions) {
        return Rules.conditionFrom((Predicate<StateObj>)Predicates.or(conditions));
    }

    static Condition conditionFrom(final Predicate<StateObj> pred) {
        return new Condition(){

            public boolean apply(StateObj input) {
                return pred.apply((Object)input);
            }

            public String toString() {
                return pred.toString();
            }
        };
    }

    public static Rule conditionsRule(Set<Condition> conditions, String key, String value) {
        HashMap<String, String> results = new HashMap<String, String>();
        results.put(key, value);
        return Rules.conditionsRule(conditions, results);
    }

    public static Rule conditionsRule(Set<Condition> conditions, Map<String, String> results) {
        return Rules.conditionsRule(conditions, States.state(results));
    }

    public static Rule conditionsRule(final Set<Condition> conditions, StateObj results) {
        if (null == conditions) {
            throw new NullPointerException("conditions must not be null");
        }
        final StateObj newstate = States.state(results);
        return new Rule(){

            public boolean apply(StateObj input) {
                return Rules.applyConditions(input, conditions, true);
            }

            @Override
            public StateObj evaluate(StateObj stateObj) {
                if (this.apply(stateObj)) {
                    return newstate;
                }
                return null;
            }

            public String toString() {
                return "Rule: Conditions(" + conditions + ") => " + newstate;
            }
        };
    }

    public static boolean applyConditions(StateObj state, Set<Condition> runConditions, boolean operationAnd) {
        boolean allCondition = operationAnd;
        for (Condition condition : runConditions) {
            boolean apply = condition.apply(state);
            allCondition = operationAnd ? allCondition && apply : allCondition || apply;
        }
        return allCondition;
    }

    public static boolean update(RuleEngine ruleEngine, MutableStateObj state) {
        StateObj newState = ruleEngine.evaluateRules(state);
        state.updateState(newState);
        return newState.getState().size() > 0;
    }

    public static Predicate<? super Rule> ruleApplies(final StateObj state) {
        return new Predicate<Rule>(){

            public boolean apply(Rule input) {
                assert (input != null);
                return input.apply(state);
            }
        };
    }

    public static Function<? super Rule, Optional<StateObj>> applyRule(final StateObj state) {
        return new Function<Rule, Optional<StateObj>>(){

            public Optional<StateObj> apply(Rule input) {
                return Optional.fromNullable((Object)input.evaluate(state));
            }
        };
    }
}

