/*
 * Decompiled with CFR 0.152.
 */
package com.dtolabs.rundeck.core.execution;

import com.dtolabs.rundeck.core.authorization.AuthContext;
import com.dtolabs.rundeck.core.common.Framework;
import com.dtolabs.rundeck.core.common.INodeEntry;
import com.dtolabs.rundeck.core.common.INodeSet;
import com.dtolabs.rundeck.core.common.NodeSetImpl;
import com.dtolabs.rundeck.core.common.NodesSelector;
import com.dtolabs.rundeck.core.common.OrchestratorConfig;
import com.dtolabs.rundeck.core.common.SelectorUtils;
import com.dtolabs.rundeck.core.data.BaseDataContext;
import com.dtolabs.rundeck.core.data.DataContext;
import com.dtolabs.rundeck.core.data.MultiDataContext;
import com.dtolabs.rundeck.core.data.MultiDataContextImpl;
import com.dtolabs.rundeck.core.data.SharedDataContextUtils;
import com.dtolabs.rundeck.core.dispatcher.ContextView;
import com.dtolabs.rundeck.core.dispatcher.DataContextUtils;
import com.dtolabs.rundeck.core.execution.ExecutionContext;
import com.dtolabs.rundeck.core.execution.ExecutionListener;
import com.dtolabs.rundeck.core.execution.ExecutionLogger;
import com.dtolabs.rundeck.core.execution.workflow.FlowControl;
import com.dtolabs.rundeck.core.execution.workflow.SharedOutputContext;
import com.dtolabs.rundeck.core.execution.workflow.StepExecutionContext;
import com.dtolabs.rundeck.core.execution.workflow.WorkflowExecutionListener;
import com.dtolabs.rundeck.core.execution.workflow.steps.node.NodeExecutionContext;
import com.dtolabs.rundeck.core.jobs.JobService;
import com.dtolabs.rundeck.core.logging.LoggingManager;
import com.dtolabs.rundeck.core.nodes.ProjectNodeService;
import com.dtolabs.rundeck.core.storage.StorageTree;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class ExecutionContextImpl
implements ExecutionContext,
StepExecutionContext,
NodeExecutionContext {
    private String frameworkProject;
    private String user;
    private NodesSelector nodeSet;
    private INodeSet nodes;
    private INodeEntry singleNodeContext;
    private int threadCount;
    private boolean keepgoing;
    private int loglevel;
    private String charsetEncoding;
    private DataContext dataContext;
    private DataContext privateDataContext;
    private MultiDataContext<ContextView, DataContext> sharedDataContext;
    private ExecutionListener executionListener;
    private WorkflowExecutionListener workflowExecutionListener;
    private ExecutionLogger executionLogger;
    private Framework framework;
    private AuthContext authContext;
    private String nodeRankAttribute;
    private boolean nodeRankOrderAscending = true;
    private int stepNumber = 1;
    private List<Integer> stepContext = new ArrayList<Integer>();
    private StorageTree storageTree;
    private JobService jobService;
    private ProjectNodeService nodeService;
    private FlowControl flowControl;
    private SharedOutputContext outputContext;
    private LoggingManager loggingManager;
    private OrchestratorConfig orchestrator;

    private ExecutionContextImpl() {
        this.nodes = new NodeSetImpl();
        this.dataContext = new BaseDataContext();
        this.privateDataContext = new BaseDataContext();
        this.sharedDataContext = new MultiDataContextImpl<ContextView, DataContext>();
        this.outputContext = SharedDataContextUtils.outputContext(ContextView.global());
    }

    public static Builder builder() {
        return new Builder();
    }

    public static Builder builder(ExecutionContext context) {
        return new Builder(context);
    }

    public static Builder builder(StepExecutionContext context) {
        return new Builder(context);
    }

    @Override
    public MultiDataContext<ContextView, DataContext> getSharedDataContext() {
        return this.sharedDataContext;
    }

    @Override
    public AuthContext getAuthContext() {
        return this.authContext;
    }

    public void setAuthContext(AuthContext authContext) {
        this.authContext = authContext;
    }

    @Override
    public StorageTree getStorageTree() {
        return this.storageTree;
    }

    @Override
    public FlowControl getFlowControl() {
        return this.flowControl;
    }

    @Override
    public String getCharsetEncoding() {
        return this.charsetEncoding;
    }

    public void setCharsetEncoding(String charsetEncoding) {
        this.charsetEncoding = charsetEncoding;
    }

    @Override
    public SharedOutputContext getOutputContext() {
        return this.outputContext;
    }

    @Override
    public INodeEntry getSingleNodeContext() {
        return this.singleNodeContext;
    }

    @Override
    public LoggingManager getLoggingManager() {
        return this.loggingManager;
    }

    @Override
    public String getFrameworkProject() {
        return this.frameworkProject;
    }

    @Override
    public String getUser() {
        return this.user;
    }

    @Override
    public NodesSelector getNodeSelector() {
        return this.nodeSet;
    }

    @Override
    public INodeSet getNodes() {
        return this.nodes;
    }

    @Override
    public int getLoglevel() {
        return this.loglevel;
    }

    @Override
    public DataContext getDataContext() {
        return this.dataContext;
    }

    @Override
    public ExecutionListener getExecutionListener() {
        return this.executionListener;
    }

    @Override
    public WorkflowExecutionListener getWorkflowExecutionListener() {
        return this.workflowExecutionListener;
    }

    @Override
    public ExecutionLogger getExecutionLogger() {
        return this.executionLogger;
    }

    @Override
    public Framework getFramework() {
        return this.framework;
    }

    @Override
    public int getThreadCount() {
        return this.threadCount;
    }

    @Override
    public boolean isKeepgoing() {
        return this.keepgoing;
    }

    @Override
    public DataContext getPrivateDataContext() {
        return this.privateDataContext;
    }

    @Override
    public String getNodeRankAttribute() {
        return this.nodeRankAttribute;
    }

    @Override
    public boolean isNodeRankOrderAscending() {
        return this.nodeRankOrderAscending;
    }

    @Override
    public int getStepNumber() {
        return this.stepNumber;
    }

    @Override
    public List<Integer> getStepContext() {
        return this.stepContext;
    }

    @Override
    public JobService getJobService() {
        return this.jobService;
    }

    @Override
    public ProjectNodeService getNodeService() {
        return this.nodeService;
    }

    @Override
    public OrchestratorConfig getOrchestrator() {
        return this.orchestrator;
    }

    public static class Builder {
        private ExecutionContextImpl ctx = new ExecutionContextImpl();

        public Builder() {
        }

        public Builder(ExecutionContext original) {
            this();
            if (null != original) {
                this.ctx.frameworkProject = original.getFrameworkProject();
                this.ctx.user = original.getUser();
                this.ctx.nodeSet = original.getNodeSelector();
                this.ctx.nodes = original.getNodes();
                this.ctx.loglevel = original.getLoglevel();
                this.ctx.charsetEncoding = original.getCharsetEncoding();
                this.ctx.dataContext = original.getDataContext();
                this.ctx.privateDataContext = original.getPrivateDataContext();
                this.ctx.executionListener = original.getExecutionListener();
                this.ctx.workflowExecutionListener = original.getWorkflowExecutionListener();
                this.ctx.executionLogger = original.getExecutionLogger();
                this.ctx.framework = original.getFramework();
                this.ctx.authContext = original.getAuthContext();
                this.ctx.threadCount = original.getThreadCount();
                this.ctx.keepgoing = original.isKeepgoing();
                this.ctx.nodeRankAttribute = original.getNodeRankAttribute();
                this.ctx.nodeRankOrderAscending = original.isNodeRankOrderAscending();
                this.ctx.storageTree = original.getStorageTree();
                this.ctx.jobService = original.getJobService();
                this.ctx.nodeService = original.getNodeService();
                this.ctx.orchestrator = original.getOrchestrator();
                this.ctx.outputContext = original.getOutputContext();
                this.ctx.sharedDataContext = MultiDataContextImpl.with(original.getSharedDataContext());
                this.ctx.loggingManager = original.getLoggingManager();
                if (original instanceof NodeExecutionContext) {
                    NodeExecutionContext original1 = (NodeExecutionContext)original;
                    this.ctx.singleNodeContext = original1.getSingleNodeContext();
                }
            }
        }

        public Builder loggingManager(LoggingManager loggingManager) {
            this.ctx.loggingManager = loggingManager;
            return this;
        }

        public Builder storageTree(StorageTree storageTree) {
            this.ctx.storageTree = storageTree;
            return this;
        }

        public Builder jobService(JobService jobService) {
            this.ctx.jobService = jobService;
            return this;
        }

        public Builder nodeService(ProjectNodeService nodeService) {
            this.ctx.nodeService = nodeService;
            return this;
        }

        public Builder(StepExecutionContext original) {
            this((ExecutionContext)original);
            if (null != original) {
                this.ctx.stepNumber = original.getStepNumber();
                this.ctx.stepContext = null != original.getStepContext() ? new ArrayList<Integer>(original.getStepContext()) : null;
                this.ctx.flowControl = original.getFlowControl();
            }
        }

        public Builder flowControl(FlowControl flowControl) {
            this.ctx.flowControl = flowControl;
            return this;
        }

        public Builder outputContext(SharedOutputContext outputContext) {
            this.ctx.outputContext = outputContext;
            return this;
        }

        public Builder frameworkProject(String frameworkProject) {
            this.ctx.frameworkProject = frameworkProject;
            return this;
        }

        public Builder user(String user) {
            this.ctx.user = user;
            return this;
        }

        public Builder nodeSelector(NodesSelector nodeSet) {
            this.ctx.nodeSet = nodeSet;
            return this;
        }

        public Builder nodes(INodeSet nodeSet) {
            this.ctx.nodes = nodeSet;
            return this;
        }

        public Builder singleNodeContext(INodeEntry node, boolean setContextData) {
            this.nodeSelector(SelectorUtils.singleNode(node.getNodename()));
            this.nodes(NodeSetImpl.singleNodeSet(node));
            if (setContextData) {
                this.nodeContextData(node);
                this.ctx.singleNodeContext = node;
            }
            return this;
        }

        public Builder nodeContextData(INodeEntry node) {
            this.ctx.dataContext.merge(new BaseDataContext("node", DataContextUtils.nodeData(node)));
            this.ctx.sharedDataContext.merge(ContextView.node(node.getNodename()), new BaseDataContext("node", DataContextUtils.nodeData(node)));
            return this;
        }

        public Builder setContext(String key, Map<String, String> data) {
            return this.dataContext(DataContextUtils.addContext(key, data, this.ctx.dataContext));
        }

        public Builder mergeContext(Map<String, Map<String, String>> data) {
            return this.mergeContext(new BaseDataContext(data));
        }

        public Builder mergeContext(DataContext data) {
            this.ctx.dataContext.merge(data);
            this.ctx.sharedDataContext.merge(ContextView.global(), data);
            return this;
        }

        public Builder mergeContext(String key, Map<String, String> data) {
            HashMap<String, Map<String, String>> tomerge = new HashMap<String, Map<String, String>>();
            tomerge.put(key, data);
            return this.mergeContext(tomerge);
        }

        public Builder loglevel(int loglevel) {
            this.ctx.loglevel = loglevel;
            return this;
        }

        public Builder charsetEncoding(String charsetEncoding) {
            this.ctx.charsetEncoding = charsetEncoding;
            return this;
        }

        public Builder dataContext(Map<String, Map<String, String>> dataContext) {
            this.ctx.dataContext = new BaseDataContext(dataContext);
            this.ctx.sharedDataContext.getData().put(ContextView.global(), new BaseDataContext(dataContext));
            return this;
        }

        public Builder dataContext(DataContext dataContext) {
            this.ctx.dataContext = new BaseDataContext(dataContext);
            this.ctx.sharedDataContext.getData().put(ContextView.global(), new BaseDataContext(dataContext));
            return this;
        }

        public Builder privateDataContext(Map<String, Map<String, String>> privateDataContext) {
            this.ctx.privateDataContext = new BaseDataContext(privateDataContext);
            return this;
        }

        public Builder privateDataContext(DataContext privateDataContext) {
            this.ctx.privateDataContext = new BaseDataContext(privateDataContext);
            return this;
        }

        public Builder executionListener(ExecutionListener executionListener) {
            this.ctx.executionListener = executionListener;
            this.ctx.executionLogger = executionListener;
            return this;
        }

        public Builder workflowExecutionListener(WorkflowExecutionListener workflowExecutionListener) {
            this.ctx.workflowExecutionListener = workflowExecutionListener;
            return this;
        }

        public Builder executionLogger(ExecutionLogger executionLogger) {
            this.ctx.executionLogger = executionLogger;
            return this;
        }

        public Builder framework(Framework framework) {
            this.ctx.framework = framework;
            return this;
        }

        public Builder authContext(AuthContext authContext) {
            this.ctx.authContext = authContext;
            return this;
        }

        public Builder threadCount(int threadCount) {
            this.ctx.threadCount = threadCount;
            return this;
        }

        public Builder keepgoing(boolean keepgoing) {
            this.ctx.keepgoing = keepgoing;
            return this;
        }

        public Builder nodeRankAttribute(String nodeRankAttribute) {
            this.ctx.nodeRankAttribute = nodeRankAttribute;
            return this;
        }

        public Builder nodeRankOrderAscending(boolean nodeRankOrderAscending) {
            this.ctx.nodeRankOrderAscending = nodeRankOrderAscending;
            return this;
        }

        public Builder stepNumber(int number) {
            this.ctx.stepNumber = number;
            return this;
        }

        public Builder stepContext(List<Integer> stepContext) {
            this.ctx.stepContext = stepContext;
            return this;
        }

        public Builder orchestrator(OrchestratorConfig orchestrator) {
            this.ctx.orchestrator = orchestrator;
            return this;
        }

        public Builder pushContextStep(int step) {
            this.ctx.stepContext.add(this.ctx.stepNumber);
            this.ctx.stepNumber = step;
            return this;
        }

        public Builder nodeDataContext(String nodeName, Map<String, Map<String, String>> dataContext) {
            this.ctx.sharedDataContext.merge(ContextView.nodeStep(this.ctx.stepNumber, nodeName), new BaseDataContext(dataContext));
            this.ctx.sharedDataContext.merge(ContextView.node(nodeName), new BaseDataContext(dataContext));
            return this;
        }

        public Builder sharedDataContext(MultiDataContext<ContextView, DataContext> shared) {
            this.ctx.sharedDataContext = new MultiDataContextImpl<ContextView, DataContext>(shared);
            if (null != this.ctx.dataContext) {
                this.ctx.sharedDataContext.merge(ContextView.global(), this.ctx.dataContext);
            }
            return this;
        }

        public Builder mergeSharedContext(MultiDataContext<ContextView, DataContext> shared) {
            this.ctx.sharedDataContext.merge(shared);
            return this;
        }

        public Builder sharedDataContextClear() {
            this.ctx.sharedDataContext = new MultiDataContextImpl();
            return this;
        }

        public ExecutionContextImpl build() {
            return this.ctx;
        }
    }
}

