/*
 * Decompiled with CFR 0.152.
 */
package com.dtolabs.rundeck.core.execution;

import com.dtolabs.rundeck.core.execution.ExecutionListener;
import com.dtolabs.rundeck.core.utils.LogReformatter;
import java.io.PrintStream;
import java.util.Map;
import org.apache.tools.ant.BuildEvent;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.BuildLogger;
import org.apache.tools.ant.util.StringUtils;

public class ExecutionListenerBuildLogger
implements BuildLogger {
    ExecutionListener listener;
    int msgOutputLevel;
    private LogReformatter reformatter;
    private Map<String, String> logContext;
    private static String lSep = System.getProperty("line.separator");

    public ExecutionListenerBuildLogger(ExecutionListener listener) {
        this.listener = listener;
    }

    public void setMessageOutputLevel(int i) {
        this.msgOutputLevel = i;
    }

    public int getMessageOutputLevel() {
        return this.msgOutputLevel;
    }

    public void setOutputPrintStream(PrintStream output) {
    }

    public void setEmacsMode(boolean emacsMode) {
    }

    public void setErrorPrintStream(PrintStream err) {
    }

    public void buildStarted(BuildEvent e) {
        this.listener.log(3, this.reformat(e));
    }

    public void buildFinished(BuildEvent event) {
        Throwable error = event.getException();
        StringBuilder message = new StringBuilder();
        if (error != null) {
            message.append("Command failed.");
            message.append(lSep);
            if (3 <= this.msgOutputLevel || !(error instanceof BuildException)) {
                message.append(StringUtils.getStackTrace((Throwable)error));
            } else {
                message.append(error.toString()).append(lSep);
            }
            this.listener.log(0, message.toString());
        }
    }

    public void targetStarted(BuildEvent e) {
        this.listener.log(3, this.reformat(e));
    }

    public void targetFinished(BuildEvent e) {
        this.listener.log(3, this.reformat(e));
    }

    private String reformat(BuildEvent e) {
        if (null != this.reformatter) {
            return this.reformatter.reformat(this.logContext, e.getMessage());
        }
        return e.getMessage();
    }

    public void taskStarted(BuildEvent event) {
    }

    public void taskFinished(BuildEvent event) {
    }

    public void messageLogged(BuildEvent event) {
        this.listener.log(event.getPriority(), this.reformat(event));
    }

    public LogReformatter getReformatter() {
        return this.reformatter;
    }

    public void setReformatter(LogReformatter reformatter) {
        this.reformatter = reformatter;
    }

    public Map<String, String> getLogContext() {
        return this.logContext;
    }

    public void setLogContext(Map<String, String> logContext) {
        this.logContext = logContext;
    }
}

