/*
 * Decompiled with CFR 0.152.
 */
package com.dtolabs.rundeck.core.execution;

import com.dtolabs.rundeck.core.execution.ServiceThreadBase;
import com.dtolabs.rundeck.core.execution.workflow.StepExecutionContext;
import com.dtolabs.rundeck.core.execution.workflow.WorkflowExecutionItem;
import com.dtolabs.rundeck.core.execution.workflow.WorkflowExecutionResult;
import com.dtolabs.rundeck.core.execution.workflow.WorkflowExecutionService;
import com.dtolabs.rundeck.core.execution.workflow.WorkflowExecutor;
import com.dtolabs.rundeck.core.logging.LoggingManager;
import com.dtolabs.rundeck.core.logging.PluginLoggingManager;

public class WorkflowExecutionServiceThread
extends ServiceThreadBase<WorkflowExecutionResult> {
    WorkflowExecutionService weservice;
    WorkflowExecutionItem weitem;
    private StepExecutionContext context;
    private WorkflowExecutionResult result;
    private LoggingManager loggingManager;

    public WorkflowExecutionServiceThread(WorkflowExecutionService eservice, WorkflowExecutionItem eitem, StepExecutionContext econtext, LoggingManager loggingManager) {
        this.weservice = eservice;
        this.weitem = eitem;
        this.context = econtext;
        this.loggingManager = loggingManager;
    }

    @Override
    public void run() {
        if (null == this.weservice || null == this.weitem || null == this.context) {
            throw new IllegalStateException("project or execution detail not instantiated");
        }
        if (this.loggingManager != null) {
            PluginLoggingManager pluginLogging = this.loggingManager.createPluginLogging(this.context, null);
            this.resultObject = pluginLogging.runWith(this::runWorkflow);
        } else {
            this.resultObject = this.runWorkflow();
        }
    }

    public WorkflowExecutionResult runWorkflow() {
        try {
            WorkflowExecutor executorForItem = this.weservice.getExecutorForItem(this.weitem);
            this.setResult(executorForItem.executeWorkflow(this.context, this.weitem));
            this.success = this.getResult().isSuccess();
            if (null != this.getResult().getException()) {
                this.thrown = this.getResult().getException();
            }
            return this.getResult();
        }
        catch (Throwable e) {
            e.printStackTrace(System.err);
            this.thrown = e;
            return null;
        }
    }

    public StepExecutionContext getContext() {
        return this.context;
    }

    public WorkflowExecutionResult getResult() {
        return this.result;
    }

    public void setResult(WorkflowExecutionResult result) {
        this.result = result;
    }
}

