/*
 * Decompiled with CFR 0.152.
 */
package com.dtolabs.rundeck.core.execution.dispatch;

import com.dtolabs.rundeck.core.common.Framework;
import com.dtolabs.rundeck.core.common.INodeEntry;
import com.dtolabs.rundeck.core.common.INodeSet;
import com.dtolabs.rundeck.core.common.OrchestratorConfig;
import com.dtolabs.rundeck.core.dispatcher.DataContextUtils;
import com.dtolabs.rundeck.core.execution.ExecutionContext;
import com.dtolabs.rundeck.core.execution.FailedNodesListener;
import com.dtolabs.rundeck.core.execution.dispatch.Dispatchable;
import com.dtolabs.rundeck.core.execution.dispatch.DispatcherException;
import com.dtolabs.rundeck.core.execution.dispatch.DispatcherResult;
import com.dtolabs.rundeck.core.execution.dispatch.DispatcherResultImpl;
import com.dtolabs.rundeck.core.execution.dispatch.INodeEntryComparator;
import com.dtolabs.rundeck.core.execution.dispatch.NodeDispatcher;
import com.dtolabs.rundeck.core.execution.dispatch.OrchestratorNodeProcessor;
import com.dtolabs.rundeck.core.execution.dispatch.ParallelNodeDispatcher;
import com.dtolabs.rundeck.core.execution.orchestrator.OrchestratorService;
import com.dtolabs.rundeck.core.execution.service.ProviderLoaderException;
import com.dtolabs.rundeck.core.execution.workflow.StepExecutionContext;
import com.dtolabs.rundeck.core.execution.workflow.steps.node.NodeStepExecutionItem;
import com.dtolabs.rundeck.core.execution.workflow.steps.node.NodeStepResult;
import com.dtolabs.rundeck.core.plugins.ServiceProviderLoader;
import com.dtolabs.rundeck.core.plugins.configuration.Description;
import com.dtolabs.rundeck.core.plugins.configuration.PluginAdapterUtility;
import com.dtolabs.rundeck.core.plugins.configuration.PropertyResolver;
import com.dtolabs.rundeck.core.plugins.configuration.PropertyResolverFactory;
import com.dtolabs.rundeck.core.plugins.configuration.PropertyScope;
import com.dtolabs.rundeck.plugins.orchestrator.Orchestrator;
import com.dtolabs.rundeck.plugins.orchestrator.OrchestratorPlugin;
import com.dtolabs.rundeck.plugins.util.DescriptionBuilder;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.TreeSet;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;

public class OrchestratorNodeDispatcher
implements NodeDispatcher {
    private Framework framework;

    public OrchestratorNodeDispatcher(Framework framework) {
        this.framework = framework;
    }

    @Override
    public DispatcherResult dispatch(StepExecutionContext context, NodeStepExecutionItem item) throws DispatcherException {
        return this.dispatch(context, item, null);
    }

    @Override
    public DispatcherResult dispatch(StepExecutionContext context, Dispatchable item) throws DispatcherException {
        return this.dispatch(context, null, item);
    }

    public DispatcherResult dispatch(StepExecutionContext context, NodeStepExecutionItem item, Dispatchable toDispatch) throws DispatcherException {
        HashMap<String, NodeStepResult> failureMap;
        HashMap<String, NodeStepResult> resultMap;
        boolean success;
        FailedNodesListener failedListener;
        HashSet<String> nodeNames;
        block10: {
            OrchestratorPlugin plugin;
            OrchestratorService orchestratorService = this.framework.getOrchestratorService();
            ServiceProviderLoader loader = orchestratorService.getPluginManager();
            OrchestratorConfig config = context.getOrchestrator();
            try {
                plugin = loader.loadProvider(orchestratorService, config.getType());
            }
            catch (ProviderLoaderException e) {
                throw new DispatcherException(e);
            }
            Description description = PluginAdapterUtility.buildDescription(plugin, DescriptionBuilder.builder());
            Map<String, Object> instanceProperties = null;
            if (config.getConfig() != null) {
                instanceProperties = DataContextUtils.replaceDataReferences(config.getConfig(), (Map<String, Map<String, String>>)context.getDataContext());
            }
            PropertyResolver resolver = PropertyResolverFactory.createFrameworkProjectRuntimeResolver(this.framework, context.getFrameworkProject(), instanceProperties, "Orchestrator", config.getType());
            PluginAdapterUtility.configureProperties(resolver, description, plugin, PropertyScope.InstanceOnly);
            INodeSet nodes = context.getNodes();
            boolean keepgoing = context.isKeepgoing();
            nodeNames = new HashSet<String>();
            failedListener = context.getExecutionListener().getFailedNodesListener();
            context.getExecutionListener().log(3, "preparing for orchestrator execution...(keepgoing? " + keepgoing + ", threads: " + context.getThreadCount() + ")");
            success = false;
            resultMap = new HashMap<String, NodeStepResult>();
            failureMap = new HashMap<String, NodeStepResult>();
            Collection<INodeEntry> nodes1 = nodes.getNodes();
            String rankProperty = null != context.getNodeRankAttribute() ? context.getNodeRankAttribute() : "nodename";
            boolean rankAscending = context.isNodeRankOrderAscending();
            INodeEntryComparator comparator = new INodeEntryComparator(rankProperty);
            TreeSet<INodeEntry> orderedNodes = new TreeSet<INodeEntry>(rankAscending ? comparator : Collections.reverseOrder(comparator));
            orderedNodes.addAll(nodes1);
            HashMap<INodeEntry, Callable<NodeStepResult>> executions = new HashMap<INodeEntry, Callable<NodeStepResult>>();
            for (INodeEntry node : orderedNodes) {
                Callable<NodeStepResult> tocall = null != item ? this.execItemCallable(context, item, resultMap, node, failureMap) : this.dispatchableCallable(context, toDispatch, resultMap, node, failureMap);
                nodeNames.add(node.getNodename());
                context.getExecutionListener().log(3, "Create task for node: " + node.getNodename());
                executions.put(node, tocall);
            }
            if (null != failedListener) {
                failedListener.matchedNodes(nodeNames);
            }
            context.getExecutionListener().log(3, "orchestrator dispatch to nodes: " + nodeNames);
            Orchestrator orchestrator = plugin.createOrchestrator(context, orderedNodes);
            OrchestratorNodeProcessor processor = new OrchestratorNodeProcessor(context.getThreadCount(), keepgoing, orchestrator, executions);
            try {
                success = processor.execute();
            }
            catch (ExecutionException e) {
                context.getExecutionListener().log(0, e.getMessage());
                if (keepgoing) break block10;
                throw new DispatcherException(e);
            }
        }
        if (failureMap.size() > 0) {
            if (null != failedListener) {
                failedListener.nodesFailed(failureMap);
            }
            return new DispatcherResultImpl(failureMap, false);
        }
        if (null != failedListener && nodeNames.isEmpty()) {
            failedListener.nodesSucceeded();
        }
        boolean status = success;
        return new DispatcherResultImpl(resultMap, status, "Orchestrator dispatch: (" + status + ") " + resultMap);
    }

    private Callable<NodeStepResult> dispatchableCallable(final ExecutionContext context, final Dispatchable toDispatch, final HashMap<String, NodeStepResult> resultMap, final INodeEntry node, final Map<String, NodeStepResult> failureMap) {
        return new Callable<NodeStepResult>(){

            @Override
            public NodeStepResult call() throws Exception {
                NodeStepResult dispatch = toDispatch.dispatch(context, node);
                if (!dispatch.isSuccess()) {
                    failureMap.put(node.getNodename(), dispatch);
                }
                resultMap.put(node.getNodename(), dispatch);
                return dispatch;
            }
        };
    }

    private ParallelNodeDispatcher.ExecNodeStepCallable execItemCallable(StepExecutionContext context, NodeStepExecutionItem item, HashMap<String, NodeStepResult> resultMap, INodeEntry node, Map<String, NodeStepResult> failureMap) {
        return new ParallelNodeDispatcher.ExecNodeStepCallable(context, item, resultMap, node, failureMap, this.framework);
    }
}

