/*
 * Decompiled with CFR 0.152.
 */
package com.dtolabs.rundeck.core.logging;

import com.dtolabs.rundeck.core.execution.ExecutionContext;
import com.dtolabs.rundeck.core.execution.ExecutionLogger;
import com.dtolabs.rundeck.core.execution.HasLoggingFilterConfiguration;
import com.dtolabs.rundeck.core.execution.StepExecutionItem;
import com.dtolabs.rundeck.core.logging.LoggingManager;
import com.dtolabs.rundeck.core.logging.OverridableStreamingLogWriter;
import com.dtolabs.rundeck.core.logging.PluginFilteredStreamingLogWriter;
import com.dtolabs.rundeck.core.logging.PluginLoggingManager;
import com.dtolabs.rundeck.core.plugins.PluginConfiguration;
import com.dtolabs.rundeck.core.plugins.SimplePluginProviderLoader;
import com.dtolabs.rundeck.plugins.logging.LogFilterPlugin;
import java.util.List;
import java.util.function.Supplier;

public class LoggingManagerImpl
implements LoggingManager {
    private final OverridableStreamingLogWriter writer;
    private final ExecutionLogger directLogger;
    private final SimplePluginProviderLoader<LogFilterPlugin> pluginLoader;
    private List<PluginConfiguration> globalPluginConfigs;

    public LoggingManagerImpl(OverridableStreamingLogWriter writer, ExecutionLogger directLogger, SimplePluginProviderLoader<LogFilterPlugin> pluginLoader, List<PluginConfiguration> globalPluginConfigs) {
        this.writer = writer;
        this.directLogger = directLogger;
        this.pluginLoader = pluginLoader;
        this.globalPluginConfigs = globalPluginConfigs;
    }

    @Override
    public PluginLoggingManager createPluginLogging(ExecutionContext context, StepExecutionItem step) {
        MyPluginLoggingManager myPluginLoggingManager = new MyPluginLoggingManager(new PluginFilteredStreamingLogWriter(this.writer.getWriter(), context, this.directLogger));
        this.installPlugins(myPluginLoggingManager, this.globalPluginConfigs);
        if (step != null) {
            HasLoggingFilterConfiguration.of(step).ifPresent(filtered -> {
                if (null != filtered.getFilterConfigurations()) {
                    this.installPlugins(myPluginLoggingManager, filtered.getFilterConfigurations());
                }
            });
        }
        return myPluginLoggingManager;
    }

    private void installPlugins(MyPluginLoggingManager myPluginLoggingManager, List<PluginConfiguration> filterConfigurations) {
        for (PluginConfiguration pluginConfiguration : filterConfigurations) {
            LogFilterPlugin load = this.pluginLoader.load(pluginConfiguration.getProvider(), pluginConfiguration.getConfiguration());
            if (load != null) {
                myPluginLoggingManager.installPlugin(load);
                continue;
            }
            throw new RuntimeException("Could not configure log filter plugin: " + pluginConfiguration + ": not found");
        }
    }

    private class MyPluginLoggingManager
    implements PluginLoggingManager {
        private final PluginFilteredStreamingLogWriter pluginFilteredStreamingLogWriter;
        boolean pluginsAdded = false;

        MyPluginLoggingManager(PluginFilteredStreamingLogWriter pluginFilteredStreamingLogWriter) {
            this.pluginFilteredStreamingLogWriter = pluginFilteredStreamingLogWriter;
        }

        private void installPlugin(LogFilterPlugin plugin) {
            this.pluginFilteredStreamingLogWriter.addPlugin(plugin);
            this.pluginsAdded = true;
        }

        @Override
        public <T> T runWith(Supplier<T> supplier) {
            this.begin();
            try {
                T t = supplier.get();
                return t;
            }
            finally {
                this.end();
            }
        }

        @Override
        public void begin() {
            if (this.pluginsAdded) {
                LoggingManagerImpl.this.writer.setOverride(this.pluginFilteredStreamingLogWriter);
            }
        }

        @Override
        public void end() {
            if (this.pluginsAdded) {
                LoggingManagerImpl.this.writer.removeOverride();
                this.pluginFilteredStreamingLogWriter.close();
            }
        }
    }
}

