/*
 * Decompiled with CFR 0.152.
 */
package com.dtolabs.rundeck.core.resources;

import com.dtolabs.rundeck.core.common.INodeSet;
import com.dtolabs.rundeck.core.resources.ExceptionCatchingResourceModelSource;
import com.dtolabs.rundeck.core.resources.ResourceModelSource;
import com.dtolabs.rundeck.core.resources.ResourceModelSourceCache;
import com.dtolabs.rundeck.core.resources.ResourceModelSourceException;
import com.dtolabs.rundeck.core.resources.SourceFactory;

public class CachingResourceModelSource
extends ExceptionCatchingResourceModelSource {
    private ResourceModelSourceCache cache;
    private SourceFactory.CacheType type = SourceFactory.CacheType.BOTH;

    public CachingResourceModelSource(ResourceModelSource delegate, ResourceModelSourceCache cache) {
        super(delegate);
        this.cache = cache;
    }

    public CachingResourceModelSource(ResourceModelSource delegate, String identity, ResourceModelSourceCache cache) {
        super(delegate, identity);
        this.cache = cache;
    }

    public CachingResourceModelSource(ResourceModelSource delegate, String identity, ExceptionCatchingResourceModelSource.ExceptionHandler handler, ResourceModelSourceCache cache) {
        this(delegate, identity, handler, cache, SourceFactory.CacheType.BOTH);
    }

    public CachingResourceModelSource(ResourceModelSource delegate, String identity, ExceptionCatchingResourceModelSource.ExceptionHandler handler, ResourceModelSourceCache cache, SourceFactory.CacheType type) {
        super(delegate, identity, handler);
        this.cache = cache;
        this.type = type;
    }

    @Override
    INodeSet returnResultNodes(INodeSet nodes) throws ResourceModelSourceException {
        if (null != nodes && this.type.isStoreType()) {
            this.cache.storeNodesInCache(nodes);
        }
        if (null == nodes && this.type.isLoadType()) {
            return this.cache.loadCachedNodes();
        }
        return nodes;
    }
}

