/*
 * Decompiled with CFR 0.152.
 */
package com.dtolabs.rundeck.core.common;

import com.dtolabs.rundeck.core.common.FrameworkResource;
import com.dtolabs.rundeck.core.common.FrameworkResourceException;
import com.dtolabs.rundeck.core.common.IFrameworkResource;
import com.dtolabs.rundeck.core.common.IFrameworkResourceParent;
import com.dtolabs.rundeck.core.utils.FileUtils;
import java.io.File;
import java.io.FilenameFilter;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;

public abstract class FrameworkResourceParent
extends FrameworkResource
implements IFrameworkResourceParent {
    public FrameworkResourceParent(String name, File dir, IFrameworkResourceParent parent) {
        super(name, dir, parent);
    }

    @Override
    public IFrameworkResource createChild(String name) {
        if (!name.matches("^[-_a-zA-Z0-9+][-\\._a-zA-Z0-9+]*$")) {
            throw new IllegalArgumentException("Child resource name \"" + name + "\" does not match: " + "^[-_a-zA-Z0-9+][-\\._a-zA-Z0-9+]*$");
        }
        FrameworkResource resource = new FrameworkResource(name, new File(this.getBaseDir(), name), this);
        if (!resource.getBaseDir().mkdirs()) {
            this.logger.warn((Object)("Unable to create basedir for resource: " + resource.getBaseDir()));
        }
        return resource;
    }

    @Override
    public IFrameworkResource getChild(String name) {
        IFrameworkResource o;
        if (this.childCouldBeLoaded(name) && null != (o = this.loadChild(name))) {
            return o;
        }
        throw new NoSuchResourceException("Framework resource not found: '" + name + "'" + ". basedir: " + this.getBaseDir().getAbsolutePath(), this);
    }

    protected Map getChildren() {
        HashMap<String, IFrameworkResource> map = new HashMap<String, IFrameworkResource>();
        for (String name : this.listChildNames()) {
            try {
                map.put(name, this.getChild(name));
            }
            catch (NoSuchResourceException noSuchResourceException) {}
        }
        return map;
    }

    @Override
    public boolean existsChild(String name) {
        if (null == name) {
            throw new IllegalArgumentException("name parameter for framework resource was null");
        }
        return this.childCouldBeLoaded(name);
    }

    @Override
    public Collection listChildren() {
        return this.getChildren().values();
    }

    @Override
    public void remove(String name) {
        IFrameworkResource resource;
        if (this.existsChild(name) && (resource = this.getChild(name)).getBaseDir().exists()) {
            FileUtils.deleteDir(resource.getBaseDir());
        }
    }

    @Override
    public void initialize() {
    }

    @Override
    public Collection<String> listChildNames() {
        HashSet<String> childnames = new HashSet<String>();
        FilenameFilter filter = new FilenameFilter(){

            @Override
            public boolean accept(File dir, String name) {
                return name.matches("^[-_a-zA-Z0-9+][-\\._a-zA-Z0-9+]*$");
            }
        };
        String[] list = this.getBaseDir().list(filter);
        if (null != list) {
            for (String aList : list) {
                File projectDir = new File(this.getBaseDir(), aList);
                String resName = projectDir.getName();
                if (!this.childCouldBeLoaded(resName)) continue;
                childnames.add(resName);
            }
        }
        return childnames;
    }

    @Override
    public boolean childCouldBeLoaded(String name) {
        return this.existsChildResourceDirectory(name);
    }

    @Override
    public boolean existsChildResourceDirectory(String name) {
        if (null == name) {
            throw new IllegalArgumentException("name parameter was null");
        }
        File file = new File(this.getBaseDir(), name);
        return file.exists() && file.isDirectory();
    }

    public static class NoSuchResourceException
    extends FrameworkResourceException {
        NoSuchResourceException(String message, IFrameworkResource resource) {
            super(message, resource);
        }

        NoSuchResourceException(String message, FrameworkResource resource, Throwable cause) {
            super(message, resource, cause);
        }
    }
}

