/*
 * Decompiled with CFR 0.152.
 */
package com.dtolabs.rundeck.core.execution.impl.local;

import com.dtolabs.rundeck.core.common.INodeEntry;
import com.dtolabs.rundeck.core.dispatcher.DataContextUtils;
import com.dtolabs.rundeck.core.execution.ExecutionContext;
import com.dtolabs.rundeck.core.execution.service.NodeExecutor;
import com.dtolabs.rundeck.core.execution.service.NodeExecutorResult;
import com.dtolabs.rundeck.core.execution.service.NodeExecutorResultImpl;
import com.dtolabs.rundeck.core.execution.workflow.steps.StepFailureReason;
import com.dtolabs.rundeck.core.execution.workflow.steps.node.NodeStepFailureReason;
import com.dtolabs.rundeck.core.utils.ScriptExecUtil;
import java.io.IOException;
import java.util.Map;

public class NewLocalNodeExecutor
implements NodeExecutor {
    public static final String SERVICE_PROVIDER_TYPE = "newlocal";

    @Override
    public NodeExecutorResult executeCommand(ExecutionContext context, String[] command, INodeEntry node) {
        int result;
        StringBuilder preview = new StringBuilder();
        for (String aCommand : command) {
            preview.append("'").append(aCommand).append("'");
        }
        context.getExecutionLogger().log(5, "NewLocalNodeExecutor, running command (" + command.length + "): " + preview.toString());
        Map<String, String> env = DataContextUtils.generateEnvVarsFromContext(context.getDataContext());
        try {
            result = ScriptExecUtil.runLocalCommand(command, env, null, System.out, System.err);
            if (result != 0) {
                return NodeExecutorResultImpl.createFailure(NodeStepFailureReason.NonZeroResultCode, "Result code was " + result, node, result);
            }
        }
        catch (IOException e) {
            return NodeExecutorResultImpl.createFailure(StepFailureReason.IOFailure, e.getMessage(), node);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            return NodeExecutorResultImpl.createFailure(StepFailureReason.Interrupted, e.getMessage(), node);
        }
        if (null != context.getOutputContext()) {
            context.getOutputContext().addOutput("exec", "exitCode", String.valueOf(result));
        }
        return NodeExecutorResultImpl.createSuccess(node);
    }
}

