/*
 * Decompiled with CFR 0.152.
 */
package com.dtolabs.rundeck.core.execution.workflow.steps.node;

import com.dtolabs.rundeck.core.common.INodeEntry;
import com.dtolabs.rundeck.core.dispatcher.DataContextUtils;
import com.dtolabs.rundeck.core.execution.ConfiguredStepExecutionItem;
import com.dtolabs.rundeck.core.execution.ExecArgList;
import com.dtolabs.rundeck.core.execution.ExecutionContext;
import com.dtolabs.rundeck.core.execution.ExecutionContextImpl;
import com.dtolabs.rundeck.core.execution.ExecutionService;
import com.dtolabs.rundeck.core.execution.StepExecutionItem;
import com.dtolabs.rundeck.core.execution.impl.common.BaseFileCopier;
import com.dtolabs.rundeck.core.execution.service.FileCopierException;
import com.dtolabs.rundeck.core.execution.workflow.StepExecutionContext;
import com.dtolabs.rundeck.core.execution.workflow.steps.PluginStepContextImpl;
import com.dtolabs.rundeck.core.execution.workflow.steps.StepFailureReason;
import com.dtolabs.rundeck.core.execution.workflow.steps.node.FileBasedGeneratedScript;
import com.dtolabs.rundeck.core.execution.workflow.steps.node.NodeStepException;
import com.dtolabs.rundeck.core.execution.workflow.steps.node.NodeStepExecutionItem;
import com.dtolabs.rundeck.core.execution.workflow.steps.node.NodeStepExecutor;
import com.dtolabs.rundeck.core.execution.workflow.steps.node.NodeStepResult;
import com.dtolabs.rundeck.core.execution.workflow.steps.node.NodeStepResultImpl;
import com.dtolabs.rundeck.core.execution.workflow.steps.node.impl.DefaultScriptFileNodeStepUtils;
import com.dtolabs.rundeck.core.execution.workflow.steps.node.impl.ScriptFileNodeStepUtils;
import com.dtolabs.rundeck.core.plugins.configuration.Describable;
import com.dtolabs.rundeck.core.plugins.configuration.Description;
import com.dtolabs.rundeck.core.plugins.configuration.PluginAdapterUtility;
import com.dtolabs.rundeck.core.plugins.configuration.PropertyResolver;
import com.dtolabs.rundeck.core.plugins.configuration.PropertyResolverFactory;
import com.dtolabs.rundeck.core.plugins.configuration.PropertyScope;
import com.dtolabs.rundeck.core.utils.Converter;
import com.dtolabs.rundeck.plugins.step.FileExtensionGeneratedScript;
import com.dtolabs.rundeck.plugins.step.GeneratedScript;
import com.dtolabs.rundeck.plugins.step.RemoteScriptNodeStepPlugin;
import com.dtolabs.rundeck.plugins.util.DescriptionBuilder;
import java.util.HashMap;
import java.util.Map;

class RemoteScriptNodeStepPluginAdapter
implements NodeStepExecutor,
Describable {
    private ScriptFileNodeStepUtils scriptUtils = new DefaultScriptFileNodeStepUtils();
    private RemoteScriptNodeStepPlugin plugin;
    public static final Convert CONVERTER = new Convert();

    @Override
    public Description getDescription() {
        if (this.plugin instanceof Describable) {
            Describable desc = (Describable)((Object)this.plugin);
            return desc.getDescription();
        }
        return PluginAdapterUtility.buildDescription(this.plugin, DescriptionBuilder.builder());
    }

    public RemoteScriptNodeStepPluginAdapter(RemoteScriptNodeStepPlugin plugin) {
        this.plugin = plugin;
    }

    public ScriptFileNodeStepUtils getScriptUtils() {
        return this.scriptUtils;
    }

    public void setScriptUtils(ScriptFileNodeStepUtils scriptUtils) {
        this.scriptUtils = scriptUtils;
    }

    @Override
    public NodeStepResult executeNodeStep(StepExecutionContext context, NodeStepExecutionItem item, INodeEntry node) throws NodeStepException {
        GeneratedScript script;
        Map<String, Object> instanceConfiguration = this.getStepConfiguration(item);
        if (null != instanceConfiguration) {
            instanceConfiguration = DataContextUtils.replaceDataReferences(instanceConfiguration, context.getDataContext(), null, false, true);
        }
        String providerName = item.getNodeStepType();
        PropertyResolver resolver = PropertyResolverFactory.createStepPluginRuntimeResolver(context, instanceConfiguration, "RemoteScriptNodeStep", providerName);
        PluginStepContextImpl pluginContext = PluginStepContextImpl.from(context);
        Description description = this.getDescription();
        Map<String, Object> config = PluginAdapterUtility.configureProperties(resolver, description, this.plugin, PropertyScope.InstanceOnly);
        try {
            script = this.plugin.generateScript(pluginContext, config, node);
        }
        catch (RuntimeException e) {
            return new NodeStepResultImpl(e, StepFailureReason.PluginFailed, e.getMessage(), node);
        }
        Map<String, Object> allconfig = PluginAdapterUtility.mapDescribedProperties(resolver, description);
        HashMap<String, String> stringconfig = new HashMap<String, String>();
        for (Map.Entry<String, Object> objectEntry : allconfig.entrySet()) {
            stringconfig.put(objectEntry.getKey(), objectEntry.getValue().toString());
        }
        return this.executeRemoteScript(ExecutionContextImpl.builder(context).setContext("config", stringconfig).build(), node, script, context.getDataContextObject().resolve("job", "execid"), providerName);
    }

    public NodeStepResult executeRemoteScript(StepExecutionContext context, INodeEntry node, GeneratedScript script, String ident, String providerName) throws NodeStepException {
        ExecutionService executionService = context.getFramework().getExecutionService();
        boolean expandTokens = true;
        if (context.getFramework().hasProperty("execution.script.tokenexpansion.enabled")) {
            expandTokens = "true".equals(context.getFramework().getProperty("execution.script.tokenexpansion.enabled"));
        }
        if (null != script.getCommand()) {
            return executionService.executeCommand((ExecutionContext)context, ExecArgList.fromStrings(DataContextUtils.stringContainsPropertyReferencePredicate, script.getCommand()), node);
        }
        if (null != script.getScript()) {
            String filepath;
            String destpath = BaseFileCopier.generateRemoteFilepathForNode(node, context.getFramework().getFrameworkProjectMgr().getFrameworkProject(context.getFrameworkProject()), context.getFramework(), providerName + "-script", RemoteScriptNodeStepPluginAdapter.getFileExtension(script), ident);
            try {
                filepath = executionService.fileCopyScriptContent(context, script.getScript(), node, destpath);
            }
            catch (FileCopierException e) {
                throw new NodeStepException(e.getMessage(), (Throwable)e, e.getFailureReason(), node.getNodename());
            }
            return this.scriptUtils.executeRemoteScript(context, context.getFramework(), node, script.getArgs(), filepath);
        }
        if (script instanceof FileBasedGeneratedScript) {
            FileBasedGeneratedScript fileScript = (FileBasedGeneratedScript)script;
            StepExecutionContext newcontext = fileScript.getConfigData() != null ? ExecutionContextImpl.builder(context).mergeContext("config", fileScript.getConfigData()).build() : context;
            return this.scriptUtils.executeScriptFile(newcontext, node, null, fileScript.getScriptFile().getAbsolutePath(), null, fileScript.getFileExtension(), fileScript.getArgs(), fileScript.getScriptInterpreter(), fileScript.isInterpreterArgsQuoted(), executionService, expandTokens);
        }
        return new NodeStepResultImpl(null, StepFailureReason.ConfigurationFailure, "Generated script must have a command or script defined", node);
    }

    private static String getFileExtension(GeneratedScript script) {
        if (script instanceof FileExtensionGeneratedScript) {
            return ((FileExtensionGeneratedScript)script).getFileExtension();
        }
        return null;
    }

    private Map<String, Object> getStepConfiguration(StepExecutionItem item) {
        if (item instanceof ConfiguredStepExecutionItem) {
            return ((ConfiguredStepExecutionItem)item).getStepConfiguration();
        }
        return null;
    }

    static class Convert
    implements Converter<RemoteScriptNodeStepPlugin, NodeStepExecutor> {
        Convert() {
        }

        @Override
        public NodeStepExecutor convert(RemoteScriptNodeStepPlugin plugin) {
            return new RemoteScriptNodeStepPluginAdapter(plugin);
        }
    }
}

