/*
 * Decompiled with CFR 0.152.
 */
package com.dtolabs.rundeck.core.execution.workflow.steps.node.impl;

import com.dtolabs.rundeck.core.common.Framework;
import com.dtolabs.rundeck.core.common.INodeEntry;
import com.dtolabs.rundeck.core.execution.ExecArgList;
import com.dtolabs.rundeck.core.execution.ExecutionContext;
import com.dtolabs.rundeck.core.execution.ExecutionService;
import com.dtolabs.rundeck.core.execution.impl.common.DefaultFileCopierUtil;
import com.dtolabs.rundeck.core.execution.impl.common.FileCopierUtil;
import com.dtolabs.rundeck.core.execution.script.ScriptfileUtils;
import com.dtolabs.rundeck.core.execution.service.FileCopierException;
import com.dtolabs.rundeck.core.execution.service.NodeExecutorResult;
import com.dtolabs.rundeck.core.execution.workflow.StepExecutionContext;
import com.dtolabs.rundeck.core.execution.workflow.steps.node.NodeStepException;
import com.dtolabs.rundeck.core.execution.workflow.steps.node.NodeStepResult;
import com.dtolabs.rundeck.core.execution.workflow.steps.node.impl.ScriptFileNodeStepUtils;
import com.dtolabs.rundeck.core.utils.ScriptExecUtil;
import java.io.File;
import java.io.InputStream;

public class DefaultScriptFileNodeStepUtils
implements ScriptFileNodeStepUtils {
    public static final String SCRIPT_FILE_REMOVE_TMP = "script-step-remove-tmp-file";
    private FileCopierUtil fileCopierUtil = new DefaultFileCopierUtil();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public NodeStepResult executeScriptFile(StepExecutionContext context, INodeEntry node, String scriptString, String serverScriptFilePath, InputStream scriptAsStream, String fileExtension, String[] args, String scriptInterpreter, boolean quoted, ExecutionService executionService, boolean expandTokens) throws NodeStepException {
        String filename = null != scriptString ? "dispatch-script.tmp" : (null != serverScriptFilePath ? new File(serverScriptFilePath).getName() : "dispatch-script.tmp");
        String ident = null != context.getDataContext() && null != context.getDataContext().get("job") ? context.getDataContext().get("job").get("execid") : null;
        String filepath = this.fileCopierUtil.generateRemoteFilepathForNode(node, context.getFramework().getFrameworkProjectMgr().getFrameworkProject(context.getFrameworkProject()), context.getFramework(), filename, fileExtension, ident);
        try {
            File temp = this.writeScriptToTempFile(context, node, scriptString, serverScriptFilePath, scriptAsStream, expandTokens);
            try {
                filepath = executionService.fileCopyFile(context, temp, node, filepath);
            }
            finally {
                ScriptfileUtils.releaseTempFile(temp);
            }
        }
        catch (FileCopierException e) {
            throw new NodeStepException(e.getMessage(), (Throwable)e, e.getFailureReason(), node.getNodename());
        }
        return this.executeRemoteScript(context, context.getFramework(), node, args, filepath, scriptInterpreter, quoted);
    }

    @Override
    public File writeScriptToTempFile(StepExecutionContext context, INodeEntry node, String scriptString, String serverScriptFilePath, InputStream scriptAsStream, boolean expandTokens) throws FileCopierException {
        File temp = null != scriptString ? this.fileCopierUtil.writeScriptTempFile(context, null, null, scriptString, node, expandTokens) : (null != serverScriptFilePath ? new File(serverScriptFilePath) : this.fileCopierUtil.writeScriptTempFile(context, null, scriptAsStream, null, node, expandTokens));
        return temp;
    }

    @Override
    public NodeStepResult executeRemoteScript(ExecutionContext context, Framework framework, INodeEntry node, String[] args, String filepath) throws NodeStepException {
        return this.executeRemoteScript(context, framework, node, args, filepath, null, false);
    }

    @Override
    public NodeStepResult executeRemoteScript(ExecutionContext context, Framework framework, INodeEntry node, String[] args, String filepath, String scriptInterpreter, boolean interpreterargsquoted) throws NodeStepException {
        boolean removeFile = true;
        if (null != node.getAttributes() && null != node.getAttributes().get(SCRIPT_FILE_REMOVE_TMP)) {
            removeFile = Boolean.parseBoolean(node.getAttributes().get(SCRIPT_FILE_REMOVE_TMP));
        }
        return this.executeRemoteScript(context, framework, node, args, filepath, scriptInterpreter, interpreterargsquoted, removeFile);
    }

    @Override
    public NodeStepResult executeRemoteScript(ExecutionContext context, Framework framework, INodeEntry node, String[] args, String filepath, String scriptInterpreter, boolean interpreterargsquoted, boolean removeFile) throws NodeStepException {
        NodeExecutorResult nodeExecutorResult2;
        NodeExecutorResult nodeExecutorResult;
        if (!"windows".equalsIgnoreCase(node.getOsFamily()) && !(nodeExecutorResult = framework.getExecutionService().executeCommand(context, ExecArgList.fromStrings(false, "chmod", "+x", filepath), node)).isSuccess()) {
            return nodeExecutorResult;
        }
        ExecArgList scriptArgList = ScriptExecUtil.createScriptArgList(filepath, null, args, scriptInterpreter, interpreterargsquoted);
        NodeExecutorResult nodeExecutorResult3 = framework.getExecutionService().executeCommand(context, scriptArgList, node);
        if (removeFile && !(nodeExecutorResult2 = framework.getExecutionService().executeCommand(context, this.removeArgsForOsFamily(filepath, node.getOsFamily()), node)).isSuccess() && null != context.getExecutionListener()) {
            context.getExecutionListener().log(1, "Failed to remove remote file: " + filepath);
        }
        return nodeExecutorResult3;
    }

    @Override
    public ExecArgList removeArgsForOsFamily(String filepath, String osFamily) {
        if ("windows".equalsIgnoreCase(osFamily)) {
            return ExecArgList.fromStrings(false, "del", filepath);
        }
        return ExecArgList.fromStrings(false, "rm", "-f", filepath);
    }

    public FileCopierUtil getFileCopierUtil() {
        return this.fileCopierUtil;
    }

    public void setFileCopierUtil(FileCopierUtil fileCopierUtil) {
        this.fileCopierUtil = fileCopierUtil;
    }
}

