/*
 * Decompiled with CFR 0.152.
 */
package com.dtolabs.rundeck.core.logging;

import com.dtolabs.rundeck.core.logging.FilterStreamingLogWriter;
import com.dtolabs.rundeck.core.logging.LogEvent;
import com.dtolabs.rundeck.core.logging.StreamingLogWriter;
import java.io.IOException;

public class OverridableStreamingLogWriter
extends FilterStreamingLogWriter {
    private final InheritableThreadLocal<StreamingLogWriter> override = new InheritableThreadLocal();

    public OverridableStreamingLogWriter(StreamingLogWriter writer) {
        super(writer);
    }

    @Override
    public void openStream() throws IOException {
        if (this.getOverride() != null) {
            this.getOverride().openStream();
            return;
        }
        super.openStream();
    }

    @Override
    public void addEvent(LogEvent event) {
        if (this.getOverride() != null) {
            this.getOverride().addEvent(event);
            return;
        }
        super.addEvent(event);
    }

    @Override
    public void close() {
        if (this.getOverride() != null) {
            this.getOverride().close();
            return;
        }
        super.close();
    }

    public StreamingLogWriter getOverride() {
        return (StreamingLogWriter)this.override.get();
    }

    public void setOverride(StreamingLogWriter writer) {
        this.override.set(writer);
    }

    public StreamingLogWriter removeOverride() {
        StreamingLogWriter previous = (StreamingLogWriter)this.override.get();
        this.override.remove();
        return previous;
    }
}

