/*
 * Decompiled with CFR 0.152.
 */
package com.dtolabs.rundeck.core.plugins;

import com.dtolabs.rundeck.core.Constants;
import com.dtolabs.rundeck.core.common.Framework;
import com.dtolabs.rundeck.core.data.BaseDataContext;
import com.dtolabs.rundeck.core.data.DataContext;
import java.io.File;
import java.util.Map;

public class ScriptDataContextUtil {
    private static File getVarDirForProject(Framework framework, String projectName) {
        return new File(Constants.getBaseVar(new File(framework.getFilesystemFramework().getFrameworkProjectsBaseDir(), projectName).getAbsolutePath()));
    }

    public static DataContext createScriptDataContext(Framework framework) {
        BaseDataContext data = new BaseDataContext();
        File vardir = new File(Constants.getBaseVar(framework.getFilesystemFramework().getBaseDir().getAbsolutePath()));
        File tmpdir = new File(vardir, "tmp");
        data.group("plugin").put("vardir", vardir.getAbsolutePath());
        data.group("plugin").put("tmpdir", tmpdir.getAbsolutePath());
        data.put("rundeck", "base", framework.getFilesystemFramework().getBaseDir().getAbsolutePath());
        return data;
    }

    public static Map<String, Map<String, String>> createScriptDataContextForProject(Framework framework, String projectName) {
        return ScriptDataContextUtil.createScriptDataContextObjectForProject(framework, projectName);
    }

    public static DataContext createScriptDataContextObjectForProject(Framework framework, String projectName) {
        BaseDataContext data = new BaseDataContext();
        data.merge(ScriptDataContextUtil.createScriptDataContext(framework));
        data.put("plugin", "vardir", ScriptDataContextUtil.getVarDirForProject(framework, projectName).getAbsolutePath());
        data.put("rundeck", "project", projectName);
        return data;
    }
}

