/*
 * Decompiled with CFR 0.152.
 */
package com.dtolabs.rundeck.core.plugins.configuration;

import com.dtolabs.rundeck.core.plugins.configuration.Property;
import com.dtolabs.rundeck.core.plugins.configuration.PropertyScope;
import com.dtolabs.rundeck.core.plugins.configuration.PropertyValidator;
import java.util.Collections;
import java.util.List;
import java.util.Map;

abstract class PropertyBase
implements Property {
    private final String title;
    private final String name;
    private final String description;
    private final boolean required;
    private final String defaultValue;
    private final PropertyValidator validator;
    private final PropertyScope scope;
    private final Map<String, Object> renderingOptions;

    public PropertyBase(String name, String title, String description, boolean required, String defaultValue, PropertyValidator validator) {
        this(name, title, description, required, defaultValue, validator, null);
    }

    public PropertyBase(String name, String title, String description, boolean required, String defaultValue, PropertyValidator validator, PropertyScope scope) {
        this(name, title, description, required, defaultValue, validator, scope, null);
    }

    public PropertyBase(String name, String title, String description, boolean required, String defaultValue, PropertyValidator validator, PropertyScope scope, Map<String, Object> renderingOptions) {
        this.title = title;
        this.name = name;
        this.description = description;
        this.required = required;
        this.defaultValue = defaultValue;
        this.validator = validator;
        this.scope = scope;
        this.renderingOptions = renderingOptions == null ? Collections.emptyMap() : Collections.unmodifiableMap(renderingOptions);
    }

    @Override
    public String getTitle() {
        return this.title;
    }

    @Override
    public String getDescription() {
        return this.description;
    }

    @Override
    public boolean isRequired() {
        return this.required;
    }

    @Override
    public String getDefaultValue() {
        return this.defaultValue;
    }

    @Override
    public List<String> getSelectValues() {
        return null;
    }

    @Override
    public Map<String, String> getSelectLabels() {
        return null;
    }

    @Override
    public PropertyValidator getValidator() {
        return this.validator;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public PropertyScope getScope() {
        return this.scope;
    }

    @Override
    public Map<String, Object> getRenderingOptions() {
        return this.renderingOptions;
    }

    public String toString() {
        return "PropertyBase{name='" + this.name + '\'' + (this.title != null ? ", title='" + this.title + '\'' : "") + (this.description != null ? ", description='" + this.description + '\'' : "") + ", required=" + this.required + (this.defaultValue != null ? ", defaultValue='" + this.defaultValue + '\'' : "") + (this.validator != null ? ", validator=" + this.validator : "") + (this.scope != null ? ", scope=" + (Object)((Object)this.scope) : "") + (this.renderingOptions != null ? ", renderingOptions=" + this.renderingOptions : "") + '}';
    }
}

