/*
 * Decompiled with CFR 0.152.
 */
package com.dtolabs.rundeck.core.plugins;

import com.dtolabs.rundeck.core.common.IFramework;
import com.dtolabs.rundeck.core.common.ProviderService;
import com.dtolabs.rundeck.core.execution.service.ExecutionServiceException;
import com.dtolabs.rundeck.core.execution.service.ProviderCreationException;
import com.dtolabs.rundeck.core.plugins.AbstractProviderRegistryService;
import com.dtolabs.rundeck.core.plugins.CloseableProvider;
import com.dtolabs.rundeck.core.plugins.Closeables;
import com.dtolabs.rundeck.core.plugins.ProviderRegistryService;
import java.lang.reflect.Constructor;
import java.util.Map;

public abstract class IFrameworkProviderRegistryService<T>
extends AbstractProviderRegistryService<T>
implements ProviderService<T>,
ProviderRegistryService<T> {
    protected final IFramework framework;

    public IFrameworkProviderRegistryService() {
        this((IFramework)null);
    }

    public IFrameworkProviderRegistryService(IFramework framework) {
        this.framework = framework;
    }

    public IFrameworkProviderRegistryService(IFramework framework, boolean cacheInstances) {
        super(cacheInstances);
        this.framework = framework;
    }

    public IFrameworkProviderRegistryService(IFramework framework, Map<String, Class<? extends T>> classes) {
        super(classes);
        this.framework = framework;
    }

    public IFrameworkProviderRegistryService(Map<String, Class<? extends T>> registry, IFramework framework, boolean cacheInstances) {
        super(registry, cacheInstances);
        this.framework = framework;
    }

    @Override
    public CloseableProvider<T> closeableProviderOfType(String providerName) throws ExecutionServiceException {
        Object t = this.providerOfType(providerName);
        if (t == null) {
            return null;
        }
        return Closeables.closeableProvider(t);
    }

    @Override
    protected T createProviderInstanceFromType(Class<? extends T> execClass, String providerName) throws ProviderCreationException {
        if (null != this.framework) {
            try {
                Constructor<T> method = execClass.getDeclaredConstructor(IFramework.class);
                return method.newInstance(this.framework);
            }
            catch (NoSuchMethodException method) {
            }
            catch (Exception e) {
                throw new ProviderCreationException("Unable to create provider instance: " + e.getMessage(), e, this.getName(), providerName);
            }
        }
        return super.createProviderInstanceFromType(execClass, providerName);
    }

    @Override
    protected boolean hasValidProviderSignature(Class<?> clazz) {
        if (null != this.framework) {
            try {
                Constructor<?> method = clazz.getDeclaredConstructor(IFramework.class);
                return null != method;
            }
            catch (NoSuchMethodException noSuchMethodException) {
                // empty catch block
            }
        }
        return super.hasValidProviderSignature(clazz);
    }
}

