/*
 * Decompiled with CFR 0.152.
 */
package com.dtolabs.rundeck.core.common;

import com.dtolabs.rundeck.core.common.FilesystemFramework;
import com.dtolabs.rundeck.core.common.FrameworkFactory;
import com.dtolabs.rundeck.core.common.FrameworkProject;
import com.dtolabs.rundeck.core.common.FrameworkResource;
import com.dtolabs.rundeck.core.common.IFrameworkProjectMgr;
import com.dtolabs.rundeck.core.common.IProjectNodesFactory;
import com.dtolabs.rundeck.core.common.IRundeckProject;
import com.dtolabs.rundeck.core.common.IRundeckProjectConfig;
import com.dtolabs.rundeck.core.common.NoSuchResourceException;
import java.io.File;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Properties;
import java.util.TreeSet;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FrameworkProjectMgr
extends FrameworkResource
implements IFrameworkProjectMgr {
    static final String PROJECTMGR_NAME = "frameworkProjectMgr";
    public static final Logger log = LoggerFactory.getLogger(FrameworkProjectMgr.class);
    private final FilesystemFramework filesystemFramework;
    private IProjectNodesFactory nodesFactory;
    final HashMap<String, FrameworkProject> projectCache = new HashMap();

    FrameworkProjectMgr(String name, File baseDir, FilesystemFramework filesystemFramework, IProjectNodesFactory nodesFactory) {
        super(name, baseDir);
        this.filesystemFramework = filesystemFramework;
        this.nodesFactory = nodesFactory;
    }

    FrameworkProjectMgr(String name, File baseDir, FilesystemFramework filesystemFramework) {
        super(name, baseDir);
        this.filesystemFramework = filesystemFramework;
    }

    @Override
    public IRundeckProject createFrameworkProject(String projectName) {
        return this.createFrameworkProjectInt(projectName);
    }

    @Override
    public FrameworkProject createFSFrameworkProject(String projectName) {
        return this.createFrameworkProjectInt(projectName);
    }

    public FilesystemFramework getFilesystemFramework() {
        return this.filesystemFramework;
    }

    @Override
    public IRundeckProject createFrameworkProject(String projectName, Properties properties) {
        return this.createFrameworkProjectInt(projectName, properties, false);
    }

    @Override
    public IRundeckProject createFrameworkProjectStrict(String projectName, Properties properties) {
        return this.createFrameworkProjectInt(projectName, properties, true);
    }

    private FrameworkProject createFrameworkProjectInt(String projectName) {
        return this.createFrameworkProjectInt(projectName, null, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private FrameworkProject createFrameworkProjectInt(String projectName, Properties properties, boolean strict) {
        FrameworkProject project;
        if (strict && this.existsFrameworkProject(projectName)) {
            throw new IllegalArgumentException("project exists: " + projectName);
        }
        HashMap<String, FrameworkProject> hashMap = this.projectCache;
        synchronized (hashMap) {
            if (null != this.projectCache.get(projectName)) {
                return this.projectCache.get(projectName);
            }
            project = FrameworkFactory.createFrameworkProject(projectName, new File(this.getBaseDir(), projectName), this.filesystemFramework, this, this.nodesFactory, properties);
            this.projectCache.put(projectName, project);
        }
        return project;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeFrameworkProject(String projectName) {
        HashMap<String, FrameworkProject> hashMap = this.projectCache;
        synchronized (hashMap) {
            this.removeSubDir(projectName);
            this.projectCache.remove(projectName);
        }
    }

    @Override
    public Collection<IRundeckProject> listFrameworkProjects() {
        return this.listChildren();
    }

    private Collection<IRundeckProject> listChildren() {
        return this.listChildDirs().stream().map(file -> this.createFrameworkProjectInt(file.getName())).collect(Collectors.toList());
    }

    @Override
    public Collection<String> listFrameworkProjectNames() {
        return new TreeSet<String>(this.listChildNames());
    }

    public List<String> listChildNames() {
        return this.listSubdirs().stream().filter(this::isValidProjectDir).map(File::getName).collect(Collectors.toList());
    }

    private List<File> listChildDirs() {
        return this.listSubdirs().stream().filter(this::isValidProjectDir).collect(Collectors.toList());
    }

    @Override
    public FrameworkProject getFrameworkProject(String name) {
        FrameworkProject frameworkProject = this.loadChild(name);
        if (null != frameworkProject) {
            return frameworkProject;
        }
        throw new NoSuchResourceException("Project does not exist: " + name, this);
    }

    @Override
    public IRundeckProjectConfig loadProjectConfig(String projectName) {
        return FrameworkFactory.loadFrameworkProjectConfig(projectName, new File(this.getBaseDir(), projectName), this.filesystemFramework, null);
    }

    @Override
    public boolean existsFrameworkProject(String project) {
        if (null == project) {
            throw new NullPointerException("project paramater was null");
        }
        return this.existsChild(project);
    }

    private boolean existsChild(String project) {
        return this.existsSubdir(project) && this.isValidProjectDir(new File(this.getBaseDir(), project));
    }

    private boolean isValidProjectDir(File dir) {
        return new File(dir, "etc/project.properties").isFile();
    }

    public boolean childCouldBeLoaded(String name) {
        return this.existsChild(name);
    }

    @Override
    public String toString() {
        return "FrameworkProjectMgr{name=" + this.getName() + ", baseDir=" + this.getBaseDir() + "}";
    }

    public Properties getProperties() {
        return new Properties();
    }

    public FrameworkProject loadChild(String name) {
        if (this.childCouldBeLoaded(name)) {
            return this.createFrameworkProjectInt(name);
        }
        return null;
    }

    public IProjectNodesFactory getNodesFactory() {
        return this.nodesFactory;
    }

    public void setNodesFactory(IProjectNodesFactory nodesFactory) {
        this.nodesFactory = nodesFactory;
    }
}

