/*
 * Decompiled with CFR 0.152.
 */
package com.dtolabs.rundeck.core.plugins;

import com.dtolabs.rundeck.core.plugins.PluginScanner;
import com.dtolabs.rundeck.core.plugins.PluginScannerException;
import com.dtolabs.rundeck.core.plugins.ProviderIdent;
import com.dtolabs.rundeck.core.plugins.ProviderLoader;
import com.dtolabs.rundeck.core.plugins.VersionCompare;
import com.dtolabs.rundeck.core.utils.StringArrayUtil;
import com.dtolabs.rundeck.core.utils.cache.FileCache;
import java.io.File;
import java.io.FileFilter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class DirPluginScanner
implements PluginScanner {
    static Logger log = LoggerFactory.getLogger((String)DirPluginScanner.class.getName());
    final File extdir;
    final FileCache<ProviderLoader> filecache;
    private HashSet<FileCache.MemoFile> scannedFiles = new HashSet();
    private HashMap<FileCache.MemoFile, Boolean> validity = new HashMap();

    protected DirPluginScanner(File extdir, FileCache<ProviderLoader> filecache) {
        this.extdir = extdir;
        this.filecache = filecache;
    }

    public abstract boolean isValidPluginFile(File var1);

    boolean cachedFileValidity(File file) {
        FileCache.MemoFile memo = FileCache.memoize(file);
        if (!this.validity.containsKey(memo)) {
            this.validity.put(memo, this.isValidPluginFile(file));
        }
        return this.validity.get(memo);
    }

    public abstract FileFilter getFileFilter();

    File resolveProviderConflict(Collection<FileCache.MemoFile> matched) {
        HashMap<File, VersionCompare> versions = new HashMap<File, VersionCompare>();
        ArrayList<File> toCompare = new ArrayList<File>();
        for (FileCache.MemoFile file : matched) {
            String vers = this.getVersionForFile(file.getFile());
            if (null == vers) continue;
            versions.put(file.getFile(), VersionCompare.forString(vers));
            toCompare.add(file.getFile());
        }
        VersionCompare.fileComparator c = new VersionCompare.fileComparator(versions);
        ArrayList sorted = new ArrayList(toCompare);
        Collections.sort(sorted, c);
        if (sorted.size() > 0) {
            return (File)sorted.get(sorted.size() - 1);
        }
        return null;
    }

    protected abstract String getVersionForFile(File var1);

    @Override
    public final File scanForFile(ProviderIdent ident) throws PluginScannerException {
        if (!this.extdir.exists() || !this.extdir.isDirectory()) {
            return null;
        }
        return this.scanFor(ident, this.extdir.listFiles(this.getFileFilter()));
    }

    @Override
    public List<ProviderIdent> listProviders() {
        File[] files;
        HashSet<ProviderIdent> providerIdentsHash = new HashSet<ProviderIdent>();
        ArrayList<ProviderIdent> providerIdents = new ArrayList<ProviderIdent>();
        if (null != this.extdir && this.extdir.isDirectory() && null != (files = this.extdir.listFiles(this.getFileFilter()))) {
            for (File file : files) {
                if (!this.cachedFileValidity(file)) continue;
                providerIdentsHash.addAll(this.listProviders(file));
            }
        }
        providerIdents.addAll(providerIdentsHash);
        return providerIdents;
    }

    @Override
    public boolean isExpired(ProviderIdent ident, File file) {
        return !file.exists() || !this.scannedFiles.contains(FileCache.memoize(file));
    }

    private void clearMemos(Set<FileCache.MemoFile> memos) {
        this.scannedFiles.removeAll(memos);
        for (FileCache.MemoFile memo : memos) {
            this.validity.remove(memo);
            this.filecache.remove(memo.getFile());
        }
    }

    private File scanFor(ProviderIdent ident, File[] files) throws PluginScannerException {
        ArrayList<FileCache.MemoFile> candidates = new ArrayList<FileCache.MemoFile>();
        HashSet<FileCache.MemoFile> prescanned = new HashSet<FileCache.MemoFile>(this.scannedFiles);
        HashSet<FileCache.MemoFile> newscanned = new HashSet<FileCache.MemoFile>();
        for (File file : files) {
            FileCache.MemoFile memo = FileCache.memoize(file);
            if (this.cachedFileValidity(file)) {
                newscanned.add(memo);
                if (this.test(ident, file)) {
                    candidates.add(memo);
                }
            }
            prescanned.remove(memo);
        }
        this.clearMemos(prescanned);
        this.scannedFiles = newscanned;
        if (candidates.size() == 1) {
            return ((FileCache.MemoFile)candidates.get(0)).getFile();
        }
        if (candidates.size() > 1) {
            File resolved = this.resolveProviderConflict(candidates);
            if (null == resolved) {
                log.warn("More than one plugin file matched: " + StringArrayUtil.asString(candidates.toArray(), ",") + ": " + ident);
            } else {
                return resolved;
            }
        }
        return null;
    }

    private boolean test(ProviderIdent ident, File file) {
        ProviderLoader fileProviderLoader = this.filecache.get(file, this);
        boolean loaderFor = null != fileProviderLoader && fileProviderLoader.isLoaderFor(ident);
        return null != fileProviderLoader && loaderFor;
    }

    private List<ProviderIdent> listProviders(File file) {
        ProviderLoader fileProviderLoader = this.filecache.get(file, this);
        return fileProviderLoader.listProviders();
    }

    private void debug(String s) {
        if (log.isDebugEnabled()) {
            log.debug(s);
        }
    }
}

