/*
 * Decompiled with CFR 0.152.
 */
package com.dtolabs.rundeck.core.utils;

import com.dtolabs.rundeck.core.cli.CLIUtils;
import com.dtolabs.rundeck.core.common.INodeEntry;
import com.dtolabs.rundeck.core.dispatcher.DataContextUtils;
import com.dtolabs.rundeck.core.execution.ExecArgList;
import com.dtolabs.rundeck.core.utils.Converter;
import com.dtolabs.rundeck.core.utils.OptsUtil;
import com.dtolabs.rundeck.core.utils.ScriptExecHelper;
import com.dtolabs.utils.Streams;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.function.Predicate;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.tools.ant.taskdefs.Execute;

public class ScriptExecUtil {
    static final Predicate needsQuoting = DataContextUtils.stringContainsPropertyReferencePredicate.or(CLIUtils::containsSpace).or(CLIUtils::containsQuote);

    public static ScriptExecHelper helper() {
        return new ScriptExecHelper(){

            @Override
            public int runLocalCommand(String osFamily, ExecArgList execArgList, Map<String, Map<String, String>> dataContext, File workingdir, OutputStream outputStream, OutputStream errorStream) throws IOException, InterruptedException {
                return ScriptExecUtil.runLocalCommand(osFamily, execArgList, dataContext, workingdir, outputStream, errorStream);
            }

            @Override
            public int runLocalCommand(String[] command, Map<String, String> envMap, File workingdir, OutputStream outputStream, OutputStream errorStream) throws IOException, InterruptedException {
                return ScriptExecUtil.runLocalCommand(command, envMap, workingdir, outputStream, errorStream);
            }

            @Override
            public String[] createScriptArgs(Map<String, Map<String, String>> localDataContext, String scriptargs, String[] scriptargsarr, String scriptinterpreter, boolean interpreterargsquoted, String filepath) {
                return ScriptExecUtil.createScriptArgs(localDataContext, null, scriptargs, scriptargsarr, scriptinterpreter, interpreterargsquoted, filepath);
            }

            @Override
            public String[] createScriptArgs(Map<String, Map<String, String>> localDataContext, String scriptargs, String[] scriptargsarr, String scriptinterpreter, boolean interpreterargsquoted) {
                return ScriptExecUtil.createScriptArgs(localDataContext, null, scriptargs, scriptargsarr, scriptinterpreter, interpreterargsquoted);
            }

            @Override
            public String[] createScriptArgs(Map<String, Map<String, String>> localDataContext, INodeEntry node, String scriptargs, String[] scriptargsarr, String scriptinterpreter, boolean interpreterargsquoted, String filepath) {
                return ScriptExecUtil.createScriptArgs(localDataContext, node, scriptargs, scriptargsarr, scriptinterpreter, interpreterargsquoted, filepath);
            }

            @Override
            public ExecArgList createScriptArgList(String filepath, String scriptargs, String[] scriptargsarr, String scriptinterpreter, boolean interpreterargsquoted) {
                return ScriptExecUtil.createScriptArgList(filepath, scriptargs, scriptargsarr, scriptinterpreter, interpreterargsquoted);
            }

            @Override
            public Map<String, String> loadLocalEnvironment() {
                return ScriptExecUtil.loadLocalEnvironment();
            }
        };
    }

    public static int runLocalCommand(String osFamily, ExecArgList execArgList, Map<String, Map<String, String>> dataContext, File workingdir, OutputStream outputStream, OutputStream errorStream) throws IOException, InterruptedException {
        Map<String, String> envVars = DataContextUtils.generateEnvVarsFromContext(dataContext);
        ArrayList<String> strings = execArgList.buildCommandForNode(dataContext, osFamily);
        return ScriptExecUtil.runLocalCommand(strings.toArray(new String[strings.size()]), envVars, workingdir, outputStream, errorStream);
    }

    public static int runLocalCommand(String[] command, Map<String, String> envMap, File workingdir, OutputStream outputStream, OutputStream errorStream) throws IOException, InterruptedException {
        String[] envarr = ScriptExecUtil.createEnvironmentArray(envMap);
        Runtime runtime = Runtime.getRuntime();
        Process exec = runtime.exec(command, envarr, workingdir);
        exec.getOutputStream().close();
        Streams.StreamCopyThread errthread = Streams.copyStreamThread(exec.getErrorStream(), errorStream);
        Streams.StreamCopyThread outthread = Streams.copyStreamThread(exec.getInputStream(), outputStream);
        errthread.start();
        outthread.start();
        int result = exec.waitFor();
        outputStream.flush();
        errorStream.flush();
        errthread.join();
        outthread.join();
        exec.getInputStream().close();
        exec.getErrorStream().close();
        if (null != outthread.getException()) {
            throw outthread.getException();
        }
        if (null != errthread.getException()) {
            throw errthread.getException();
        }
        return result;
    }

    public static Map<String, String> loadLocalEnvironment() {
        return Execute.getEnvironmentVariables();
    }

    private static String[] createEnvironmentArray(Map<String, String> envMap) {
        ArrayList<String> envlist = new ArrayList<String>();
        for (Map.Entry<String, String> entry : envMap.entrySet()) {
            envlist.add(entry.getKey() + "=" + entry.getValue());
        }
        return envlist.toArray(new String[envlist.size()]);
    }

    public static String[] createScriptArgs(Map<String, Map<String, String>> localDataContext, String scriptargs, String[] scriptargsarr, String scriptinterpreter, boolean interpreterargsquoted, String filepath) {
        return ScriptExecUtil.createScriptArgs(localDataContext, null, scriptargs, scriptargsarr, scriptinterpreter, interpreterargsquoted, filepath);
    }

    public static ExecArgList createScriptArgList(String filepath, String scriptargs, String[] scriptargsarr, String scriptinterpreter, boolean interpreterargsquoted) {
        ExecArgList.Builder builder = ExecArgList.builder();
        boolean seenFilepath = false;
        if (null != scriptinterpreter) {
            String[] burst = OptsUtil.burst(scriptinterpreter);
            ArrayList<String> args = new ArrayList<String>();
            for (String arg : burst) {
                if (arg.contains("${scriptfile}")) {
                    args.add(arg.replaceAll(Pattern.quote("${scriptfile}"), Matcher.quoteReplacement(filepath)));
                    seenFilepath = true;
                    continue;
                }
                args.add(arg);
            }
            builder.args(args, false);
        }
        if (null != scriptinterpreter && interpreterargsquoted) {
            ExecArgList.Builder sub = builder.subList(true);
            ScriptExecUtil.addScriptFileArgList(seenFilepath ? null : filepath, scriptargs, scriptargsarr, sub, needsQuoting);
            sub.parent();
        } else {
            ScriptExecUtil.addScriptFileArgList(seenFilepath ? null : filepath, scriptargs, scriptargsarr, builder, needsQuoting);
        }
        return builder.build();
    }

    private static void addScriptFileArgList(String filepath, String scriptargs, String[] scriptargsarr, ExecArgList.Builder builder, Predicate quoted) {
        if (null != filepath) {
            builder.arg(filepath, false);
        }
        if (null != scriptargs) {
            builder.args(OptsUtil.burst(scriptargs), quoted);
        } else if (null != scriptargsarr) {
            builder.args(scriptargsarr, quoted);
        }
    }

    public static String[] createScriptArgs(Map<String, Map<String, String>> localDataContext, INodeEntry node, String scriptargs, String[] scriptargsarr, String scriptinterpreter, boolean interpreterargsquoted) {
        return ScriptExecUtil.createScriptArgs(localDataContext, node, scriptargs, scriptargsarr, scriptinterpreter, interpreterargsquoted, null);
    }

    public static String[] createScriptArgs(Map<String, Map<String, String>> localDataContext, INodeEntry node, String scriptargs, String[] scriptargsarr, String scriptinterpreter, boolean interpreterargsquoted, String filepath) {
        ArrayList<String> arglist = new ArrayList<String>();
        if (null != scriptinterpreter) {
            List<String> c = Arrays.asList(DataContextUtils.replaceDataReferencesInArray(OptsUtil.burst(scriptinterpreter), localDataContext, null, false, true));
            arglist.addAll(c);
        }
        if (null != scriptinterpreter && interpreterargsquoted) {
            ArrayList<String> sublist = new ArrayList<String>();
            if (filepath != null) {
                sublist.add(filepath);
            }
            ScriptExecUtil.addQuotedArgs(localDataContext, node, scriptargs, scriptargsarr, sublist, true);
            arglist.add(DataContextUtils.join(sublist, " "));
        } else {
            if (filepath != null) {
                arglist.add(filepath);
            }
            ScriptExecUtil.addQuotedArgs(localDataContext, node, scriptargs, scriptargsarr, arglist, false);
        }
        return arglist.toArray(new String[arglist.size()]);
    }

    private static void addQuotedArgs(Map<String, Map<String, String>> localDataContext, INodeEntry node, String scriptargs, String[] scriptargsarr, ArrayList<String> arglist, boolean quoted) {
        if (null != scriptargs) {
            arglist.addAll(Arrays.asList(DataContextUtils.replaceDataReferencesInArray(scriptargs.split(" "), localDataContext)));
        } else if (null != scriptargsarr) {
            if (!quoted) {
                arglist.addAll(Arrays.asList(scriptargsarr));
            } else {
                String[] newargs = DataContextUtils.replaceDataReferencesInArray(scriptargsarr, localDataContext);
                Converter<String, String> quote = ScriptExecUtil.getQuoteConverterForNode(node);
                for (int i = 0; i < newargs.length; ++i) {
                    String replaced = newargs[i];
                    if (null != quote && (!replaced.equals(scriptargsarr[i]) || CLIUtils.containsSpace(replaced))) {
                        arglist.add(quote.convert(replaced));
                        continue;
                    }
                    arglist.add(replaced);
                }
            }
        }
    }

    private static Converter<String, String> getQuoteConverterForNode(INodeEntry node) {
        Converter<String, String> quote = null != node ? CLIUtils.argumentQuoteForOperatingSystem(node.getOsFamily()) : CLIUtils.argumentQuoteForOperatingSystem(null);
        return quote;
    }
}

