/*
 * Decompiled with CFR 0.152.
 */
package org.rundeck.app.components.jobs;

import java.io.Reader;
import java.io.Writer;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.rundeck.app.components.jobs.JobDefinitionException;

public interface JobFormat {
    public String getFormat();

    public List<Map> decode(Reader var1) throws JobDefinitionException;

    public void encode(List<Map> var1, Options var2, Writer var3);

    public static Options options(boolean preserveUuid, Map<String, String> replaceIds, String stripJobRef) {
        return JobFormat.options(preserveUuid, replaceIds, null != stripJobRef ? StripJobRef.valueOf(stripJobRef) : null);
    }

    public static Options options(final boolean preserveUuid, final Map<String, String> replaceIds, final StripJobRef stripJobRef) {
        return new Options(){

            @Override
            public boolean isPreserveUuid() {
                return preserveUuid;
            }

            @Override
            public Map<String, String> getReplaceIds() {
                return replaceIds;
            }

            @Override
            public StripJobRef getStripJobRef() {
                return stripJobRef;
            }
        };
    }

    public static Options defaultOptions() {
        return JobFormat.options(true, new HashMap<String, String>(), (StripJobRef)null);
    }

    public static enum StripJobRef {
        uuid,
        name;

    }

    public static interface Options {
        public boolean isPreserveUuid();

        public Map<String, String> getReplaceIds();

        public StripJobRef getStripJobRef();
    }
}

