/*
 * Decompiled with CFR 0.152.
 */
package com.dtolabs.rundeck.core;

import java.io.File;

public final class Constants {
    public static final String MSG_DEBUG = "debug";
    public static final String MSG_ERR = "error";
    public static final String MSG_INFO = "info";
    public static final String MSG_WARN = "warn";
    public static final String MSG_VERBOSE = "verbose";
    public static final int ERR_LEVEL = 0;
    public static final int WARN_LEVEL = 1;
    public static final int INFO_LEVEL = 2;
    public static final int VERBOSE_LEVEL = 3;
    public static final int DEBUG_LEVEL = 4;
    public static final String FILE_SEP = System.getProperty("file.separator");
    public static final String JAVA_HOME = System.getProperty("java.home");
    public static final String DEFAULT_NODE_AUTHSTRATEGY_CLASSNAME = "com.dtolabs.rundeck.core.authentication.DefaultNodeAuthResolutionStrategy";
    public static final String SSH_KEYPATH_PROP = "framework.ssh.keypath";
    public static final String SSH_KEYRESOURCE_PROP = "framework.ssh.key.resource";
    public static final String SSH_USER_PROP = "framework.ssh.user";

    public static String getSystemBaseDir() {
        return System.getProperty("rdeck.base");
    }

    public static String getFrameworkConfigDir(String rdeck_base) {
        return System.getProperty("rdeck.config", rdeck_base + FILE_SEP + "etc");
    }

    public static String getFrameworkConfigDir() {
        return Constants.getFrameworkConfigDir(Constants.getSystemBaseDir());
    }

    public static File getFrameworkConfigFile() {
        return new File(Constants.getFrameworkConfigDir());
    }

    public static String getFrameworkProperties(String rdeck_base) {
        return Constants.getFrameworkConfigDir(rdeck_base) + FILE_SEP + "framework.properties";
    }

    public static String getDefaultsPropertiesName() {
        return "run-defaults.properties";
    }

    public static String getFrameworkPreferences(String rdeck_base) {
        return Constants.getFrameworkConfigDir(rdeck_base) + FILE_SEP + "preferences.properties";
    }

    public static String getBaseVar(String rdeck_base) {
        return rdeck_base + FILE_SEP + "var";
    }

    public static String getBaseTempDirectory() {
        return Constants.getBaseTempDirectory(Constants.getSystemBaseDir());
    }

    public static String getBaseTempDirectory(String rdeck_base) {
        return Constants.getBaseVar(rdeck_base) + FILE_SEP + "tmp";
    }

    public static String getFrameworkProjectsDir(String rdeck_base) {
        return System.getProperty("rdeck.projects", rdeck_base + FILE_SEP + "projects");
    }

    public static String getFrameworkLogsDir(String rdeck_base) {
        return System.getProperty("rdeck.runlogs", Constants.getBaseVar(rdeck_base) + FILE_SEP + "logs");
    }
}

