/*
 * Decompiled with CFR 0.152.
 */
package com.dtolabs.rundeck.core.execution.dispatch;

import com.dtolabs.rundeck.core.common.Framework;
import com.dtolabs.rundeck.core.execution.ExecutionContext;
import com.dtolabs.rundeck.core.execution.dispatch.NodeDispatcher;
import com.dtolabs.rundeck.core.execution.dispatch.OrchestratorNodeDispatcher;
import com.dtolabs.rundeck.core.execution.dispatch.ParallelNodeDispatcher;
import com.dtolabs.rundeck.core.execution.dispatch.SequentialNodeDispatcher;
import com.dtolabs.rundeck.core.execution.service.ExecutionServiceException;
import com.dtolabs.rundeck.core.plugins.BaseProviderRegistryService;

public class NodeDispatcherService
extends BaseProviderRegistryService<NodeDispatcher> {
    private static final String SERVICE_NAME = "NodeDispatcher";

    public NodeDispatcherService(Framework framework) {
        super(framework);
        this.registry.put("parallel", ParallelNodeDispatcher.class);
        this.registry.put("sequential", SequentialNodeDispatcher.class);
        this.registry.put("orchestrator", OrchestratorNodeDispatcher.class);
    }

    public NodeDispatcher getNodeDispatcher(ExecutionContext context) throws ExecutionServiceException {
        if (context.getOrchestrator() != null) {
            return (NodeDispatcher)this.providerOfType("orchestrator");
        }
        if (context.getThreadCount() > 1 && context.getNodes().getNodeNames().size() > 1) {
            return (NodeDispatcher)this.providerOfType("parallel");
        }
        return (NodeDispatcher)this.providerOfType("sequential");
    }

    public static NodeDispatcherService getInstanceForFramework(Framework framework) {
        if (null == framework.getService(SERVICE_NAME)) {
            NodeDispatcherService service = new NodeDispatcherService(framework);
            framework.setService(SERVICE_NAME, service);
            return service;
        }
        return (NodeDispatcherService)framework.getService(SERVICE_NAME);
    }

    @Override
    public String getName() {
        return SERVICE_NAME;
    }
}

