/*
 * Decompiled with CFR 0.152.
 */
package com.dtolabs.rundeck.core.rules;

import com.dtolabs.rundeck.core.rules.MutableStateObj;
import com.dtolabs.rundeck.core.rules.RuleEngine;
import com.dtolabs.rundeck.core.rules.WorkflowEngine;
import com.dtolabs.rundeck.core.rules.WorkflowSystem;
import com.dtolabs.rundeck.core.rules.WorkflowSystemBuilder;
import com.dtolabs.rundeck.core.rules.WorkflowSystemEventListener;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import java.util.function.Supplier;

public class WorkflowEngineBuilder
implements WorkflowSystemBuilder {
    private RuleEngine engine;
    private MutableStateObj state;
    private Supplier<ExecutorService> executor;
    private List<WorkflowSystemEventListener> listeners = new ArrayList<WorkflowSystemEventListener>();

    public static WorkflowEngineBuilder builder(WorkflowEngineBuilder source) {
        WorkflowEngineBuilder workflowSystemBuilder = new WorkflowEngineBuilder();
        workflowSystemBuilder.engine = source.engine;
        workflowSystemBuilder.state = source.state;
        workflowSystemBuilder.executor = source.executor;
        workflowSystemBuilder.listeners = new ArrayList<WorkflowSystemEventListener>(source.listeners);
        return workflowSystemBuilder;
    }

    public static WorkflowEngineBuilder builder() {
        return new WorkflowEngineBuilder();
    }

    @Override
    public WorkflowEngineBuilder ruleEngine(RuleEngine engine) {
        this.engine = engine;
        return this;
    }

    @Override
    public WorkflowEngineBuilder state(MutableStateObj state) {
        this.state = state;
        return this;
    }

    @Override
    public WorkflowEngineBuilder executor(Supplier<ExecutorService> executor) {
        this.executor = executor;
        return this;
    }

    @Override
    public WorkflowEngineBuilder listener(WorkflowSystemEventListener listener) {
        this.listeners.add(listener);
        return this;
    }

    @Override
    public WorkflowSystemBuilder listeners(List<WorkflowSystemEventListener> listeners) {
        this.listeners.addAll(listeners);
        return this;
    }

    @Override
    public WorkflowSystem<Map<String, String>> build() {
        if (null == this.engine || null == this.state || null == this.executor) {
            throw new IllegalArgumentException();
        }
        WorkflowEngine workflowEngine = new WorkflowEngine(this.engine, this.state, this.executor.get());
        workflowEngine.setListeners(this.listeners);
        return workflowEngine;
    }
}

