/*
 * Decompiled with CFR 0.152.
 */
package com.dtolabs.rundeck.core.utils;

import com.jcraft.jsch.agentproxy.AgentProxyException;
import java.io.IOException;
import java.io.InputStream;

public class SSHAgentProcess {
    private String socketPath;
    private Integer pid;

    public String getSocketPath() {
        return this.socketPath;
    }

    public void setSocketPath(String socketPath) {
        this.socketPath = socketPath;
    }

    public SSHAgentProcess() throws AgentProxyException {
        this("/usr/bin/ssh-agent", 0);
    }

    public SSHAgentProcess(Integer timeToLive) throws AgentProxyException {
        this("/usr/bin/ssh-agent", timeToLive);
    }

    public SSHAgentProcess(String sshAgentPath, Integer timeToLive) throws AgentProxyException {
        ProcessBuilder builder = timeToLive > 0 ? new ProcessBuilder(sshAgentPath, "-t", timeToLive.toString()) : new ProcessBuilder(sshAgentPath);
        builder.redirectErrorStream(true);
        try {
            Process process = builder.start();
            InputStream is = process.getInputStream();
            byte[] buff = new byte[2048];
            is.read(buff);
            is.close();
            String agentOutput = new String(buff);
            String[] splitAgentOutput = agentOutput.split(";");
            String[] splitSocketPath = splitAgentOutput[0].split("=");
            this.socketPath = splitSocketPath[1];
            String[] splitAgentPid = splitAgentOutput[2].split("=");
            this.pid = Integer.valueOf(splitAgentPid[1]);
        }
        catch (Exception e) {
            throw new AgentProxyException("Unable to parse ssh-agent output.");
        }
    }

    public void stopAgent() throws IOException {
        if (this.pid != null) {
            Runtime.getRuntime().exec("kill " + this.pid);
        }
    }
}

