/*
 * Decompiled with CFR 0.152.
 */
package com.dtolabs.rundeck.core.authorization;

import com.dtolabs.rundeck.core.authentication.Group;
import com.dtolabs.rundeck.core.authentication.Username;
import com.dtolabs.rundeck.core.authorization.AclsUtil;
import com.dtolabs.rundeck.core.authorization.Attribute;
import com.dtolabs.rundeck.core.authorization.Authorization;
import com.dtolabs.rundeck.core.authorization.Decision;
import com.dtolabs.rundeck.core.authorization.UserAndRolesAuthContext;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.security.auth.Subject;

public class SubjectAuthContext
implements UserAndRolesAuthContext {
    private Subject subject;
    private Authorization authorization;

    public SubjectAuthContext(Subject subject, Authorization authorization) {
        this.subject = subject;
        this.authorization = authorization;
    }

    public String getUsername() {
        Set<Username> principals = this.subject.getPrincipals(Username.class);
        if (principals != null && principals.size() > 0) {
            return principals.iterator().next().getName();
        }
        return null;
    }

    public Set<String> getRoles() {
        Set<Group> principals = this.subject.getPrincipals(Group.class);
        HashSet<String> roles = new HashSet<String>();
        if (principals.size() > 0) {
            for (Group principal : principals) {
                roles.add(principal.getName());
            }
        }
        return roles;
    }

    public UserAndRolesAuthContext combineWith(Authorization authorization) {
        return new SubjectAuthContext(this.subject, (Authorization)AclsUtil.append(this.authorization, authorization));
    }

    public Decision evaluate(Map<String, String> resource, String action, Set<Attribute> environment) {
        return this.authorization.evaluate(resource, this.subject, action, environment);
    }

    public Set<Decision> evaluate(Set<Map<String, String>> resources, Set<String> actions, Set<Attribute> environment) {
        return this.authorization.evaluate(resources, this.subject, actions, environment);
    }
}

