/*
 * Decompiled with CFR 0.152.
 */
package com.dtolabs.rundeck.core.resources.format;

import com.dtolabs.rundeck.core.common.INodeSet;
import com.dtolabs.rundeck.core.common.NodeFileParserException;
import com.dtolabs.rundeck.core.common.NodeReceiver;
import com.dtolabs.rundeck.core.common.NodeSetImpl;
import com.dtolabs.rundeck.core.common.NodesXMLParser;
import com.dtolabs.rundeck.core.plugins.Plugin;
import com.dtolabs.rundeck.core.plugins.configuration.Describable;
import com.dtolabs.rundeck.core.plugins.configuration.Description;
import com.dtolabs.rundeck.core.resources.format.ResourceFormatParser;
import com.dtolabs.rundeck.core.resources.format.ResourceFormatParserException;
import com.dtolabs.rundeck.plugins.util.DescriptionBuilder;
import java.io.File;
import java.io.InputStream;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;

@Plugin(name="resourcexml", service="ResourceFormatParser")
public class ResourceXMLFormatParser
implements ResourceFormatParser,
Describable {
    public static final String SERVICE_PROVIDER_TYPE = "resourcexml";
    public static final Set<String> EXTENSIONS = Collections.unmodifiableSet(new HashSet<String>(Arrays.asList("xml")));
    public static final Set<String> MIME_TYPES = Collections.unmodifiableSet(new HashSet<String>(Arrays.asList("text/xml", "*/xml")));
    private static final Description DESCRIPTION = DescriptionBuilder.builder().name("resourcexml").title("Resource XML").description("The Rundeck Resource XML format 1.3 (bundled)").build();

    @Override
    public Set<String> getFileExtensions() {
        return EXTENSIONS;
    }

    @Override
    public String getPreferredFileExtension() {
        return "xml";
    }

    @Override
    public String getPreferredMimeType() {
        return "text/xml";
    }

    @Override
    public Set<String> getMIMETypes() {
        return MIME_TYPES;
    }

    @Override
    public INodeSet parseDocument(File file) throws ResourceFormatParserException {
        NodeSetImpl nodeReceiver = new NodeSetImpl();
        try {
            new NodesXMLParser(file, (NodeReceiver)nodeReceiver).parse();
        }
        catch (NodeFileParserException e) {
            throw new ResourceFormatParserException(e);
        }
        return nodeReceiver;
    }

    @Override
    public INodeSet parseDocument(InputStream input) throws ResourceFormatParserException {
        NodeSetImpl nodeReceiver = new NodeSetImpl();
        try {
            new NodesXMLParser(input, (NodeReceiver)nodeReceiver).parse();
        }
        catch (NodeFileParserException e) {
            throw new ResourceFormatParserException(e);
        }
        return nodeReceiver;
    }

    @Override
    public Description getDescription() {
        return DESCRIPTION;
    }
}

